<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "production_employee_view" table
 */
#[Entity]
#[Table(name: "production_employee_view")]
class ProductionEmployeeView extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $uid;

    #[Column(type: "integer")]
    private int $id;

    #[Column(type: "string")]
    private string $grp;

    #[Column(type: "string")]
    private string $site;

    #[Column(name: "user_name", type: "string", nullable: true)]
    private ?string $userName;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dob;

    #[Column(type: "integer")]
    private int $salary;

    #[Column(type: "string", nullable: true)]
    private ?string $address;

    #[Column(type: "bigint", nullable: true)]
    private ?string $mobile;

    #[Column(type: "integer")]
    private int $category;

    #[Column(type: "string", nullable: true)]
    private ?string $process;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->grp = "3";
        $this->site = "0";
        $this->salary = 0;
        $this->status = 1;
        $this->operator = 0;
    }

    public function getUid(): int
    {
        return $this->uid;
    }

    public function setUid(int $value): static
    {
        $this->uid = $value;
        return $this;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): string
    {
        return HtmlDecode($this->grp);
    }

    public function setGrp(string $value): static
    {
        $this->grp = RemoveXss($value);
        return $this;
    }

    public function getSite(): string
    {
        return HtmlDecode($this->site);
    }

    public function setSite(string $value): static
    {
        $this->site = RemoveXss($value);
        return $this;
    }

    public function getUserName(): ?string
    {
        return HtmlDecode($this->userName);
    }

    public function setUserName(?string $value): static
    {
        $this->userName = RemoveXss($value);
        return $this;
    }

    public function getDob(): ?DateTime
    {
        return $this->dob;
    }

    public function setDob(?DateTime $value): static
    {
        $this->dob = $value;
        return $this;
    }

    public function getSalary(): int
    {
        return $this->salary;
    }

    public function setSalary(int $value): static
    {
        $this->salary = $value;
        return $this;
    }

    public function getAddress(): ?string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(?string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getMobile(): ?string
    {
        return $this->mobile;
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = $value;
        return $this;
    }

    public function getCategory(): int
    {
        return $this->category;
    }

    public function setCategory(int $value): static
    {
        $this->category = $value;
        return $this;
    }

    public function getProcess(): ?string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(?string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
