<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "production_employee" table
 */
#[Entity]
#[Table(name: "production_employee")]
class ProductionEmployee extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $uid;

    #[Column(type: "string")]
    private string $grp;

    #[Column(type: "string")]
    private string $site;

    #[Column(type: "integer", unique: true)]
    private int $id;

    #[Column(name: "user_name", type: "string", nullable: true)]
    private ?string $userName;

    #[Column(type: "integer")]
    private int $salary;

    #[Column(type: "smallint", nullable: true)]
    private ?int $contractor;

    #[Column(type: "string", nullable: true)]
    private ?string $address;

    #[Column(type: "bigint", nullable: true)]
    private ?string $mobile;

    #[Column(type: "integer")]
    private int $category;

    #[Column(type: "string", nullable: true)]
    private ?string $process;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(name: "employee_name", type: "string", nullable: true)]
    private ?string $employeeName;

    #[Column(type: "integer", nullable: true)]
    private ?int $gender;

    #[Column(name: "father_name", type: "string", nullable: true)]
    private ?string $fatherName;

    #[Column(type: "string", nullable: true)]
    private ?string $designation;

    #[Column(name: "permanent_address", type: "string", nullable: true)]
    private ?string $permanentAddress;

    #[Column(type: "string", nullable: true)]
    private ?string $city;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dob;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dom;

    #[Column(name: "mobile_other", type: "string", nullable: true)]
    private ?string $mobileOther;

    #[Column(name: "mobile_family", type: "string", nullable: true)]
    private ?string $mobileFamily;

    #[Column(name: "marital_status", type: "smallint", nullable: true)]
    private ?int $maritalStatus;

    #[Column(name: "spouse_details", type: "string", nullable: true)]
    private ?string $spouseDetails;

    #[Column(name: "emergency_details", type: "string", nullable: true)]
    private ?string $emergencyDetails;

    #[Column(name: "pan_no", type: "string", nullable: true)]
    private ?string $panNo;

    #[Column(name: "aadhaar_no", type: "string", nullable: true)]
    private ?string $aadhaarNo;

    #[Column(name: "id_proof", type: "string", nullable: true)]
    private ?string $idProof;

    #[Column(name: "reference_details", type: "string", nullable: true)]
    private ?string $referenceDetails;

    #[Column(name: "other_details", type: "text", nullable: true)]
    private ?string $otherDetails;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $doj;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $doc;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dol;

    #[Column(type: "string", nullable: true)]
    private ?string $image;

    #[Column(name: "payment_details", type: "text", nullable: true)]
    private ?string $paymentDetails;

    #[Column(name: "bank_name", type: "string", nullable: true)]
    private ?string $bankName;

    #[Column(name: "bank_ifsc_code", type: "string", nullable: true)]
    private ?string $bankIfscCode;

    #[Column(name: "bank_account_no", type: "string", nullable: true)]
    private ?string $bankAccountNo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "d_operator", type: "smallint", nullable: true)]
    private ?int $dOperator;

    #[Column(name: "d_datetime", type: "datetime")]
    private DateTime $dDatetime;

    #[Column(name: "am_id", type: "smallint", nullable: true)]
    private ?int $amId;

    public function __construct()
    {
        $this->grp = "3";
        $this->site = "0";
        $this->id = 0;
        $this->salary = 0;
        $this->status = 1;
        $this->operator = 0;
    }

    public function getUid(): int
    {
        return $this->uid;
    }

    public function setUid(int $value): static
    {
        $this->uid = $value;
        return $this;
    }

    public function getGrp(): string
    {
        return HtmlDecode($this->grp);
    }

    public function setGrp(string $value): static
    {
        $this->grp = RemoveXss($value);
        return $this;
    }

    public function getSite(): string
    {
        return HtmlDecode($this->site);
    }

    public function setSite(string $value): static
    {
        $this->site = RemoveXss($value);
        return $this;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getUserName(): ?string
    {
        return HtmlDecode($this->userName);
    }

    public function setUserName(?string $value): static
    {
        $this->userName = RemoveXss($value);
        return $this;
    }

    public function getSalary(): int
    {
        return $this->salary;
    }

    public function setSalary(int $value): static
    {
        $this->salary = $value;
        return $this;
    }

    public function getContractor(): ?int
    {
        return $this->contractor;
    }

    public function setContractor(?int $value): static
    {
        $this->contractor = $value;
        return $this;
    }

    public function getAddress(): ?string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(?string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getMobile(): ?string
    {
        return $this->mobile;
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = $value;
        return $this;
    }

    public function getCategory(): int
    {
        return $this->category;
    }

    public function setCategory(int $value): static
    {
        $this->category = $value;
        return $this;
    }

    public function getProcess(): ?string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(?string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getEmployeeName(): ?string
    {
        return HtmlDecode($this->employeeName);
    }

    public function setEmployeeName(?string $value): static
    {
        $this->employeeName = RemoveXss($value);
        return $this;
    }

    public function getGender(): ?int
    {
        return $this->gender;
    }

    public function setGender(?int $value): static
    {
        $this->gender = $value;
        return $this;
    }

    public function getFatherName(): ?string
    {
        return HtmlDecode($this->fatherName);
    }

    public function setFatherName(?string $value): static
    {
        $this->fatherName = RemoveXss($value);
        return $this;
    }

    public function getDesignation(): ?string
    {
        return HtmlDecode($this->designation);
    }

    public function setDesignation(?string $value): static
    {
        $this->designation = RemoveXss($value);
        return $this;
    }

    public function getPermanentAddress(): ?string
    {
        return HtmlDecode($this->permanentAddress);
    }

    public function setPermanentAddress(?string $value): static
    {
        $this->permanentAddress = RemoveXss($value);
        return $this;
    }

    public function getCity(): ?string
    {
        return HtmlDecode($this->city);
    }

    public function setCity(?string $value): static
    {
        $this->city = RemoveXss($value);
        return $this;
    }

    public function getDob(): ?DateTime
    {
        return $this->dob;
    }

    public function setDob(?DateTime $value): static
    {
        $this->dob = $value;
        return $this;
    }

    public function getDom(): ?DateTime
    {
        return $this->dom;
    }

    public function setDom(?DateTime $value): static
    {
        $this->dom = $value;
        return $this;
    }

    public function getMobileOther(): ?string
    {
        return HtmlDecode($this->mobileOther);
    }

    public function setMobileOther(?string $value): static
    {
        $this->mobileOther = RemoveXss($value);
        return $this;
    }

    public function getMobileFamily(): ?string
    {
        return HtmlDecode($this->mobileFamily);
    }

    public function setMobileFamily(?string $value): static
    {
        $this->mobileFamily = RemoveXss($value);
        return $this;
    }

    public function getMaritalStatus(): ?int
    {
        return $this->maritalStatus;
    }

    public function setMaritalStatus(?int $value): static
    {
        $this->maritalStatus = $value;
        return $this;
    }

    public function getSpouseDetails(): ?string
    {
        return HtmlDecode($this->spouseDetails);
    }

    public function setSpouseDetails(?string $value): static
    {
        $this->spouseDetails = RemoveXss($value);
        return $this;
    }

    public function getEmergencyDetails(): ?string
    {
        return HtmlDecode($this->emergencyDetails);
    }

    public function setEmergencyDetails(?string $value): static
    {
        $this->emergencyDetails = RemoveXss($value);
        return $this;
    }

    public function getPanNo(): ?string
    {
        return HtmlDecode($this->panNo);
    }

    public function setPanNo(?string $value): static
    {
        $this->panNo = RemoveXss($value);
        return $this;
    }

    public function getAadhaarNo(): ?string
    {
        return HtmlDecode($this->aadhaarNo);
    }

    public function setAadhaarNo(?string $value): static
    {
        $this->aadhaarNo = RemoveXss($value);
        return $this;
    }

    public function getIdProof(): ?string
    {
        return HtmlDecode($this->idProof);
    }

    public function setIdProof(?string $value): static
    {
        $this->idProof = RemoveXss($value);
        return $this;
    }

    public function getReferenceDetails(): ?string
    {
        return HtmlDecode($this->referenceDetails);
    }

    public function setReferenceDetails(?string $value): static
    {
        $this->referenceDetails = RemoveXss($value);
        return $this;
    }

    public function getOtherDetails(): ?string
    {
        return HtmlDecode($this->otherDetails);
    }

    public function setOtherDetails(?string $value): static
    {
        $this->otherDetails = RemoveXss($value);
        return $this;
    }

    public function getDoj(): ?DateTime
    {
        return $this->doj;
    }

    public function setDoj(?DateTime $value): static
    {
        $this->doj = $value;
        return $this;
    }

    public function getDoc(): ?DateTime
    {
        return $this->doc;
    }

    public function setDoc(?DateTime $value): static
    {
        $this->doc = $value;
        return $this;
    }

    public function getDol(): ?DateTime
    {
        return $this->dol;
    }

    public function setDol(?DateTime $value): static
    {
        $this->dol = $value;
        return $this;
    }

    public function getImage(): ?string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(?string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getPaymentDetails(): ?string
    {
        return HtmlDecode($this->paymentDetails);
    }

    public function setPaymentDetails(?string $value): static
    {
        $this->paymentDetails = RemoveXss($value);
        return $this;
    }

    public function getBankName(): ?string
    {
        return HtmlDecode($this->bankName);
    }

    public function setBankName(?string $value): static
    {
        $this->bankName = RemoveXss($value);
        return $this;
    }

    public function getBankIfscCode(): ?string
    {
        return HtmlDecode($this->bankIfscCode);
    }

    public function setBankIfscCode(?string $value): static
    {
        $this->bankIfscCode = RemoveXss($value);
        return $this;
    }

    public function getBankAccountNo(): ?string
    {
        return HtmlDecode($this->bankAccountNo);
    }

    public function setBankAccountNo(?string $value): static
    {
        $this->bankAccountNo = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getDOperator(): ?int
    {
        return $this->dOperator;
    }

    public function setDOperator(?int $value): static
    {
        $this->dOperator = $value;
        return $this;
    }

    public function getDDatetime(): DateTime
    {
        return $this->dDatetime;
    }

    public function setDDatetime(DateTime $value): static
    {
        $this->dDatetime = $value;
        return $this;
    }

    public function getAmId(): ?int
    {
        return $this->amId;
    }

    public function setAmId(?int $value): static
    {
        $this->amId = $value;
        return $this;
    }
}
