<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "product_group_cross" table
 */
#[Entity]
#[Table(name: "product_group_cross")]
class ProductGroupCross extends AbstractEntity
{
    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "product_group", type: "string", nullable: true)]
    private ?string $productGroup;

    #[Column(type: "integer")]
    private int $no;

    #[Column(type: "string")]
    private string $name;

    #[Column(type: "integer")]
    private int $type;

    public function __construct()
    {
        $this->sGrp = 0;
        $this->grp = 0;
        $this->no = 0;
        $this->type = 0;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getProductGroup(): ?string
    {
        return HtmlDecode($this->productGroup);
    }

    public function setProductGroup(?string $value): static
    {
        $this->productGroup = RemoveXss($value);
        return $this;
    }

    public function getNo(): int
    {
        return $this->no;
    }

    public function setNo(int $value): static
    {
        $this->no = $value;
        return $this;
    }

    public function getName(): string
    {
        return HtmlDecode($this->name);
    }

    public function setName(string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }
}
