<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "product_group" table
 */
#[Entity]
#[Table(name: "product_group")]
class ProductGroup extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "product_group", type: "string", nullable: true)]
    private ?string $productGroup;

    #[Column(name: "calculation_method", type: "smallint")]
    private int $calculationMethod;

    #[Column(type: "string")]
    private string $shape;

    #[Column(type: "string")]
    private string $sqm;

    #[Column(type: "string")]
    private string $cbm;

    #[Column(type: "smallint", nullable: true)]
    private ?int $process;

    #[Column(type: "integer")]
    private int $status;

    #[Column(name: "v_00", type: "string", nullable: true)]
    private ?string $v00;

    #[Column(name: "v_01", type: "string")]
    private string $v01;

    #[Column(name: "v_01_validation", type: "string")]
    private string $v01Validation;

    #[Column(name: "v_02", type: "string")]
    private string $v02;

    #[Column(name: "v_02_validation", type: "string")]
    private string $v02Validation;

    #[Column(name: "v_03", type: "string")]
    private string $v03;

    #[Column(name: "v_03_validation", type: "string")]
    private string $v03Validation;

    #[Column(name: "v_04", type: "string")]
    private string $v04;

    #[Column(name: "v_04_validation", type: "string")]
    private string $v04Validation;

    #[Column(name: "v_05", type: "string")]
    private string $v05;

    #[Column(name: "v_05_validation", type: "string")]
    private string $v05Validation;

    #[Column(name: "v_06", type: "string")]
    private string $v06;

    #[Column(name: "v_06_validation", type: "string")]
    private string $v06Validation;

    #[Column(name: "v_07", type: "string")]
    private string $v07;

    #[Column(name: "v_07_validation", type: "string")]
    private string $v07Validation;

    #[Column(name: "v_08", type: "string")]
    private string $v08;

    #[Column(name: "v_08_validation", type: "string")]
    private string $v08Validation;

    #[Column(name: "v_09", type: "string")]
    private string $v09;

    #[Column(name: "v_09_validation", type: "string")]
    private string $v09Validation;

    #[Column(name: "v_10", type: "string")]
    private string $v10;

    #[Column(name: "v_10_validation", type: "string")]
    private string $v10Validation;

    #[Column(name: "b_01_head", type: "string")]
    private string $b01Head;

    #[Column(name: "b_02_head", type: "string")]
    private string $b02Head;

    #[Column(name: "b_03_head", type: "string")]
    private string $b03Head;

    #[Column(name: "b_04_head", type: "string")]
    private string $b04Head;

    #[Column(name: "b_05_head", type: "string")]
    private string $b05Head;

    #[Column(name: "b_06_head", type: "string")]
    private string $b06Head;

    #[Column(name: "b_07_head", type: "string")]
    private string $b07Head;

    #[Column(name: "b_08_head", type: "string")]
    private string $b08Head;

    #[Column(name: "b_09_head", type: "string")]
    private string $b09Head;

    #[Column(name: "b_10_head", type: "string")]
    private string $b10Head;

    #[Column(name: "b_11_head", type: "string")]
    private string $b11Head;

    #[Column(name: "b_12_head", type: "string")]
    private string $b12Head;

    #[Column(name: "b_13_head", type: "string")]
    private string $b13Head;

    #[Column(name: "b_14_head", type: "string")]
    private string $b14Head;

    #[Column(name: "b_15_head", type: "string")]
    private string $b15Head;

    #[Column(name: "q_sku", type: "string")]
    private string $qSku;

    #[Column(name: "t_01_head", type: "string")]
    private string $t01Head;

    #[Column(name: "t_02_head", type: "string")]
    private string $t02Head;

    #[Column(name: "t_03_head", type: "string")]
    private string $t03Head;

    #[Column(name: "t_04_head", type: "string")]
    private string $t04Head;

    #[Column(name: "t_05_head", type: "string")]
    private string $t05Head;

    #[Column(name: "t_06_head", type: "string")]
    private string $t06Head;

    #[Column(name: "t_07_head", type: "string")]
    private string $t07Head;

    #[Column(name: "t_08_head", type: "string")]
    private string $t08Head;

    #[Column(name: "t_09_head", type: "string")]
    private string $t09Head;

    #[Column(name: "t_10_head", type: "string")]
    private string $t10Head;

    #[Column(name: "t_11_head", type: "string")]
    private string $t11Head;

    #[Column(name: "t_12_head", type: "string")]
    private string $t12Head;

    #[Column(name: "t_13_head", type: "string")]
    private string $t13Head;

    #[Column(name: "t_14_head", type: "string")]
    private string $t14Head;

    #[Column(name: "t_15_head", type: "string")]
    private string $t15Head;

    #[Column(name: "po_01_head", type: "string")]
    private string $po01Head;

    #[Column(name: "po_02_head", type: "string")]
    private string $po02Head;

    #[Column(name: "po_03_head", type: "string")]
    private string $po03Head;

    #[Column(name: "po_04_head", type: "string")]
    private string $po04Head;

    #[Column(name: "po_05_head", type: "string")]
    private string $po05Head;

    #[Column(name: "po_06_head", type: "string")]
    private string $po06Head;

    #[Column(name: "po_07_head", type: "string")]
    private string $po07Head;

    #[Column(name: "po_08_head", type: "string")]
    private string $po08Head;

    #[Column(name: "po_17_head", type: "string")]
    private string $po17Head;

    #[Column(name: "po_18_head", type: "string")]
    private string $po18Head;

    #[Column(name: "po_19_head", type: "string")]
    private string $po19Head;

    #[Column(name: "po_20_head", type: "string")]
    private string $po20Head;

    #[Column(name: "jc_01_head", type: "string")]
    private string $jc01Head;

    #[Column(name: "jc_02_head", type: "string")]
    private string $jc02Head;

    #[Column(name: "jc_03_head", type: "string")]
    private string $jc03Head;

    #[Column(name: "jc_04_head", type: "string")]
    private string $jc04Head;

    #[Column(name: "jc_05_head", type: "string")]
    private string $jc05Head;

    #[Column(name: "jc_06_head", type: "string")]
    private string $jc06Head;

    #[Column(name: "jc_07_head", type: "string")]
    private string $jc07Head;

    #[Column(name: "jc_08_head", type: "string")]
    private string $jc08Head;

    #[Column(name: "jc_09_head", type: "string")]
    private string $jc09Head;

    #[Column(name: "jc_10_head", type: "string", nullable: true)]
    private ?string $jc10Head;

    #[Column(name: "pc_shape", type: "string")]
    private string $pcShape;

    #[Column(name: "pc_unit", type: "string")]
    private string $pcUnit;

    #[Column(name: "pc_w", type: "string")]
    private string $pcW;

    #[Column(name: "pc_l", type: "string")]
    private string $pcL;

    #[Column(name: "pc_h", type: "string")]
    private string $pcH;

    #[Column(name: "pc_partner_size", type: "string")]
    private string $pcPartnerSize;

    #[Column(name: "pc_sqm", type: "string")]
    private string $pcSqm;

    #[Column(name: "pc_01_head", type: "string")]
    private string $pc01Head;

    #[Column(name: "pc_02_head", type: "string")]
    private string $pc02Head;

    #[Column(name: "pc_03_head", type: "string")]
    private string $pc03Head;

    #[Column(name: "pc_04_head", type: "string")]
    private string $pc04Head;

    #[Column(name: "pc_05_head", type: "string")]
    private string $pc05Head;

    #[Column(name: "pc_06_head", type: "string")]
    private string $pc06Head;

    #[Column(name: "pc_07_head", type: "string")]
    private string $pc07Head;

    #[Column(name: "pc_08_head", type: "string")]
    private string $pc08Head;

    #[Column(name: "pc_09_head", type: "string")]
    private string $pc09Head;

    #[Column(name: "pc_10_head", type: "string")]
    private string $pc10Head;

    #[Column(name: "pc_11_head", type: "string")]
    private string $pc11Head;

    #[Column(name: "pc_12_head", type: "string")]
    private string $pc12Head;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "string", nullable: true)]
    private ?string $image;

    #[Column(name: "pa_process_size_w", type: "string", nullable: true)]
    private ?string $paProcessSizeW;

    #[Column(name: "pa_process_size_l", type: "string", nullable: true)]
    private ?string $paProcessSizeL;

    #[Column(name: "pa_head_01", type: "string")]
    private string $paHead01;

    #[Column(name: "pa_process_01", type: "string", nullable: true)]
    private ?string $paProcess01;

    #[Column(name: "pa_head_02", type: "string")]
    private string $paHead02;

    #[Column(name: "pa_process_02", type: "string", nullable: true)]
    private ?string $paProcess02;

    #[Column(name: "pa_head_03", type: "string")]
    private string $paHead03;

    #[Column(name: "pa_process_03", type: "string", nullable: true)]
    private ?string $paProcess03;

    #[Column(name: "pa_head_04", type: "string")]
    private string $paHead04;

    #[Column(name: "pa_process_04", type: "string", nullable: true)]
    private ?string $paProcess04;

    #[Column(name: "pa_head_05", type: "string")]
    private string $paHead05;

    #[Column(name: "pa_process_05", type: "string", nullable: true)]
    private ?string $paProcess05;

    #[Column(name: "pa_head_06", type: "string")]
    private string $paHead06;

    #[Column(name: "pa_process_06", type: "string", nullable: true)]
    private ?string $paProcess06;

    #[Column(name: "pa_head_07", type: "string")]
    private string $paHead07;

    #[Column(name: "pa_process_07", type: "string", nullable: true)]
    private ?string $paProcess07;

    #[Column(name: "pa_head_08", type: "string")]
    private string $paHead08;

    #[Column(name: "pa_process_08", type: "string", nullable: true)]
    private ?string $paProcess08;

    #[Column(name: "pa_head_09", type: "string")]
    private string $paHead09;

    #[Column(name: "pa_process_09", type: "string", nullable: true)]
    private ?string $paProcess09;

    #[Column(name: "pa_head_10", type: "string")]
    private string $paHead10;

    #[Column(name: "pa_process_10", type: "string", nullable: true)]
    private ?string $paProcess10;

    #[Column(type: "integer")]
    private int $publish;

    #[Column(name: "ppr_01", type: "string")]
    private string $ppr01;

    #[Column(name: "ppr_02", type: "string")]
    private string $ppr02;

    #[Column(name: "ppr_03", type: "string")]
    private string $ppr03;

    #[Column(name: "ppr_04", type: "string")]
    private string $ppr04;

    #[Column(name: "ppr_05", type: "string")]
    private string $ppr05;

    #[Column(name: "ppr_06", type: "string")]
    private string $ppr06;

    public function __construct()
    {
        $this->status = 1;
        $this->v00 = "--NA--";
        $this->v01 = "--NA--";
        $this->v01Validation = "1,12";
        $this->v02 = "--NA--";
        $this->v02Validation = "1,12";
        $this->v03 = "--NA--";
        $this->v03Validation = "1,12";
        $this->v04 = "--NA--";
        $this->v04Validation = "1,12";
        $this->v05 = "--NA--";
        $this->v05Validation = "1,12";
        $this->v06 = "--NA--";
        $this->v06Validation = "1,12";
        $this->v07 = "--NA--";
        $this->v07Validation = "1,12";
        $this->v08 = "--NA--";
        $this->v08Validation = "1,12";
        $this->v09 = "--NA--";
        $this->v09Validation = "1,12";
        $this->v10 = "--NA--";
        $this->v10Validation = "1,12";
        $this->b01Head = "--NA--";
        $this->b02Head = "--NA--";
        $this->b03Head = "--NA--";
        $this->b04Head = "--NA--";
        $this->b05Head = "--NA--";
        $this->b06Head = "--NA--";
        $this->b07Head = "--NA--";
        $this->b08Head = "--NA--";
        $this->b09Head = "--NA--";
        $this->b10Head = "--NA--";
        $this->b11Head = "--NA--";
        $this->b12Head = "--NA--";
        $this->b13Head = "--NA--";
        $this->b14Head = "--NA--";
        $this->b15Head = "--NA--";
        $this->qSku = "1.00";
        $this->t01Head = "--NA--";
        $this->t02Head = "--NA--";
        $this->t03Head = "--NA--";
        $this->t04Head = "--NA--";
        $this->t05Head = "--NA--";
        $this->t06Head = "--NA--";
        $this->t07Head = "--NA--";
        $this->t08Head = "--NA--";
        $this->t09Head = "--NA--";
        $this->t10Head = "--NA--";
        $this->t11Head = "--NA--";
        $this->t12Head = "--NA--";
        $this->t13Head = "--NA--";
        $this->t14Head = "--NA--";
        $this->t15Head = "--NA--";
        $this->po01Head = "--NA--";
        $this->po02Head = "--NA--";
        $this->po03Head = "--NA--";
        $this->po04Head = "--NA--";
        $this->po05Head = "--NA--";
        $this->po06Head = "--NA--";
        $this->po07Head = "--NA--";
        $this->po08Head = "--NA--";
        $this->po17Head = "--NA--";
        $this->po18Head = "--NA--";
        $this->po19Head = "--NA--";
        $this->po20Head = "--NA--";
        $this->pcShape = "--NA--";
        $this->pcUnit = "--NA--";
        $this->pcW = "--NA--";
        $this->pcL = "--NA--";
        $this->pcH = "--NA--";
        $this->pcPartnerSize = "--NA--";
        $this->pcSqm = "--NA--";
        $this->pc01Head = "--NA--";
        $this->pc02Head = "--NA--";
        $this->pc03Head = "--NA--";
        $this->pc04Head = "--NA--";
        $this->pc05Head = "--NA--";
        $this->pc06Head = "--NA--";
        $this->pc07Head = "--NA--";
        $this->pc08Head = "--NA--";
        $this->pc09Head = "--NA--";
        $this->pc10Head = "--NA--";
        $this->pc11Head = "--NA--";
        $this->pc12Head = "--NA--";
        $this->operator = 0;
        $this->paHead01 = "--NA--";
        $this->paHead02 = "--NA--";
        $this->paHead03 = "--NA--";
        $this->paHead04 = "--NA--";
        $this->paHead05 = "--NA--";
        $this->paHead06 = "--NA--";
        $this->paHead07 = "--NA--";
        $this->paHead08 = "--NA--";
        $this->paHead09 = "--NA--";
        $this->paHead10 = "--NA--";
        $this->publish = 0;
        $this->ppr01 = "--NA--";
        $this->ppr02 = "--NA--";
        $this->ppr03 = "--NA--";
        $this->ppr04 = "--NA--";
        $this->ppr05 = "--NA--";
        $this->ppr06 = "--NA--";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getProductGroup(): ?string
    {
        return HtmlDecode($this->productGroup);
    }

    public function setProductGroup(?string $value): static
    {
        $this->productGroup = RemoveXss($value);
        return $this;
    }

    public function getCalculationMethod(): int
    {
        return $this->calculationMethod;
    }

    public function setCalculationMethod(int $value): static
    {
        $this->calculationMethod = $value;
        return $this;
    }

    public function getShape(): string
    {
        return HtmlDecode($this->shape);
    }

    public function setShape(string $value): static
    {
        $this->shape = RemoveXss($value);
        return $this;
    }

    public function getSqm(): string
    {
        return HtmlDecode($this->sqm);
    }

    public function setSqm(string $value): static
    {
        $this->sqm = RemoveXss($value);
        return $this;
    }

    public function getCbm(): string
    {
        return HtmlDecode($this->cbm);
    }

    public function setCbm(string $value): static
    {
        $this->cbm = RemoveXss($value);
        return $this;
    }

    public function getProcess(): ?int
    {
        return $this->process;
    }

    public function setProcess(?int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getV00(): ?string
    {
        return HtmlDecode($this->v00);
    }

    public function setV00(?string $value): static
    {
        $this->v00 = RemoveXss($value);
        return $this;
    }

    public function getV01(): string
    {
        return HtmlDecode($this->v01);
    }

    public function setV01(string $value): static
    {
        $this->v01 = RemoveXss($value);
        return $this;
    }

    public function getV01Validation(): string
    {
        return HtmlDecode($this->v01Validation);
    }

    public function setV01Validation(string $value): static
    {
        $this->v01Validation = RemoveXss($value);
        return $this;
    }

    public function getV02(): string
    {
        return HtmlDecode($this->v02);
    }

    public function setV02(string $value): static
    {
        $this->v02 = RemoveXss($value);
        return $this;
    }

    public function getV02Validation(): string
    {
        return HtmlDecode($this->v02Validation);
    }

    public function setV02Validation(string $value): static
    {
        $this->v02Validation = RemoveXss($value);
        return $this;
    }

    public function getV03(): string
    {
        return HtmlDecode($this->v03);
    }

    public function setV03(string $value): static
    {
        $this->v03 = RemoveXss($value);
        return $this;
    }

    public function getV03Validation(): string
    {
        return HtmlDecode($this->v03Validation);
    }

    public function setV03Validation(string $value): static
    {
        $this->v03Validation = RemoveXss($value);
        return $this;
    }

    public function getV04(): string
    {
        return HtmlDecode($this->v04);
    }

    public function setV04(string $value): static
    {
        $this->v04 = RemoveXss($value);
        return $this;
    }

    public function getV04Validation(): string
    {
        return HtmlDecode($this->v04Validation);
    }

    public function setV04Validation(string $value): static
    {
        $this->v04Validation = RemoveXss($value);
        return $this;
    }

    public function getV05(): string
    {
        return HtmlDecode($this->v05);
    }

    public function setV05(string $value): static
    {
        $this->v05 = RemoveXss($value);
        return $this;
    }

    public function getV05Validation(): string
    {
        return HtmlDecode($this->v05Validation);
    }

    public function setV05Validation(string $value): static
    {
        $this->v05Validation = RemoveXss($value);
        return $this;
    }

    public function getV06(): string
    {
        return HtmlDecode($this->v06);
    }

    public function setV06(string $value): static
    {
        $this->v06 = RemoveXss($value);
        return $this;
    }

    public function getV06Validation(): string
    {
        return HtmlDecode($this->v06Validation);
    }

    public function setV06Validation(string $value): static
    {
        $this->v06Validation = RemoveXss($value);
        return $this;
    }

    public function getV07(): string
    {
        return HtmlDecode($this->v07);
    }

    public function setV07(string $value): static
    {
        $this->v07 = RemoveXss($value);
        return $this;
    }

    public function getV07Validation(): string
    {
        return HtmlDecode($this->v07Validation);
    }

    public function setV07Validation(string $value): static
    {
        $this->v07Validation = RemoveXss($value);
        return $this;
    }

    public function getV08(): string
    {
        return HtmlDecode($this->v08);
    }

    public function setV08(string $value): static
    {
        $this->v08 = RemoveXss($value);
        return $this;
    }

    public function getV08Validation(): string
    {
        return HtmlDecode($this->v08Validation);
    }

    public function setV08Validation(string $value): static
    {
        $this->v08Validation = RemoveXss($value);
        return $this;
    }

    public function getV09(): string
    {
        return HtmlDecode($this->v09);
    }

    public function setV09(string $value): static
    {
        $this->v09 = RemoveXss($value);
        return $this;
    }

    public function getV09Validation(): string
    {
        return HtmlDecode($this->v09Validation);
    }

    public function setV09Validation(string $value): static
    {
        $this->v09Validation = RemoveXss($value);
        return $this;
    }

    public function getV10(): string
    {
        return HtmlDecode($this->v10);
    }

    public function setV10(string $value): static
    {
        $this->v10 = RemoveXss($value);
        return $this;
    }

    public function getV10Validation(): string
    {
        return HtmlDecode($this->v10Validation);
    }

    public function setV10Validation(string $value): static
    {
        $this->v10Validation = RemoveXss($value);
        return $this;
    }

    public function getB01Head(): string
    {
        return HtmlDecode($this->b01Head);
    }

    public function setB01Head(string $value): static
    {
        $this->b01Head = RemoveXss($value);
        return $this;
    }

    public function getB02Head(): string
    {
        return HtmlDecode($this->b02Head);
    }

    public function setB02Head(string $value): static
    {
        $this->b02Head = RemoveXss($value);
        return $this;
    }

    public function getB03Head(): string
    {
        return HtmlDecode($this->b03Head);
    }

    public function setB03Head(string $value): static
    {
        $this->b03Head = RemoveXss($value);
        return $this;
    }

    public function getB04Head(): string
    {
        return HtmlDecode($this->b04Head);
    }

    public function setB04Head(string $value): static
    {
        $this->b04Head = RemoveXss($value);
        return $this;
    }

    public function getB05Head(): string
    {
        return HtmlDecode($this->b05Head);
    }

    public function setB05Head(string $value): static
    {
        $this->b05Head = RemoveXss($value);
        return $this;
    }

    public function getB06Head(): string
    {
        return HtmlDecode($this->b06Head);
    }

    public function setB06Head(string $value): static
    {
        $this->b06Head = RemoveXss($value);
        return $this;
    }

    public function getB07Head(): string
    {
        return HtmlDecode($this->b07Head);
    }

    public function setB07Head(string $value): static
    {
        $this->b07Head = RemoveXss($value);
        return $this;
    }

    public function getB08Head(): string
    {
        return HtmlDecode($this->b08Head);
    }

    public function setB08Head(string $value): static
    {
        $this->b08Head = RemoveXss($value);
        return $this;
    }

    public function getB09Head(): string
    {
        return HtmlDecode($this->b09Head);
    }

    public function setB09Head(string $value): static
    {
        $this->b09Head = RemoveXss($value);
        return $this;
    }

    public function getB10Head(): string
    {
        return HtmlDecode($this->b10Head);
    }

    public function setB10Head(string $value): static
    {
        $this->b10Head = RemoveXss($value);
        return $this;
    }

    public function getB11Head(): string
    {
        return HtmlDecode($this->b11Head);
    }

    public function setB11Head(string $value): static
    {
        $this->b11Head = RemoveXss($value);
        return $this;
    }

    public function getB12Head(): string
    {
        return HtmlDecode($this->b12Head);
    }

    public function setB12Head(string $value): static
    {
        $this->b12Head = RemoveXss($value);
        return $this;
    }

    public function getB13Head(): string
    {
        return HtmlDecode($this->b13Head);
    }

    public function setB13Head(string $value): static
    {
        $this->b13Head = RemoveXss($value);
        return $this;
    }

    public function getB14Head(): string
    {
        return HtmlDecode($this->b14Head);
    }

    public function setB14Head(string $value): static
    {
        $this->b14Head = RemoveXss($value);
        return $this;
    }

    public function getB15Head(): string
    {
        return HtmlDecode($this->b15Head);
    }

    public function setB15Head(string $value): static
    {
        $this->b15Head = RemoveXss($value);
        return $this;
    }

    public function getQSku(): string
    {
        return HtmlDecode($this->qSku);
    }

    public function setQSku(string $value): static
    {
        $this->qSku = RemoveXss($value);
        return $this;
    }

    public function getT01Head(): string
    {
        return HtmlDecode($this->t01Head);
    }

    public function setT01Head(string $value): static
    {
        $this->t01Head = RemoveXss($value);
        return $this;
    }

    public function getT02Head(): string
    {
        return HtmlDecode($this->t02Head);
    }

    public function setT02Head(string $value): static
    {
        $this->t02Head = RemoveXss($value);
        return $this;
    }

    public function getT03Head(): string
    {
        return HtmlDecode($this->t03Head);
    }

    public function setT03Head(string $value): static
    {
        $this->t03Head = RemoveXss($value);
        return $this;
    }

    public function getT04Head(): string
    {
        return HtmlDecode($this->t04Head);
    }

    public function setT04Head(string $value): static
    {
        $this->t04Head = RemoveXss($value);
        return $this;
    }

    public function getT05Head(): string
    {
        return HtmlDecode($this->t05Head);
    }

    public function setT05Head(string $value): static
    {
        $this->t05Head = RemoveXss($value);
        return $this;
    }

    public function getT06Head(): string
    {
        return HtmlDecode($this->t06Head);
    }

    public function setT06Head(string $value): static
    {
        $this->t06Head = RemoveXss($value);
        return $this;
    }

    public function getT07Head(): string
    {
        return HtmlDecode($this->t07Head);
    }

    public function setT07Head(string $value): static
    {
        $this->t07Head = RemoveXss($value);
        return $this;
    }

    public function getT08Head(): string
    {
        return HtmlDecode($this->t08Head);
    }

    public function setT08Head(string $value): static
    {
        $this->t08Head = RemoveXss($value);
        return $this;
    }

    public function getT09Head(): string
    {
        return HtmlDecode($this->t09Head);
    }

    public function setT09Head(string $value): static
    {
        $this->t09Head = RemoveXss($value);
        return $this;
    }

    public function getT10Head(): string
    {
        return HtmlDecode($this->t10Head);
    }

    public function setT10Head(string $value): static
    {
        $this->t10Head = RemoveXss($value);
        return $this;
    }

    public function getT11Head(): string
    {
        return HtmlDecode($this->t11Head);
    }

    public function setT11Head(string $value): static
    {
        $this->t11Head = RemoveXss($value);
        return $this;
    }

    public function getT12Head(): string
    {
        return HtmlDecode($this->t12Head);
    }

    public function setT12Head(string $value): static
    {
        $this->t12Head = RemoveXss($value);
        return $this;
    }

    public function getT13Head(): string
    {
        return HtmlDecode($this->t13Head);
    }

    public function setT13Head(string $value): static
    {
        $this->t13Head = RemoveXss($value);
        return $this;
    }

    public function getT14Head(): string
    {
        return HtmlDecode($this->t14Head);
    }

    public function setT14Head(string $value): static
    {
        $this->t14Head = RemoveXss($value);
        return $this;
    }

    public function getT15Head(): string
    {
        return HtmlDecode($this->t15Head);
    }

    public function setT15Head(string $value): static
    {
        $this->t15Head = RemoveXss($value);
        return $this;
    }

    public function getPo01Head(): string
    {
        return HtmlDecode($this->po01Head);
    }

    public function setPo01Head(string $value): static
    {
        $this->po01Head = RemoveXss($value);
        return $this;
    }

    public function getPo02Head(): string
    {
        return HtmlDecode($this->po02Head);
    }

    public function setPo02Head(string $value): static
    {
        $this->po02Head = RemoveXss($value);
        return $this;
    }

    public function getPo03Head(): string
    {
        return HtmlDecode($this->po03Head);
    }

    public function setPo03Head(string $value): static
    {
        $this->po03Head = RemoveXss($value);
        return $this;
    }

    public function getPo04Head(): string
    {
        return HtmlDecode($this->po04Head);
    }

    public function setPo04Head(string $value): static
    {
        $this->po04Head = RemoveXss($value);
        return $this;
    }

    public function getPo05Head(): string
    {
        return HtmlDecode($this->po05Head);
    }

    public function setPo05Head(string $value): static
    {
        $this->po05Head = RemoveXss($value);
        return $this;
    }

    public function getPo06Head(): string
    {
        return HtmlDecode($this->po06Head);
    }

    public function setPo06Head(string $value): static
    {
        $this->po06Head = RemoveXss($value);
        return $this;
    }

    public function getPo07Head(): string
    {
        return HtmlDecode($this->po07Head);
    }

    public function setPo07Head(string $value): static
    {
        $this->po07Head = RemoveXss($value);
        return $this;
    }

    public function getPo08Head(): string
    {
        return HtmlDecode($this->po08Head);
    }

    public function setPo08Head(string $value): static
    {
        $this->po08Head = RemoveXss($value);
        return $this;
    }

    public function getPo17Head(): string
    {
        return HtmlDecode($this->po17Head);
    }

    public function setPo17Head(string $value): static
    {
        $this->po17Head = RemoveXss($value);
        return $this;
    }

    public function getPo18Head(): string
    {
        return HtmlDecode($this->po18Head);
    }

    public function setPo18Head(string $value): static
    {
        $this->po18Head = RemoveXss($value);
        return $this;
    }

    public function getPo19Head(): string
    {
        return HtmlDecode($this->po19Head);
    }

    public function setPo19Head(string $value): static
    {
        $this->po19Head = RemoveXss($value);
        return $this;
    }

    public function getPo20Head(): string
    {
        return HtmlDecode($this->po20Head);
    }

    public function setPo20Head(string $value): static
    {
        $this->po20Head = RemoveXss($value);
        return $this;
    }

    public function getJc01Head(): string
    {
        return HtmlDecode($this->jc01Head);
    }

    public function setJc01Head(string $value): static
    {
        $this->jc01Head = RemoveXss($value);
        return $this;
    }

    public function getJc02Head(): string
    {
        return HtmlDecode($this->jc02Head);
    }

    public function setJc02Head(string $value): static
    {
        $this->jc02Head = RemoveXss($value);
        return $this;
    }

    public function getJc03Head(): string
    {
        return HtmlDecode($this->jc03Head);
    }

    public function setJc03Head(string $value): static
    {
        $this->jc03Head = RemoveXss($value);
        return $this;
    }

    public function getJc04Head(): string
    {
        return HtmlDecode($this->jc04Head);
    }

    public function setJc04Head(string $value): static
    {
        $this->jc04Head = RemoveXss($value);
        return $this;
    }

    public function getJc05Head(): string
    {
        return HtmlDecode($this->jc05Head);
    }

    public function setJc05Head(string $value): static
    {
        $this->jc05Head = RemoveXss($value);
        return $this;
    }

    public function getJc06Head(): string
    {
        return HtmlDecode($this->jc06Head);
    }

    public function setJc06Head(string $value): static
    {
        $this->jc06Head = RemoveXss($value);
        return $this;
    }

    public function getJc07Head(): string
    {
        return HtmlDecode($this->jc07Head);
    }

    public function setJc07Head(string $value): static
    {
        $this->jc07Head = RemoveXss($value);
        return $this;
    }

    public function getJc08Head(): string
    {
        return HtmlDecode($this->jc08Head);
    }

    public function setJc08Head(string $value): static
    {
        $this->jc08Head = RemoveXss($value);
        return $this;
    }

    public function getJc09Head(): string
    {
        return HtmlDecode($this->jc09Head);
    }

    public function setJc09Head(string $value): static
    {
        $this->jc09Head = RemoveXss($value);
        return $this;
    }

    public function getJc10Head(): ?string
    {
        return HtmlDecode($this->jc10Head);
    }

    public function setJc10Head(?string $value): static
    {
        $this->jc10Head = RemoveXss($value);
        return $this;
    }

    public function getPcShape(): string
    {
        return HtmlDecode($this->pcShape);
    }

    public function setPcShape(string $value): static
    {
        $this->pcShape = RemoveXss($value);
        return $this;
    }

    public function getPcUnit(): string
    {
        return HtmlDecode($this->pcUnit);
    }

    public function setPcUnit(string $value): static
    {
        $this->pcUnit = RemoveXss($value);
        return $this;
    }

    public function getPcW(): string
    {
        return HtmlDecode($this->pcW);
    }

    public function setPcW(string $value): static
    {
        $this->pcW = RemoveXss($value);
        return $this;
    }

    public function getPcL(): string
    {
        return HtmlDecode($this->pcL);
    }

    public function setPcL(string $value): static
    {
        $this->pcL = RemoveXss($value);
        return $this;
    }

    public function getPcH(): string
    {
        return HtmlDecode($this->pcH);
    }

    public function setPcH(string $value): static
    {
        $this->pcH = RemoveXss($value);
        return $this;
    }

    public function getPcPartnerSize(): string
    {
        return HtmlDecode($this->pcPartnerSize);
    }

    public function setPcPartnerSize(string $value): static
    {
        $this->pcPartnerSize = RemoveXss($value);
        return $this;
    }

    public function getPcSqm(): string
    {
        return HtmlDecode($this->pcSqm);
    }

    public function setPcSqm(string $value): static
    {
        $this->pcSqm = RemoveXss($value);
        return $this;
    }

    public function getPc01Head(): string
    {
        return HtmlDecode($this->pc01Head);
    }

    public function setPc01Head(string $value): static
    {
        $this->pc01Head = RemoveXss($value);
        return $this;
    }

    public function getPc02Head(): string
    {
        return HtmlDecode($this->pc02Head);
    }

    public function setPc02Head(string $value): static
    {
        $this->pc02Head = RemoveXss($value);
        return $this;
    }

    public function getPc03Head(): string
    {
        return HtmlDecode($this->pc03Head);
    }

    public function setPc03Head(string $value): static
    {
        $this->pc03Head = RemoveXss($value);
        return $this;
    }

    public function getPc04Head(): string
    {
        return HtmlDecode($this->pc04Head);
    }

    public function setPc04Head(string $value): static
    {
        $this->pc04Head = RemoveXss($value);
        return $this;
    }

    public function getPc05Head(): string
    {
        return HtmlDecode($this->pc05Head);
    }

    public function setPc05Head(string $value): static
    {
        $this->pc05Head = RemoveXss($value);
        return $this;
    }

    public function getPc06Head(): string
    {
        return HtmlDecode($this->pc06Head);
    }

    public function setPc06Head(string $value): static
    {
        $this->pc06Head = RemoveXss($value);
        return $this;
    }

    public function getPc07Head(): string
    {
        return HtmlDecode($this->pc07Head);
    }

    public function setPc07Head(string $value): static
    {
        $this->pc07Head = RemoveXss($value);
        return $this;
    }

    public function getPc08Head(): string
    {
        return HtmlDecode($this->pc08Head);
    }

    public function setPc08Head(string $value): static
    {
        $this->pc08Head = RemoveXss($value);
        return $this;
    }

    public function getPc09Head(): string
    {
        return HtmlDecode($this->pc09Head);
    }

    public function setPc09Head(string $value): static
    {
        $this->pc09Head = RemoveXss($value);
        return $this;
    }

    public function getPc10Head(): string
    {
        return HtmlDecode($this->pc10Head);
    }

    public function setPc10Head(string $value): static
    {
        $this->pc10Head = RemoveXss($value);
        return $this;
    }

    public function getPc11Head(): string
    {
        return HtmlDecode($this->pc11Head);
    }

    public function setPc11Head(string $value): static
    {
        $this->pc11Head = RemoveXss($value);
        return $this;
    }

    public function getPc12Head(): string
    {
        return HtmlDecode($this->pc12Head);
    }

    public function setPc12Head(string $value): static
    {
        $this->pc12Head = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getImage(): ?string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(?string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getPaProcessSizeW(): ?string
    {
        return HtmlDecode($this->paProcessSizeW);
    }

    public function setPaProcessSizeW(?string $value): static
    {
        $this->paProcessSizeW = RemoveXss($value);
        return $this;
    }

    public function getPaProcessSizeL(): ?string
    {
        return HtmlDecode($this->paProcessSizeL);
    }

    public function setPaProcessSizeL(?string $value): static
    {
        $this->paProcessSizeL = RemoveXss($value);
        return $this;
    }

    public function getPaHead01(): string
    {
        return HtmlDecode($this->paHead01);
    }

    public function setPaHead01(string $value): static
    {
        $this->paHead01 = RemoveXss($value);
        return $this;
    }

    public function getPaProcess01(): ?string
    {
        return HtmlDecode($this->paProcess01);
    }

    public function setPaProcess01(?string $value): static
    {
        $this->paProcess01 = RemoveXss($value);
        return $this;
    }

    public function getPaHead02(): string
    {
        return HtmlDecode($this->paHead02);
    }

    public function setPaHead02(string $value): static
    {
        $this->paHead02 = RemoveXss($value);
        return $this;
    }

    public function getPaProcess02(): ?string
    {
        return HtmlDecode($this->paProcess02);
    }

    public function setPaProcess02(?string $value): static
    {
        $this->paProcess02 = RemoveXss($value);
        return $this;
    }

    public function getPaHead03(): string
    {
        return HtmlDecode($this->paHead03);
    }

    public function setPaHead03(string $value): static
    {
        $this->paHead03 = RemoveXss($value);
        return $this;
    }

    public function getPaProcess03(): ?string
    {
        return HtmlDecode($this->paProcess03);
    }

    public function setPaProcess03(?string $value): static
    {
        $this->paProcess03 = RemoveXss($value);
        return $this;
    }

    public function getPaHead04(): string
    {
        return HtmlDecode($this->paHead04);
    }

    public function setPaHead04(string $value): static
    {
        $this->paHead04 = RemoveXss($value);
        return $this;
    }

    public function getPaProcess04(): ?string
    {
        return HtmlDecode($this->paProcess04);
    }

    public function setPaProcess04(?string $value): static
    {
        $this->paProcess04 = RemoveXss($value);
        return $this;
    }

    public function getPaHead05(): string
    {
        return HtmlDecode($this->paHead05);
    }

    public function setPaHead05(string $value): static
    {
        $this->paHead05 = RemoveXss($value);
        return $this;
    }

    public function getPaProcess05(): ?string
    {
        return HtmlDecode($this->paProcess05);
    }

    public function setPaProcess05(?string $value): static
    {
        $this->paProcess05 = RemoveXss($value);
        return $this;
    }

    public function getPaHead06(): string
    {
        return HtmlDecode($this->paHead06);
    }

    public function setPaHead06(string $value): static
    {
        $this->paHead06 = RemoveXss($value);
        return $this;
    }

    public function getPaProcess06(): ?string
    {
        return HtmlDecode($this->paProcess06);
    }

    public function setPaProcess06(?string $value): static
    {
        $this->paProcess06 = RemoveXss($value);
        return $this;
    }

    public function getPaHead07(): string
    {
        return HtmlDecode($this->paHead07);
    }

    public function setPaHead07(string $value): static
    {
        $this->paHead07 = RemoveXss($value);
        return $this;
    }

    public function getPaProcess07(): ?string
    {
        return HtmlDecode($this->paProcess07);
    }

    public function setPaProcess07(?string $value): static
    {
        $this->paProcess07 = RemoveXss($value);
        return $this;
    }

    public function getPaHead08(): string
    {
        return HtmlDecode($this->paHead08);
    }

    public function setPaHead08(string $value): static
    {
        $this->paHead08 = RemoveXss($value);
        return $this;
    }

    public function getPaProcess08(): ?string
    {
        return HtmlDecode($this->paProcess08);
    }

    public function setPaProcess08(?string $value): static
    {
        $this->paProcess08 = RemoveXss($value);
        return $this;
    }

    public function getPaHead09(): string
    {
        return HtmlDecode($this->paHead09);
    }

    public function setPaHead09(string $value): static
    {
        $this->paHead09 = RemoveXss($value);
        return $this;
    }

    public function getPaProcess09(): ?string
    {
        return HtmlDecode($this->paProcess09);
    }

    public function setPaProcess09(?string $value): static
    {
        $this->paProcess09 = RemoveXss($value);
        return $this;
    }

    public function getPaHead10(): string
    {
        return HtmlDecode($this->paHead10);
    }

    public function setPaHead10(string $value): static
    {
        $this->paHead10 = RemoveXss($value);
        return $this;
    }

    public function getPaProcess10(): ?string
    {
        return HtmlDecode($this->paProcess10);
    }

    public function setPaProcess10(?string $value): static
    {
        $this->paProcess10 = RemoveXss($value);
        return $this;
    }

    public function getPublish(): int
    {
        return $this->publish;
    }

    public function setPublish(int $value): static
    {
        $this->publish = $value;
        return $this;
    }

    public function getPpr01(): string
    {
        return HtmlDecode($this->ppr01);
    }

    public function setPpr01(string $value): static
    {
        $this->ppr01 = RemoveXss($value);
        return $this;
    }

    public function getPpr02(): string
    {
        return HtmlDecode($this->ppr02);
    }

    public function setPpr02(string $value): static
    {
        $this->ppr02 = RemoveXss($value);
        return $this;
    }

    public function getPpr03(): string
    {
        return HtmlDecode($this->ppr03);
    }

    public function setPpr03(string $value): static
    {
        $this->ppr03 = RemoveXss($value);
        return $this;
    }

    public function getPpr04(): string
    {
        return HtmlDecode($this->ppr04);
    }

    public function setPpr04(string $value): static
    {
        $this->ppr04 = RemoveXss($value);
        return $this;
    }

    public function getPpr05(): string
    {
        return HtmlDecode($this->ppr05);
    }

    public function setPpr05(string $value): static
    {
        $this->ppr05 = RemoveXss($value);
        return $this;
    }

    public function getPpr06(): string
    {
        return HtmlDecode($this->ppr06);
    }

    public function setPpr06(string $value): static
    {
        $this->ppr06 = RemoveXss($value);
        return $this;
    }
}
