<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "product_cart_s_sample" table
 */
#[Entity]
#[Table(name: "product_cart_s_sample")]
class ProductCartSSample extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer")]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "po_id", type: "smallint", nullable: true)]
    private ?int $poId;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(name: "partner_id", type: "integer", nullable: true)]
    private ?int $partnerId;

    #[Column(name: "product_type", type: "smallint")]
    private int $productType;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(type: "string", nullable: true)]
    private ?string $rid;

    #[Column(name: "rid_1", type: "text", nullable: true)]
    private ?string $rid1;

    #[Column(type: "string", nullable: true)]
    private ?string $1;

    #[Column(type: "integer", nullable: true)]
    private ?int $shape;

    #[Column(type: "smallint", nullable: true)]
    private ?int $unit;

    #[Column(type: "string", nullable: true)]
    private ?string $w;

    #[Column(name: "w_cm", type: "float", nullable: true)]
    private ?float $wCm;

    #[Column(type: "string", nullable: true)]
    private ?string $l;

    #[Column(name: "l_cm", type: "float", nullable: true)]
    private ?float $lCm;

    #[Column(type: "string", nullable: true)]
    private ?string $h;

    #[Column(name: "h_cm", type: "float", nullable: true)]
    private ?float $hCm;

    #[Column(name: "partner_size", type: "string", nullable: true)]
    private ?string $partnerSize;

    #[Column(type: "decimal", nullable: true)]
    private ?string $sqm;

    #[Column(type: "decimal")]
    private string $quantity;

    #[Column(type: "decimal")]
    private string $price;

    #[Column(type: "smallint")]
    private int $currency;

    #[Column(type: "decimal")]
    private string $amount;

    #[Column(type: "string", nullable: true)]
    private ?string $2;

    #[Column(type: "string", nullable: true)]
    private ?string $3;

    #[Column(type: "string", nullable: true)]
    private ?string $4;

    #[Column(type: "string", nullable: true)]
    private ?string $5;

    #[Column(type: "string", nullable: true)]
    private ?string $6;

    #[Column(type: "string", nullable: true)]
    private ?string $7;

    #[Column(type: "string", nullable: true)]
    private ?string $8;

    #[Column(type: "string", nullable: true)]
    private ?string $9;

    #[Column(type: "string", nullable: true)]
    private ?string $10;

    #[Column(type: "string", nullable: true)]
    private ?string $11;

    #[Column(type: "string", nullable: true)]
    private ?string $12;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "string", nullable: true)]
    private ?string $image;

    #[Column(name: "buyer_uid", type: "text", nullable: true)]
    private ?string $buyerUid;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "r_text", type: "text", nullable: true)]
    private ?string $rText;

    #[Column(name: "t_id", type: "integer", nullable: true)]
    private ?int $tId;

    public function __construct()
    {
        $this->companyId = 200000;
        $this->partnerId = User_Company_ID();
        $this->productType = 10;
        $this->grp = 99;
        $this->sGrp = 99;
        $this->product = 99;
        $this->rid = "99";
        $this->shape = 1;
        $this->unit = 1;
        $this->w = "00";
        $this->l = "00";
        $this->h = "00";
        $this->quantity = "0";
        $this->price = "0.00";
        $this->9 = "0";
        $this->10 = "0";
        $this->11 = "0";
        $this->12 = "0";
        $this->status = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPoId(): ?int
    {
        return $this->poId;
    }

    public function setPoId(?int $value): static
    {
        $this->poId = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getPartnerId(): ?int
    {
        return $this->partnerId;
    }

    public function setPartnerId(?int $value): static
    {
        $this->partnerId = $value;
        return $this;
    }

    public function getProductType(): int
    {
        return $this->productType;
    }

    public function setProductType(int $value): static
    {
        $this->productType = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): ?string
    {
        return HtmlDecode($this->rid);
    }

    public function setRid(?string $value): static
    {
        $this->rid = RemoveXss($value);
        return $this;
    }

    public function getRid1(): ?string
    {
        return HtmlDecode($this->rid1);
    }

    public function setRid1(?string $value): static
    {
        $this->rid1 = RemoveXss($value);
        return $this;
    }

    public function get1(): ?string
    {
        return HtmlDecode($this->1);
    }

    public function set1(?string $value): static
    {
        $this->1 = RemoveXss($value);
        return $this;
    }

    public function getShape(): ?int
    {
        return $this->shape;
    }

    public function setShape(?int $value): static
    {
        $this->shape = $value;
        return $this;
    }

    public function getUnit(): ?int
    {
        return $this->unit;
    }

    public function setUnit(?int $value): static
    {
        $this->unit = $value;
        return $this;
    }

    public function getW(): ?string
    {
        return HtmlDecode($this->w);
    }

    public function setW(?string $value): static
    {
        $this->w = RemoveXss($value);
        return $this;
    }

    public function getWCm(): ?float
    {
        return $this->wCm;
    }

    public function setWCm(?float $value): static
    {
        $this->wCm = $value;
        return $this;
    }

    public function getL(): ?string
    {
        return HtmlDecode($this->l);
    }

    public function setL(?string $value): static
    {
        $this->l = RemoveXss($value);
        return $this;
    }

    public function getLCm(): ?float
    {
        return $this->lCm;
    }

    public function setLCm(?float $value): static
    {
        $this->lCm = $value;
        return $this;
    }

    public function getH(): ?string
    {
        return HtmlDecode($this->h);
    }

    public function setH(?string $value): static
    {
        $this->h = RemoveXss($value);
        return $this;
    }

    public function getHCm(): ?float
    {
        return $this->hCm;
    }

    public function setHCm(?float $value): static
    {
        $this->hCm = $value;
        return $this;
    }

    public function getPartnerSize(): ?string
    {
        return HtmlDecode($this->partnerSize);
    }

    public function setPartnerSize(?string $value): static
    {
        $this->partnerSize = RemoveXss($value);
        return $this;
    }

    public function getSqm(): ?string
    {
        return $this->sqm;
    }

    public function setSqm(?string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getQuantity(): string
    {
        return $this->quantity;
    }

    public function setQuantity(string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getPrice(): string
    {
        return $this->price;
    }

    public function setPrice(string $value): static
    {
        $this->price = $value;
        return $this;
    }

    public function getCurrency(): int
    {
        return $this->currency;
    }

    public function setCurrency(int $value): static
    {
        $this->currency = $value;
        return $this;
    }

    public function getAmount(): string
    {
        return $this->amount;
    }

    public function setAmount(string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function get2(): ?string
    {
        return HtmlDecode($this->2);
    }

    public function set2(?string $value): static
    {
        $this->2 = RemoveXss($value);
        return $this;
    }

    public function get3(): ?string
    {
        return HtmlDecode($this->3);
    }

    public function set3(?string $value): static
    {
        $this->3 = RemoveXss($value);
        return $this;
    }

    public function get4(): ?string
    {
        return HtmlDecode($this->4);
    }

    public function set4(?string $value): static
    {
        $this->4 = RemoveXss($value);
        return $this;
    }

    public function get5(): ?string
    {
        return HtmlDecode($this->5);
    }

    public function set5(?string $value): static
    {
        $this->5 = RemoveXss($value);
        return $this;
    }

    public function get6(): ?string
    {
        return HtmlDecode($this->6);
    }

    public function set6(?string $value): static
    {
        $this->6 = RemoveXss($value);
        return $this;
    }

    public function get7(): ?string
    {
        return HtmlDecode($this->7);
    }

    public function set7(?string $value): static
    {
        $this->7 = RemoveXss($value);
        return $this;
    }

    public function get8(): ?string
    {
        return HtmlDecode($this->8);
    }

    public function set8(?string $value): static
    {
        $this->8 = RemoveXss($value);
        return $this;
    }

    public function get9(): ?string
    {
        return HtmlDecode($this->9);
    }

    public function set9(?string $value): static
    {
        $this->9 = RemoveXss($value);
        return $this;
    }

    public function get10(): ?string
    {
        return HtmlDecode($this->10);
    }

    public function set10(?string $value): static
    {
        $this->10 = RemoveXss($value);
        return $this;
    }

    public function get11(): ?string
    {
        return HtmlDecode($this->11);
    }

    public function set11(?string $value): static
    {
        $this->11 = RemoveXss($value);
        return $this;
    }

    public function get12(): ?string
    {
        return HtmlDecode($this->12);
    }

    public function set12(?string $value): static
    {
        $this->12 = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getImage(): ?string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(?string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getBuyerUid(): ?string
    {
        return HtmlDecode($this->buyerUid);
    }

    public function setBuyerUid(?string $value): static
    {
        $this->buyerUid = RemoveXss($value);
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getRText(): ?string
    {
        return HtmlDecode($this->rText);
    }

    public function setRText(?string $value): static
    {
        $this->rText = RemoveXss($value);
        return $this;
    }

    public function getTId(): ?int
    {
        return $this->tId;
    }

    public function setTId(?int $value): static
    {
        $this->tId = $value;
        return $this;
    }
}
