<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "product_cart_b" table
 */
#[Entity]
#[Table(name: "product_cart_b")]
class ProductCartB extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "po_id", type: "smallint", nullable: true)]
    private ?int $poId;

    #[Column(type: "smallint", nullable: true)]
    private ?int $location;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(name: "partner_order_no", type: "string", nullable: true)]
    private ?string $partnerOrderNo;

    #[Column(name: "partner_id", type: "integer", nullable: true)]
    private ?int $partnerId;

    #[Column(name: "partner_rid", type: "string", nullable: true)]
    private ?string $partnerRid;

    #[Column(name: "partner_code", type: "string", nullable: true)]
    private ?string $partnerCode;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(type: "string", nullable: true)]
    private ?string $rid;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(name: "batch_no", type: "smallint", nullable: true)]
    private ?int $batchNo;

    #[Column(type: "integer", nullable: true)]
    private ?int $shape;

    #[Column(name: "product_type", type: "smallint")]
    private int $productType;

    #[Column(type: "smallint", nullable: true)]
    private ?int $unit;

    #[Column(type: "string", nullable: true)]
    private ?string $w;

    #[Column(name: "w_cm", type: "float", nullable: true)]
    private ?float $wCm;

    #[Column(type: "string", nullable: true)]
    private ?string $l;

    #[Column(name: "l_cm", type: "float", nullable: true)]
    private ?float $lCm;

    #[Column(type: "string", nullable: true)]
    private ?string $h;

    #[Column(name: "h_cm", type: "float", nullable: true)]
    private ?float $hCm;

    #[Column(name: "partner_size", type: "string", nullable: true)]
    private ?string $partnerSize;

    #[Column(type: "string", nullable: true)]
    private ?string $size;

    #[Column(name: "sqm_u", type: "string", nullable: true)]
    private ?string $sqmU;

    #[Column(type: "decimal", nullable: true)]
    private ?string $sqm;

    #[Column(name: "sqm_a", type: "decimal", nullable: true)]
    private ?string $sqmA;

    #[Column(type: "decimal")]
    private string $quantity;

    #[Column(type: "string", nullable: true)]
    private ?string $image;

    #[Column(type: "decimal")]
    private string $price;

    #[Column(type: "smallint")]
    private int $currency;

    #[Column(type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(name: "cart_id", type: "integer", nullable: true)]
    private ?int $cartId;

    #[Column(name: "rid_1", type: "text", nullable: true)]
    private ?string $rid1;

    #[Column(name: "hsn_code", type: "string", nullable: true)]
    private ?string $hsnCode;

    #[Column(name: "despatch_date", type: "date", nullable: true)]
    private ?DateTime $despatchDate;

    #[Column(name: "pkt_quantity", type: "decimal", nullable: true)]
    private ?string $pktQuantity;

    #[Column(name: "multiprice_id", type: "smallint", nullable: true)]
    private ?int $multipriceId;

    #[Column(type: "decimal", nullable: true)]
    private ?string $cbm;

    #[Column(type: "float", nullable: true)]
    private ?float $tax;

    #[Column(name: "tax_amount", type: "decimal", nullable: true)]
    private ?string $taxAmount;

    #[Column(name: "shipping_method", type: "integer", nullable: true)]
    private ?int $shippingMethod;

    #[Column(name: "shipping_local", type: "smallint", nullable: true)]
    private ?int $shippingLocal;

    #[Column(name: "shipping_abroad", type: "float", nullable: true)]
    private ?float $shippingAbroad;

    #[Column(name: "shipping_charge", type: "float", nullable: true)]
    private ?float $shippingCharge;

    #[Column(name: "additional_discount", type: "decimal", nullable: true)]
    private ?string $additionalDiscount;

    #[Column(name: "total_amount", type: "decimal", nullable: true)]
    private ?string $totalAmount;

    #[Column(name: "buyer_uid", type: "text", nullable: true)]
    private ?string $buyerUid;

    #[Column(name: "buyer_loc", type: "string", nullable: true)]
    private ?string $buyerLoc;

    #[Column(name: "discount_price", type: "float")]
    private float $discountPrice;

    #[Column(type: "string", nullable: true)]
    private ?string $label;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "d_remarks", type: "string", nullable: true)]
    private ?string $dRemarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "o_datetime", type: "datetime", nullable: true)]
    private ?DateTime $oDatetime;

    #[Column(name: "cart_amount", type: "float", nullable: true)]
    private ?float $cartAmount;

    #[Column(name: "c_total", type: "smallint", nullable: true)]
    private ?int $cTotal;

    #[Column(type: "string", nullable: true)]
    private ?string $1;

    #[Column(type: "string", nullable: true)]
    private ?string $2;

    #[Column(type: "string", nullable: true)]
    private ?string $3;

    #[Column(type: "string", nullable: true)]
    private ?string $4;

    #[Column(type: "string", nullable: true)]
    private ?string $5;

    #[Column(type: "string", nullable: true)]
    private ?string $6;

    #[Column(type: "string", nullable: true)]
    private ?string $7;

    #[Column(type: "string", nullable: true)]
    private ?string $8;

    #[Column(name: "r_text", type: "text", nullable: true)]
    private ?string $rText;

    #[Column(name: "t_id", type: "integer", nullable: true)]
    private ?int $tId;

    #[Column(type: "string", nullable: true)]
    private ?string $9;

    #[Column(type: "string", nullable: true)]
    private ?string $10;

    #[Column(type: "string", nullable: true)]
    private ?string $11;

    #[Column(type: "string", nullable: true)]
    private ?string $12;

    #[Column(name: "m_out_id", type: "string", nullable: true)]
    private ?string $mOutId;

    #[Column(name: "reports_to", type: "smallint", nullable: true)]
    private ?int $reportsTo;

    #[Column(name: "q_sku", type: "decimal", nullable: true)]
    private ?string $qSku;

    #[Column(name: "pam_qty", type: "decimal", nullable: true)]
    private ?string $pamQty;

    #[Column(name: "grp_type", type: "smallint", nullable: true)]
    private ?int $grpType;

    #[Column(name: "jc_qty", type: "decimal", nullable: true)]
    private ?string $jcQty;

    #[Column(name: "dispatch_week", type: "smallint", nullable: true)]
    private ?int $dispatchWeek;

    #[Column(type: "smallint", nullable: true)]
    private ?int $level;

    #[Column(name: "sale_id", type: "string")]
    private string $saleId;

    #[Column(name: "sale_qty", type: "decimal")]
    private string $saleQty;

    #[Column(type: "decimal", nullable: true)]
    private ?string $balance;

    public function __construct()
    {
        $this->poId = 0;
        $this->location = ((isset($_GET["pcl"]))? $_GET["pcl"]:((isset($_COOKIE["pcl"]))? $_COOKIE["pcl"]:''));
        $this->companyId = ((isset($_GET["CID"]))? $_GET["CID"]:((isset($_COOKIE["company_id"]))? $_COOKIE["company_id"]:User_Company_ID()));
        $this->partnerOrderNo = ((isset($_GET["POD"]))? $_GET["POD"]:((isset($_COOKIE["POD"]))? $_COOKIE["POD"]:''));
        $this->partnerId = ((isset($_GET["PID"]))? $_GET["PID"]:((isset($_COOKIE["partner_id"]))? $_COOKIE["partner_id"]:''));
        $this->grp = ((isset($_GET["grp"]))? $_GET["grp"]:((isset($_COOKIE["grp"]))? $_COOKIE["grp"]:''));
        $this->sGrp = ((isset($_GET["s_grp"]))? $_GET["s_grp"]:((isset($_COOKIE["s_grp"]))? $_COOKIE["s_grp"]:''));
        $this->product = ((isset($_GET["product"]))? $_GET["product"]:((isset($_COOKIE["product"]))? $_COOKIE["product"]:''));
        $this->packingType = ((isset($_GET["pt"]))? $_GET["pt"]:((isset($_COOKIE["pt"]))? $_COOKIE["pt"]:301));
        $this->shape = 1;
        $this->productType = 0;
        $this->unit = ((isset($_COOKIE["unit"]))? $_COOKIE["unit"]:'');
        $this->w = "00";
        $this->l = "00";
        $this->h = "00";
        $this->quantity = ((isset($_GET["qty"]))? $_GET["qty"]:'2');
        $this->price = "0";
        $this->currency = ((isset($_COOKIE["partner_cur"]))? $_COOKIE["partner_cur"]:'');
        $this->amount = "0";
        $this->shippingCharge = 0.00;
        $this->additionalDiscount = "0.00";
        $this->buyerUid = ((isset($_COOKIE["buyer_uid"]))? $_COOKIE["buyer_uid"]:'');
        $this->label = ((isset($_COOKIE["label"]))? $_COOKIE["label"]:'');
        $this->remarks = ((isset($_COOKIE["remarks"]))? $_COOKIE["remarks"]:'');
        $this->dRemarks = "NA";
        $this->operator = 0;
        $this->qSku = "0.00";
        $this->pamQty = "0.000";
        $this->jcQty = "0.000";
        $this->level = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPoId(): ?int
    {
        return $this->poId;
    }

    public function setPoId(?int $value): static
    {
        $this->poId = $value;
        return $this;
    }

    public function getLocation(): ?int
    {
        return $this->location;
    }

    public function setLocation(?int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getPartnerOrderNo(): ?string
    {
        return HtmlDecode($this->partnerOrderNo);
    }

    public function setPartnerOrderNo(?string $value): static
    {
        $this->partnerOrderNo = RemoveXss($value);
        return $this;
    }

    public function getPartnerId(): ?int
    {
        return $this->partnerId;
    }

    public function setPartnerId(?int $value): static
    {
        $this->partnerId = $value;
        return $this;
    }

    public function getPartnerRid(): ?string
    {
        return HtmlDecode($this->partnerRid);
    }

    public function setPartnerRid(?string $value): static
    {
        $this->partnerRid = RemoveXss($value);
        return $this;
    }

    public function getPartnerCode(): ?string
    {
        return HtmlDecode($this->partnerCode);
    }

    public function setPartnerCode(?string $value): static
    {
        $this->partnerCode = RemoveXss($value);
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): ?string
    {
        return HtmlDecode($this->rid);
    }

    public function setRid(?string $value): static
    {
        $this->rid = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getBatchNo(): ?int
    {
        return $this->batchNo;
    }

    public function setBatchNo(?int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getShape(): ?int
    {
        return $this->shape;
    }

    public function setShape(?int $value): static
    {
        $this->shape = $value;
        return $this;
    }

    public function getProductType(): int
    {
        return $this->productType;
    }

    public function setProductType(int $value): static
    {
        $this->productType = $value;
        return $this;
    }

    public function getUnit(): ?int
    {
        return $this->unit;
    }

    public function setUnit(?int $value): static
    {
        $this->unit = $value;
        return $this;
    }

    public function getW(): ?string
    {
        return HtmlDecode($this->w);
    }

    public function setW(?string $value): static
    {
        $this->w = RemoveXss($value);
        return $this;
    }

    public function getWCm(): ?float
    {
        return $this->wCm;
    }

    public function setWCm(?float $value): static
    {
        $this->wCm = $value;
        return $this;
    }

    public function getL(): ?string
    {
        return HtmlDecode($this->l);
    }

    public function setL(?string $value): static
    {
        $this->l = RemoveXss($value);
        return $this;
    }

    public function getLCm(): ?float
    {
        return $this->lCm;
    }

    public function setLCm(?float $value): static
    {
        $this->lCm = $value;
        return $this;
    }

    public function getH(): ?string
    {
        return HtmlDecode($this->h);
    }

    public function setH(?string $value): static
    {
        $this->h = RemoveXss($value);
        return $this;
    }

    public function getHCm(): ?float
    {
        return $this->hCm;
    }

    public function setHCm(?float $value): static
    {
        $this->hCm = $value;
        return $this;
    }

    public function getPartnerSize(): ?string
    {
        return HtmlDecode($this->partnerSize);
    }

    public function setPartnerSize(?string $value): static
    {
        $this->partnerSize = RemoveXss($value);
        return $this;
    }

    public function getSize(): ?string
    {
        return HtmlDecode($this->size);
    }

    public function setSize(?string $value): static
    {
        $this->size = RemoveXss($value);
        return $this;
    }

    public function getSqmU(): ?string
    {
        return HtmlDecode($this->sqmU);
    }

    public function setSqmU(?string $value): static
    {
        $this->sqmU = RemoveXss($value);
        return $this;
    }

    public function getSqm(): ?string
    {
        return $this->sqm;
    }

    public function setSqm(?string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getSqmA(): ?string
    {
        return $this->sqmA;
    }

    public function setSqmA(?string $value): static
    {
        $this->sqmA = $value;
        return $this;
    }

    public function getQuantity(): string
    {
        return $this->quantity;
    }

    public function setQuantity(string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getImage(): ?string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(?string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getPrice(): string
    {
        return $this->price;
    }

    public function setPrice(string $value): static
    {
        $this->price = $value;
        return $this;
    }

    public function getCurrency(): int
    {
        return $this->currency;
    }

    public function setCurrency(int $value): static
    {
        $this->currency = $value;
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getCartId(): ?int
    {
        return $this->cartId;
    }

    public function setCartId(?int $value): static
    {
        $this->cartId = $value;
        return $this;
    }

    public function getRid1(): ?string
    {
        return HtmlDecode($this->rid1);
    }

    public function setRid1(?string $value): static
    {
        $this->rid1 = RemoveXss($value);
        return $this;
    }

    public function getHsnCode(): ?string
    {
        return HtmlDecode($this->hsnCode);
    }

    public function setHsnCode(?string $value): static
    {
        $this->hsnCode = RemoveXss($value);
        return $this;
    }

    public function getDespatchDate(): ?DateTime
    {
        return $this->despatchDate;
    }

    public function setDespatchDate(?DateTime $value): static
    {
        $this->despatchDate = $value;
        return $this;
    }

    public function getPktQuantity(): ?string
    {
        return $this->pktQuantity;
    }

    public function setPktQuantity(?string $value): static
    {
        $this->pktQuantity = $value;
        return $this;
    }

    public function getMultipriceId(): ?int
    {
        return $this->multipriceId;
    }

    public function setMultipriceId(?int $value): static
    {
        $this->multipriceId = $value;
        return $this;
    }

    public function getCbm(): ?string
    {
        return $this->cbm;
    }

    public function setCbm(?string $value): static
    {
        $this->cbm = $value;
        return $this;
    }

    public function getTax(): ?float
    {
        return $this->tax;
    }

    public function setTax(?float $value): static
    {
        $this->tax = $value;
        return $this;
    }

    public function getTaxAmount(): ?string
    {
        return $this->taxAmount;
    }

    public function setTaxAmount(?string $value): static
    {
        $this->taxAmount = $value;
        return $this;
    }

    public function getShippingMethod(): ?int
    {
        return $this->shippingMethod;
    }

    public function setShippingMethod(?int $value): static
    {
        $this->shippingMethod = $value;
        return $this;
    }

    public function getShippingLocal(): ?int
    {
        return $this->shippingLocal;
    }

    public function setShippingLocal(?int $value): static
    {
        $this->shippingLocal = $value;
        return $this;
    }

    public function getShippingAbroad(): ?float
    {
        return $this->shippingAbroad;
    }

    public function setShippingAbroad(?float $value): static
    {
        $this->shippingAbroad = $value;
        return $this;
    }

    public function getShippingCharge(): ?float
    {
        return $this->shippingCharge;
    }

    public function setShippingCharge(?float $value): static
    {
        $this->shippingCharge = $value;
        return $this;
    }

    public function getAdditionalDiscount(): ?string
    {
        return $this->additionalDiscount;
    }

    public function setAdditionalDiscount(?string $value): static
    {
        $this->additionalDiscount = $value;
        return $this;
    }

    public function getTotalAmount(): ?string
    {
        return $this->totalAmount;
    }

    public function setTotalAmount(?string $value): static
    {
        $this->totalAmount = $value;
        return $this;
    }

    public function getBuyerUid(): ?string
    {
        return HtmlDecode($this->buyerUid);
    }

    public function setBuyerUid(?string $value): static
    {
        $this->buyerUid = RemoveXss($value);
        return $this;
    }

    public function getBuyerLoc(): ?string
    {
        return HtmlDecode($this->buyerLoc);
    }

    public function setBuyerLoc(?string $value): static
    {
        $this->buyerLoc = RemoveXss($value);
        return $this;
    }

    public function getDiscountPrice(): float
    {
        return $this->discountPrice;
    }

    public function setDiscountPrice(float $value): static
    {
        $this->discountPrice = $value;
        return $this;
    }

    public function getLabel(): ?string
    {
        return HtmlDecode($this->label);
    }

    public function setLabel(?string $value): static
    {
        $this->label = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getDRemarks(): ?string
    {
        return HtmlDecode($this->dRemarks);
    }

    public function setDRemarks(?string $value): static
    {
        $this->dRemarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getODatetime(): ?DateTime
    {
        return $this->oDatetime;
    }

    public function setODatetime(?DateTime $value): static
    {
        $this->oDatetime = $value;
        return $this;
    }

    public function getCartAmount(): ?float
    {
        return $this->cartAmount;
    }

    public function setCartAmount(?float $value): static
    {
        $this->cartAmount = $value;
        return $this;
    }

    public function getCTotal(): ?int
    {
        return $this->cTotal;
    }

    public function setCTotal(?int $value): static
    {
        $this->cTotal = $value;
        return $this;
    }

    public function get1(): ?string
    {
        return HtmlDecode($this->1);
    }

    public function set1(?string $value): static
    {
        $this->1 = RemoveXss($value);
        return $this;
    }

    public function get2(): ?string
    {
        return HtmlDecode($this->2);
    }

    public function set2(?string $value): static
    {
        $this->2 = RemoveXss($value);
        return $this;
    }

    public function get3(): ?string
    {
        return HtmlDecode($this->3);
    }

    public function set3(?string $value): static
    {
        $this->3 = RemoveXss($value);
        return $this;
    }

    public function get4(): ?string
    {
        return HtmlDecode($this->4);
    }

    public function set4(?string $value): static
    {
        $this->4 = RemoveXss($value);
        return $this;
    }

    public function get5(): ?string
    {
        return HtmlDecode($this->5);
    }

    public function set5(?string $value): static
    {
        $this->5 = RemoveXss($value);
        return $this;
    }

    public function get6(): ?string
    {
        return HtmlDecode($this->6);
    }

    public function set6(?string $value): static
    {
        $this->6 = RemoveXss($value);
        return $this;
    }

    public function get7(): ?string
    {
        return HtmlDecode($this->7);
    }

    public function set7(?string $value): static
    {
        $this->7 = RemoveXss($value);
        return $this;
    }

    public function get8(): ?string
    {
        return HtmlDecode($this->8);
    }

    public function set8(?string $value): static
    {
        $this->8 = RemoveXss($value);
        return $this;
    }

    public function getRText(): ?string
    {
        return HtmlDecode($this->rText);
    }

    public function setRText(?string $value): static
    {
        $this->rText = RemoveXss($value);
        return $this;
    }

    public function getTId(): ?int
    {
        return $this->tId;
    }

    public function setTId(?int $value): static
    {
        $this->tId = $value;
        return $this;
    }

    public function get9(): ?string
    {
        return HtmlDecode($this->9);
    }

    public function set9(?string $value): static
    {
        $this->9 = RemoveXss($value);
        return $this;
    }

    public function get10(): ?string
    {
        return HtmlDecode($this->10);
    }

    public function set10(?string $value): static
    {
        $this->10 = RemoveXss($value);
        return $this;
    }

    public function get11(): ?string
    {
        return HtmlDecode($this->11);
    }

    public function set11(?string $value): static
    {
        $this->11 = RemoveXss($value);
        return $this;
    }

    public function get12(): ?string
    {
        return HtmlDecode($this->12);
    }

    public function set12(?string $value): static
    {
        $this->12 = RemoveXss($value);
        return $this;
    }

    public function getMOutId(): ?string
    {
        return HtmlDecode($this->mOutId);
    }

    public function setMOutId(?string $value): static
    {
        $this->mOutId = RemoveXss($value);
        return $this;
    }

    public function getReportsTo(): ?int
    {
        return $this->reportsTo;
    }

    public function setReportsTo(?int $value): static
    {
        $this->reportsTo = $value;
        return $this;
    }

    public function getQSku(): ?string
    {
        return $this->qSku;
    }

    public function setQSku(?string $value): static
    {
        $this->qSku = $value;
        return $this;
    }

    public function getPamQty(): ?string
    {
        return $this->pamQty;
    }

    public function setPamQty(?string $value): static
    {
        $this->pamQty = $value;
        return $this;
    }

    public function getGrpType(): ?int
    {
        return $this->grpType;
    }

    public function setGrpType(?int $value): static
    {
        $this->grpType = $value;
        return $this;
    }

    public function getJcQty(): ?string
    {
        return $this->jcQty;
    }

    public function setJcQty(?string $value): static
    {
        $this->jcQty = $value;
        return $this;
    }

    public function getDispatchWeek(): ?int
    {
        return $this->dispatchWeek;
    }

    public function setDispatchWeek(?int $value): static
    {
        $this->dispatchWeek = $value;
        return $this;
    }

    public function getLevel(): ?int
    {
        return $this->level;
    }

    public function setLevel(?int $value): static
    {
        $this->level = $value;
        return $this;
    }

    public function getSaleId(): string
    {
        return HtmlDecode($this->saleId);
    }

    public function setSaleId(string $value): static
    {
        $this->saleId = RemoveXss($value);
        return $this;
    }

    public function getSaleQty(): string
    {
        return $this->saleQty;
    }

    public function setSaleQty(string $value): static
    {
        $this->saleQty = $value;
        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $value): static
    {
        $this->balance = $value;
        return $this;
    }
}
