<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "product" table
 */
#[Entity]
#[Table(name: "product")]
class Product extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string")]
    private string $grp;

    #[Column(name: "s_grp", type: "string")]
    private string $sGrp;

    #[Column(type: "string", nullable: true)]
    private ?string $product;

    #[Column(type: "integer")]
    private int $publish;

    #[Column(type: "string", nullable: true)]
    private ?string $image;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "company_id", type: "integer")]
    private int $companyId;

    #[Column(name: "prod_capacity", type: "decimal", nullable: true)]
    private ?string $prodCapacity;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->publish = 1;
        $this->status = 1;
        $this->companyId = User_Company_ID();
        $this->prodCapacity = "100";
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): string
    {
        return HtmlDecode($this->grp);
    }

    public function setGrp(string $value): static
    {
        $this->grp = RemoveXss($value);
        return $this;
    }

    public function getSGrp(): string
    {
        return HtmlDecode($this->sGrp);
    }

    public function setSGrp(string $value): static
    {
        $this->sGrp = RemoveXss($value);
        return $this;
    }

    public function getProduct(): ?string
    {
        return HtmlDecode($this->product);
    }

    public function setProduct(?string $value): static
    {
        $this->product = RemoveXss($value);
        return $this;
    }

    public function getPublish(): int
    {
        return $this->publish;
    }

    public function setPublish(int $value): static
    {
        $this->publish = $value;
        return $this;
    }

    public function getImage(): ?string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(?string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getCompanyId(): int
    {
        return $this->companyId;
    }

    public function setCompanyId(int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getProdCapacity(): ?string
    {
        return $this->prodCapacity;
    }

    public function setProdCapacity(?string $value): static
    {
        $this->prodCapacity = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
