<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "prod_plan_log" table
 */
#[Entity]
#[Table(name: "prod_plan_log")]
class ProdPlanLog extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $po;

    #[Column(name: "prod_plan", type: "smallint")]
    private int $prodPlan;

    #[Column(type: "smallint")]
    private int $item;

    #[Column(name: "start_date", type: "date")]
    private DateTime $startDate;

    #[Column(name: "end_date", type: "date")]
    private DateTime $endDate;

    #[Column(name: "delivery_date", type: "date")]
    private DateTime $deliveryDate;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPo(): int
    {
        return $this->po;
    }

    public function setPo(int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getProdPlan(): int
    {
        return $this->prodPlan;
    }

    public function setProdPlan(int $value): static
    {
        $this->prodPlan = $value;
        return $this;
    }

    public function getItem(): int
    {
        return $this->item;
    }

    public function setItem(int $value): static
    {
        $this->item = $value;
        return $this;
    }

    public function getStartDate(): DateTime
    {
        return $this->startDate;
    }

    public function setStartDate(DateTime $value): static
    {
        $this->startDate = $value;
        return $this;
    }

    public function getEndDate(): DateTime
    {
        return $this->endDate;
    }

    public function setEndDate(DateTime $value): static
    {
        $this->endDate = $value;
        return $this;
    }

    public function getDeliveryDate(): DateTime
    {
        return $this->deliveryDate;
    }

    public function setDeliveryDate(DateTime $value): static
    {
        $this->deliveryDate = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
