<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "process_yeild" table
 */
#[Entity]
#[Table(name: "process_yeild")]
class ProcessYeild extends AbstractEntity
{
    #[Column(type: "integer", nullable: true)]
    private ?int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $po;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(type: "string", nullable: true)]
    private ?string $process;

    #[Column(type: "float", nullable: true)]
    private ?float $yeild;

    #[Column(name: "jc_yeild", type: "float", nullable: true)]
    private ?float $jcYeild;

    #[Column(name: "cart_quantity", type: "float", nullable: true)]
    private ?float $cartQuantity;

    #[Column(name: "pam_qty", type: "string", nullable: true)]
    private ?string $pamQty;

    #[Column(name: "pending_qty", type: "string", nullable: true)]
    private ?string $pendingQty;

    #[Column(name: "pp_qty", type: "string", nullable: true)]
    private ?string $ppQty;

    #[Column(name: "packing_type", type: "text", nullable: true)]
    private ?string $packingType;

    #[Column(name: "batch_no", type: "string", nullable: true)]
    private ?string $batchNo;

    #[Column(name: "issue_to", type: "decimal", nullable: true)]
    private ?string $issueTo;

    #[Column(name: "jc_no", type: "text", nullable: true)]
    private ?string $jcNo;

    #[Column(name: "jc_quantity", type: "float", nullable: true)]
    private ?float $jcQuantity;

    #[Column(name: "despatch_week", type: "string", nullable: true)]
    private ?string $despatchWeek;

    #[Column(name: "despatch_date", type: "string", nullable: true)]
    private ?string $despatchDate;

    #[Column(name: "company_id", type: "decimal", nullable: true)]
    private ?string $companyId;

    #[Column(name: "par_com", type: "integer", nullable: true)]
    private ?int $parCom;

    #[Column(name: "last_processing_date", type: "datetime", nullable: true)]
    private ?DateTime $lastProcessingDate;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(?int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPo(): ?string
    {
        return HtmlDecode($this->po);
    }

    public function setPo(?string $value): static
    {
        $this->po = RemoveXss($value);
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getProcess(): ?string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(?string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }

    public function getYeild(): ?float
    {
        return $this->yeild;
    }

    public function setYeild(?float $value): static
    {
        $this->yeild = $value;
        return $this;
    }

    public function getJcYeild(): ?float
    {
        return $this->jcYeild;
    }

    public function setJcYeild(?float $value): static
    {
        $this->jcYeild = $value;
        return $this;
    }

    public function getCartQuantity(): ?float
    {
        return $this->cartQuantity;
    }

    public function setCartQuantity(?float $value): static
    {
        $this->cartQuantity = $value;
        return $this;
    }

    public function getPamQty(): ?string
    {
        return HtmlDecode($this->pamQty);
    }

    public function setPamQty(?string $value): static
    {
        $this->pamQty = RemoveXss($value);
        return $this;
    }

    public function getPendingQty(): ?string
    {
        return HtmlDecode($this->pendingQty);
    }

    public function setPendingQty(?string $value): static
    {
        $this->pendingQty = RemoveXss($value);
        return $this;
    }

    public function getPpQty(): ?string
    {
        return HtmlDecode($this->ppQty);
    }

    public function setPpQty(?string $value): static
    {
        $this->ppQty = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): ?string
    {
        return HtmlDecode($this->packingType);
    }

    public function setPackingType(?string $value): static
    {
        $this->packingType = RemoveXss($value);
        return $this;
    }

    public function getBatchNo(): ?string
    {
        return HtmlDecode($this->batchNo);
    }

    public function setBatchNo(?string $value): static
    {
        $this->batchNo = RemoveXss($value);
        return $this;
    }

    public function getIssueTo(): ?string
    {
        return $this->issueTo;
    }

    public function setIssueTo(?string $value): static
    {
        $this->issueTo = $value;
        return $this;
    }

    public function getJcNo(): ?string
    {
        return HtmlDecode($this->jcNo);
    }

    public function setJcNo(?string $value): static
    {
        $this->jcNo = RemoveXss($value);
        return $this;
    }

    public function getJcQuantity(): ?float
    {
        return $this->jcQuantity;
    }

    public function setJcQuantity(?float $value): static
    {
        $this->jcQuantity = $value;
        return $this;
    }

    public function getDespatchWeek(): ?string
    {
        return HtmlDecode($this->despatchWeek);
    }

    public function setDespatchWeek(?string $value): static
    {
        $this->despatchWeek = RemoveXss($value);
        return $this;
    }

    public function getDespatchDate(): ?string
    {
        return HtmlDecode($this->despatchDate);
    }

    public function setDespatchDate(?string $value): static
    {
        $this->despatchDate = RemoveXss($value);
        return $this;
    }

    public function getCompanyId(): ?string
    {
        return $this->companyId;
    }

    public function setCompanyId(?string $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getParCom(): ?int
    {
        return $this->parCom;
    }

    public function setParCom(?int $value): static
    {
        $this->parCom = $value;
        return $this;
    }

    public function getLastProcessingDate(): ?DateTime
    {
        return $this->lastProcessingDate;
    }

    public function setLastProcessingDate(?DateTime $value): static
    {
        $this->lastProcessingDate = $value;
        return $this;
    }
}
