<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "process_wbc_wpp" table
 */
#[Entity]
#[Table(name: "process_wbc_wpp")]
class ProcessWbcWpp extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "partner_id", type: "integer", nullable: true)]
    private ?int $partnerId;

    #[Column(type: "integer", nullable: true)]
    private ?int $po;

    #[Column(name: "dispatch_week", type: "smallint", nullable: true)]
    private ?int $dispatchWeek;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(name: "rid_tmp", type: "string", nullable: true)]
    private ?string $ridTmp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $rid;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(name: "sub_process", type: "smallint", nullable: true)]
    private ?int $subProcess;

    #[Column(name: "quantity_sub", type: "integer")]
    private int $quantitySub;

    #[Column(type: "decimal", nullable: true)]
    private ?string $qty;

    #[Column(name: "p_qty", type: "decimal")]
    private string $pQty;

    #[Column(name: "c_qty_remarks", type: "string", nullable: true)]
    private ?string $cQtyRemarks;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "cart_id", type: "integer", nullable: true)]
    private ?int $cartId;

    #[Column(type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(name: "week_p", type: "string", nullable: true)]
    private ?string $weekP;

    #[Column(name: "process_all", type: "string", nullable: true)]
    private ?string $processAll;

    #[Column(name: "current_process", type: "smallint", nullable: true)]
    private ?int $currentProcess;

    #[Column(name: "loom_id", type: "smallint", nullable: true)]
    private ?int $loomId;

    #[Column(name: "process_date", type: "date", nullable: true)]
    private ?DateTime $processDate;

    #[Column(name: "process_complete", type: "datetime", nullable: true)]
    private ?DateTime $processComplete;

    #[Column(name: "m_out_id", type: "string", nullable: true)]
    private ?string $mOutId;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->quantitySub = 0;
        $this->amount = "0.00";
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPartnerId(): ?int
    {
        return $this->partnerId;
    }

    public function setPartnerId(?int $value): static
    {
        $this->partnerId = $value;
        return $this;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getDispatchWeek(): ?int
    {
        return $this->dispatchWeek;
    }

    public function setDispatchWeek(?int $value): static
    {
        $this->dispatchWeek = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRidTmp(): ?string
    {
        return HtmlDecode($this->ridTmp);
    }

    public function setRidTmp(?string $value): static
    {
        $this->ridTmp = RemoveXss($value);
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getSubProcess(): ?int
    {
        return $this->subProcess;
    }

    public function setSubProcess(?int $value): static
    {
        $this->subProcess = $value;
        return $this;
    }

    public function getQuantitySub(): int
    {
        return $this->quantitySub;
    }

    public function setQuantitySub(int $value): static
    {
        $this->quantitySub = $value;
        return $this;
    }

    public function getQty(): ?string
    {
        return $this->qty;
    }

    public function setQty(?string $value): static
    {
        $this->qty = $value;
        return $this;
    }

    public function getPQty(): string
    {
        return $this->pQty;
    }

    public function setPQty(string $value): static
    {
        $this->pQty = $value;
        return $this;
    }

    public function getCQtyRemarks(): ?string
    {
        return HtmlDecode($this->cQtyRemarks);
    }

    public function setCQtyRemarks(?string $value): static
    {
        $this->cQtyRemarks = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getCartId(): ?int
    {
        return $this->cartId;
    }

    public function setCartId(?int $value): static
    {
        $this->cartId = $value;
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getWeekP(): ?string
    {
        return HtmlDecode($this->weekP);
    }

    public function setWeekP(?string $value): static
    {
        $this->weekP = RemoveXss($value);
        return $this;
    }

    public function getProcessAll(): ?string
    {
        return HtmlDecode($this->processAll);
    }

    public function setProcessAll(?string $value): static
    {
        $this->processAll = RemoveXss($value);
        return $this;
    }

    public function getCurrentProcess(): ?int
    {
        return $this->currentProcess;
    }

    public function setCurrentProcess(?int $value): static
    {
        $this->currentProcess = $value;
        return $this;
    }

    public function getLoomId(): ?int
    {
        return $this->loomId;
    }

    public function setLoomId(?int $value): static
    {
        $this->loomId = $value;
        return $this;
    }

    public function getProcessDate(): ?DateTime
    {
        return $this->processDate;
    }

    public function setProcessDate(?DateTime $value): static
    {
        $this->processDate = $value;
        return $this;
    }

    public function getProcessComplete(): ?DateTime
    {
        return $this->processComplete;
    }

    public function setProcessComplete(?DateTime $value): static
    {
        $this->processComplete = $value;
        return $this;
    }

    public function getMOutId(): ?string
    {
        return HtmlDecode($this->mOutId);
    }

    public function setMOutId(?string $value): static
    {
        $this->mOutId = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
