<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "process_table_old" table
 */
#[Entity]
#[Table(name: "process_table_old")]
class ProcessTableOld extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $type;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(type: "integer", nullable: true)]
    private ?int $partner;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(type: "string", nullable: true)]
    private ?string $ref;

    #[Column(name: "ref_internal", type: "string", nullable: true)]
    private ?string $refInternal;

    #[Column(name: "out_ref", type: "smallint")]
    private int $outRef;

    #[Column(name: "grp_processed", type: "smallint")]
    private int $grpProcessed;

    #[Column(name: "s_grp_processed", type: "smallint")]
    private int $sGrpProcessed;

    #[Column(name: "product_processed", type: "smallint")]
    private int $productProcessed;

    #[Column(type: "smallint")]
    private int $rid;

    #[Column(type: "smallint", nullable: true)]
    private ?int $packets;

    #[Column(type: "decimal", nullable: true)]
    private ?string $quantity;

    #[Column(name: "tmp_lot", type: "string")]
    private string $tmpLot;

    #[Column(name: "par_com", type: "integer")]
    private int $parCom;

    #[Column(name: "packing_type", type: "integer", nullable: true)]
    private ?int $packingType;

    #[Column(type: "integer", nullable: true)]
    private ?int $godown;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dated;

    #[Column(name: "employee_id", type: "string")]
    private string $employeeId;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    public function __construct()
    {
        $this->type = 105;
        $this->partner = ((isset($_GET["prid"]))? $_GET["prid"]:((isset($_COOKIE["prid"]))? $_COOKIE["prid"]:''));
        $this->tmpLot = 'NA';
        $this->parCom = 0;
        $this->employeeId = "1000";
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getPartner(): ?int
    {
        return $this->partner;
    }

    public function setPartner(?int $value): static
    {
        $this->partner = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRef(): ?string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(?string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }

    public function getRefInternal(): ?string
    {
        return HtmlDecode($this->refInternal);
    }

    public function setRefInternal(?string $value): static
    {
        $this->refInternal = RemoveXss($value);
        return $this;
    }

    public function getOutRef(): int
    {
        return $this->outRef;
    }

    public function setOutRef(int $value): static
    {
        $this->outRef = $value;
        return $this;
    }

    public function getGrpProcessed(): int
    {
        return $this->grpProcessed;
    }

    public function setGrpProcessed(int $value): static
    {
        $this->grpProcessed = $value;
        return $this;
    }

    public function getSGrpProcessed(): int
    {
        return $this->sGrpProcessed;
    }

    public function setSGrpProcessed(int $value): static
    {
        $this->sGrpProcessed = $value;
        return $this;
    }

    public function getProductProcessed(): int
    {
        return $this->productProcessed;
    }

    public function setProductProcessed(int $value): static
    {
        $this->productProcessed = $value;
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getPackets(): ?int
    {
        return $this->packets;
    }

    public function setPackets(?int $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    public function setQuantity(?string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getTmpLot(): string
    {
        return HtmlDecode($this->tmpLot);
    }

    public function setTmpLot(string $value): static
    {
        $this->tmpLot = RemoveXss($value);
        return $this;
    }

    public function getParCom(): int
    {
        return $this->parCom;
    }

    public function setParCom(int $value): static
    {
        $this->parCom = $value;
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getGodown(): ?int
    {
        return $this->godown;
    }

    public function setGodown(?int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getEmployeeId(): string
    {
        return HtmlDecode($this->employeeId);
    }

    public function setEmployeeId(string $value): static
    {
        $this->employeeId = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }
}
