<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "process_table_hs" table
 */
#[Entity]
#[Table(name: "process_table_hs")]
class ProcessTableH extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(type: "integer")]
    private int $godown;

    #[Column(name: "emp_name", type: "string")]
    private string $empName;

    #[Column(type: "smallint")]
    private int $ref;

    #[Column(type: "smallint")]
    private int $rid;

    #[Column(name: "batch_no", type: "smallint")]
    private int $batchNo;

    #[Column(type: "smallint")]
    private int $count;

    #[Column(name: "count_received", type: "string")]
    private string $countReceived;

    #[Column(type: "smallint")]
    private int $twist;

    #[Column(name: "quantity_avg_act", type: "decimal")]
    private string $quantityAvgAct;

    #[Column(type: "decimal")]
    private string $quantity;

    #[Column(type: "integer")]
    private int $status;

    #[Column(name: "std_rate", type: "decimal", nullable: true)]
    private ?string $stdRate;

    #[Column(name: "`@`", options: ["name" => "@"], type: "decimal")]
    private string $40;

    #[Column(name: "total_amount", type: "decimal")]
    private string $totalAmount;

    #[Column(type: "decimal")]
    private string $payment;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(type: "smallint")]
    private int $process;

    #[Column(type: "smallint")]
    private int $packets;

    #[Column(name: "packing_type", type: "integer")]
    private int $packingType;

    #[Column(name: "product_code_new", type: "smallint")]
    private int $productCodeNew;

    #[Column(name: "product_new", type: "smallint")]
    private int $productNew;

    #[Column(type: "date")]
    private DateTime $dated;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(name: "lot_no", type: "smallint")]
    private int $lotNo;

    #[Column(name: "tmp_lot", type: "smallint")]
    private int $tmpLot;

    #[Column(type: "decimal", nullable: true)]
    private ?string $shortage;

    #[Column(name: "shortage_amount", type: "decimal", nullable: true)]
    private ?string $shortageAmount;

    public function __construct()
    {
        $this->grp = 23;
        $this->godown = (isset($_COOKIE["User_Site"]))? $_COOKIE["User_Site"]:"";
        $this->stdRate = "0.00";
        $this->payment = "0.00";
        $this->operator = 0;
        $this->sGrp = 23;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getGodown(): int
    {
        return $this->godown;
    }

    public function setGodown(int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getEmpName(): string
    {
        return HtmlDecode($this->empName);
    }

    public function setEmpName(string $value): static
    {
        $this->empName = RemoveXss($value);
        return $this;
    }

    public function getRef(): int
    {
        return $this->ref;
    }

    public function setRef(int $value): static
    {
        $this->ref = $value;
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getBatchNo(): int
    {
        return $this->batchNo;
    }

    public function setBatchNo(int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getCount(): int
    {
        return $this->count;
    }

    public function setCount(int $value): static
    {
        $this->count = $value;
        return $this;
    }

    public function getCountReceived(): string
    {
        return HtmlDecode($this->countReceived);
    }

    public function setCountReceived(string $value): static
    {
        $this->countReceived = RemoveXss($value);
        return $this;
    }

    public function getTwist(): int
    {
        return $this->twist;
    }

    public function setTwist(int $value): static
    {
        $this->twist = $value;
        return $this;
    }

    public function getQuantityAvgAct(): string
    {
        return $this->quantityAvgAct;
    }

    public function setQuantityAvgAct(string $value): static
    {
        $this->quantityAvgAct = $value;
        return $this;
    }

    public function getQuantity(): string
    {
        return $this->quantity;
    }

    public function setQuantity(string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getStdRate(): ?string
    {
        return $this->stdRate;
    }

    public function setStdRate(?string $value): static
    {
        $this->stdRate = $value;
        return $this;
    }

    public function get40(): string
    {
        return $this->40;
    }

    public function set40(string $value): static
    {
        $this->40 = $value;
        return $this;
    }

    public function getTotalAmount(): string
    {
        return $this->totalAmount;
    }

    public function setTotalAmount(string $value): static
    {
        $this->totalAmount = $value;
        return $this;
    }

    public function getPayment(): string
    {
        return $this->payment;
    }

    public function setPayment(string $value): static
    {
        $this->payment = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getProcess(): int
    {
        return $this->process;
    }

    public function setProcess(int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getPackets(): int
    {
        return $this->packets;
    }

    public function setPackets(int $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getPackingType(): int
    {
        return $this->packingType;
    }

    public function setPackingType(int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getProductCodeNew(): int
    {
        return $this->productCodeNew;
    }

    public function setProductCodeNew(int $value): static
    {
        $this->productCodeNew = $value;
        return $this;
    }

    public function getProductNew(): int
    {
        return $this->productNew;
    }

    public function setProductNew(int $value): static
    {
        $this->productNew = $value;
        return $this;
    }

    public function getDated(): DateTime
    {
        return $this->dated;
    }

    public function setDated(DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getLotNo(): int
    {
        return $this->lotNo;
    }

    public function setLotNo(int $value): static
    {
        $this->lotNo = $value;
        return $this;
    }

    public function getTmpLot(): int
    {
        return $this->tmpLot;
    }

    public function setTmpLot(int $value): static
    {
        $this->tmpLot = $value;
        return $this;
    }

    public function getShortage(): ?string
    {
        return $this->shortage;
    }

    public function setShortage(?string $value): static
    {
        $this->shortage = $value;
        return $this;
    }

    public function getShortageAmount(): ?string
    {
        return $this->shortageAmount;
    }

    public function setShortageAmount(?string $value): static
    {
        $this->shortageAmount = $value;
        return $this;
    }
}
