<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "process_product_f" table
 */
#[Entity]
#[Table(name: "process_product_f")]
class ProcessProductF extends AbstractEntity
{
    #[Column(type: "integer")]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(name: "product_n", type: "string", nullable: true)]
    private ?string $productN;

    #[Column(type: "smallint")]
    private int $rid;

    #[Column(type: "string", nullable: true)]
    private ?string $code;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(name: "lot_no", type: "string", nullable: true)]
    private ?string $lotNo;

    #[Column(name: "process_type", type: "smallint")]
    private int $processType;

    #[Column(name: "tmp_lot", type: "string")]
    private string $tmpLot;

    #[Column(type: "decimal", nullable: true)]
    private ?string $packets;

    #[Column(name: "packing_type", type: "smallint")]
    private int $packingType;

    #[Column(type: "integer", nullable: true)]
    private ?int $godown;

    #[Column(name: "godown_n", type: "string", nullable: true)]
    private ?string $godownN;

    #[Column(type: "string", nullable: true)]
    private ?string $gcode;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $dated;

    #[Column(name: "`IN`", options: ["name" => "IN"], type: "decimal", nullable: true)]
    private ?string $in;

    #[Column(name: "`OUT`", options: ["name" => "OUT"], type: "decimal")]
    private string $out;

    #[Column(name: "Balance", type: "decimal", nullable: true)]
    private ?string $balance;

    #[Column(name: "Item", type: "text", nullable: true)]
    private ?string $item;

    #[Column(name: "new_process", type: "text", nullable: true)]
    private ?string $newProcess;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(name: "avg_yield", type: "decimal", nullable: true)]
    private ?string $avgYield;

    #[Column(type: "string")]
    private string $type;

    #[Column(type: "string")]
    private string $url;

    #[Column(type: "integer", nullable: true)]
    private ?int $age;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    public function __construct()
    {
        $this->id = 0;
        $this->product = 0;
        $this->lotNo = "NA";
        $this->out = "0.00";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getProductN(): ?string
    {
        return HtmlDecode($this->productN);
    }

    public function setProductN(?string $value): static
    {
        $this->productN = RemoveXss($value);
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getCode(): ?string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(?string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getLotNo(): ?string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(?string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getProcessType(): int
    {
        return $this->processType;
    }

    public function setProcessType(int $value): static
    {
        $this->processType = $value;
        return $this;
    }

    public function getTmpLot(): string
    {
        return HtmlDecode($this->tmpLot);
    }

    public function setTmpLot(string $value): static
    {
        $this->tmpLot = RemoveXss($value);
        return $this;
    }

    public function getPackets(): ?string
    {
        return $this->packets;
    }

    public function setPackets(?string $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getPackingType(): int
    {
        return $this->packingType;
    }

    public function setPackingType(int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getGodown(): ?int
    {
        return $this->godown;
    }

    public function setGodown(?int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getGodownN(): ?string
    {
        return HtmlDecode($this->godownN);
    }

    public function setGodownN(?string $value): static
    {
        $this->godownN = RemoveXss($value);
        return $this;
    }

    public function getGcode(): ?string
    {
        return HtmlDecode($this->gcode);
    }

    public function setGcode(?string $value): static
    {
        $this->gcode = RemoveXss($value);
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getIn(): ?string
    {
        return $this->in;
    }

    public function setIn(?string $value): static
    {
        $this->in = $value;
        return $this;
    }

    public function getOut(): string
    {
        return $this->out;
    }

    public function setOut(string $value): static
    {
        $this->out = $value;
        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $value): static
    {
        $this->balance = $value;
        return $this;
    }

    public function getItem(): ?string
    {
        return HtmlDecode($this->item);
    }

    public function setItem(?string $value): static
    {
        $this->item = RemoveXss($value);
        return $this;
    }

    public function getNewProcess(): ?string
    {
        return HtmlDecode($this->newProcess);
    }

    public function setNewProcess(?string $value): static
    {
        $this->newProcess = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getAvgYield(): ?string
    {
        return $this->avgYield;
    }

    public function setAvgYield(?string $value): static
    {
        $this->avgYield = $value;
        return $this;
    }

    public function getType(): string
    {
        return HtmlDecode($this->type);
    }

    public function setType(string $value): static
    {
        $this->type = RemoveXss($value);
        return $this;
    }

    public function getUrl(): string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }

    public function getAge(): ?int
    {
        return $this->age;
    }

    public function setAge(?int $value): static
    {
        $this->age = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }
}
