<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "process_mismatch" table
 */
#[Entity]
#[Table(name: "process_mismatch")]
class ProcessMismatch extends AbstractEntity
{
    #[Column(type: "integer", nullable: true)]
    private ?int $barcode;

    #[Column(type: "integer")]
    private int $code;

    #[Column(type: "smallint")]
    private int $process;

    #[Column(name: "process_other", type: "string", nullable: true)]
    private ?string $processOther;

    #[Column(name: "process_c", type: "string", nullable: true)]
    private ?string $processC;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Id]
    #[Column(type: "integer")]
    #[GeneratedValue]
    private int $id;

    public function __construct()
    {
        $this->barcode = 0;
        $this->operator = 0;
    }

    public function getBarcode(): ?int
    {
        return $this->barcode;
    }

    public function setBarcode(?int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getCode(): int
    {
        return $this->code;
    }

    public function setCode(int $value): static
    {
        $this->code = $value;
        return $this;
    }

    public function getProcess(): int
    {
        return $this->process;
    }

    public function setProcess(int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getProcessOther(): ?string
    {
        return HtmlDecode($this->processOther);
    }

    public function setProcessOther(?string $value): static
    {
        $this->processOther = RemoveXss($value);
        return $this;
    }

    public function getProcessC(): ?string
    {
        return HtmlDecode($this->processC);
    }

    public function setProcessC(?string $value): static
    {
        $this->processC = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }
}
