<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "process_action_single_old" table
 */
#[Entity]
#[Table(name: "process_action_single_old")]
class ProcessActionSingleOld extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $location;

    #[Column(name: "employee_1", type: "smallint", nullable: true)]
    private ?int $employee1;

    #[Column(name: "employee_2", type: "smallint", nullable: true)]
    private ?int $employee2;

    #[Column(name: "employee_3", type: "smallint", nullable: true)]
    private ?int $employee3;

    #[Column(name: "employee_id", type: "string", nullable: true)]
    private ?string $employeeId;

    #[Column(type: "smallint")]
    private int $process;

    #[Column(name: "confirm_process", type: "smallint")]
    private int $confirmProcess;

    #[Column(name: "process_other", type: "string", nullable: true)]
    private ?string $processOther;

    #[Column(type: "integer")]
    private int $code;

    #[Column(name: "size_actual", type: "string", nullable: true)]
    private ?string $sizeActual;

    #[Column(name: "weight_actual", type: "decimal", nullable: true)]
    private ?string $weightActual;

    #[Column(type: "smallint", nullable: true)]
    private ?int $valuation;

    #[Column(type: "decimal")]
    private string $deduction;

    #[Column(type: "string", nullable: true)]
    private ?string $upload;

    #[Column(name: "roll_no", type: "smallint", nullable: true)]
    private ?int $rollNo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $qty;

    #[Column(type: "string", nullable: true)]
    private ?string $payment;

    #[Column(type: "string", nullable: true)]
    private ?string $remark;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "tmp_id", type: "integer", nullable: true)]
    private ?int $tmpId;

    #[Column(type: "string", unique: true)]
    private string $uid;

    #[Column(name: "buyer_id", type: "integer", nullable: true)]
    private ?int $buyerId;

    #[Column(name: "design_id", type: "smallint", nullable: true)]
    private ?int $designId;

    #[Column(name: "size_cm", type: "string", nullable: true)]
    private ?string $sizeCm;

    #[Column(type: "decimal")]
    private string $sqm;

    #[Column(name: "jc_no", type: "integer", nullable: true)]
    private ?int $jcNo;

    #[Column(name: "loom_id", type: "string", nullable: true)]
    private ?string $loomId;

    public function __construct()
    {
        $this->location = ((isset($_COOKIE["Location"]))? $_COOKIE["Location"]:'');
        $this->employee1 = ((isset($_COOKIE["PA_LID1"]))? $_COOKIE["PA_LID1"]:'');
        $this->process = ((isset($_GET["prid"]))? $_GET["prid"]:((isset($_COOKIE["prid"]))? $_COOKIE["prid"]:''));
        $this->confirmProcess = ((isset($_GET["prid"]))? $_GET["prid"]:((isset($_COOKIE["prid"]))? $_COOKIE["prid"]:''));
        $this->processOther = ((isset($_COOKIE["poa"]))? $_COOKIE["poa"]:'');
        $this->valuation = 0;
        $this->deduction = "0.00";
        $this->rollNo = ((isset($_COOKIE["rn"]))? $_COOKIE["rn"]:0);
        $this->qty = ((isset($_COOKIE["nop"]))? $_COOKIE["nop"]:0);
        $this->operator = 0;
        $this->sqm = "0.000";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLocation(): int
    {
        return $this->location;
    }

    public function setLocation(int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getEmployee1(): ?int
    {
        return $this->employee1;
    }

    public function setEmployee1(?int $value): static
    {
        $this->employee1 = $value;
        return $this;
    }

    public function getEmployee2(): ?int
    {
        return $this->employee2;
    }

    public function setEmployee2(?int $value): static
    {
        $this->employee2 = $value;
        return $this;
    }

    public function getEmployee3(): ?int
    {
        return $this->employee3;
    }

    public function setEmployee3(?int $value): static
    {
        $this->employee3 = $value;
        return $this;
    }

    public function getEmployeeId(): ?string
    {
        return HtmlDecode($this->employeeId);
    }

    public function setEmployeeId(?string $value): static
    {
        $this->employeeId = RemoveXss($value);
        return $this;
    }

    public function getProcess(): int
    {
        return $this->process;
    }

    public function setProcess(int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getConfirmProcess(): int
    {
        return $this->confirmProcess;
    }

    public function setConfirmProcess(int $value): static
    {
        $this->confirmProcess = $value;
        return $this;
    }

    public function getProcessOther(): ?string
    {
        return HtmlDecode($this->processOther);
    }

    public function setProcessOther(?string $value): static
    {
        $this->processOther = RemoveXss($value);
        return $this;
    }

    public function getCode(): int
    {
        return $this->code;
    }

    public function setCode(int $value): static
    {
        $this->code = $value;
        return $this;
    }

    public function getSizeActual(): ?string
    {
        return HtmlDecode($this->sizeActual);
    }

    public function setSizeActual(?string $value): static
    {
        $this->sizeActual = RemoveXss($value);
        return $this;
    }

    public function getWeightActual(): ?string
    {
        return $this->weightActual;
    }

    public function setWeightActual(?string $value): static
    {
        $this->weightActual = $value;
        return $this;
    }

    public function getValuation(): ?int
    {
        return $this->valuation;
    }

    public function setValuation(?int $value): static
    {
        $this->valuation = $value;
        return $this;
    }

    public function getDeduction(): string
    {
        return $this->deduction;
    }

    public function setDeduction(string $value): static
    {
        $this->deduction = $value;
        return $this;
    }

    public function getUpload(): ?string
    {
        return HtmlDecode($this->upload);
    }

    public function setUpload(?string $value): static
    {
        $this->upload = RemoveXss($value);
        return $this;
    }

    public function getRollNo(): ?int
    {
        return $this->rollNo;
    }

    public function setRollNo(?int $value): static
    {
        $this->rollNo = $value;
        return $this;
    }

    public function getQty(): ?int
    {
        return $this->qty;
    }

    public function setQty(?int $value): static
    {
        $this->qty = $value;
        return $this;
    }

    public function getPayment(): ?string
    {
        return HtmlDecode($this->payment);
    }

    public function setPayment(?string $value): static
    {
        $this->payment = RemoveXss($value);
        return $this;
    }

    public function getRemark(): ?string
    {
        return HtmlDecode($this->remark);
    }

    public function setRemark(?string $value): static
    {
        $this->remark = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getTmpId(): ?int
    {
        return $this->tmpId;
    }

    public function setTmpId(?int $value): static
    {
        $this->tmpId = $value;
        return $this;
    }

    public function getUid(): string
    {
        return HtmlDecode($this->uid);
    }

    public function setUid(string $value): static
    {
        $this->uid = RemoveXss($value);
        return $this;
    }

    public function getBuyerId(): ?int
    {
        return $this->buyerId;
    }

    public function setBuyerId(?int $value): static
    {
        $this->buyerId = $value;
        return $this;
    }

    public function getDesignId(): ?int
    {
        return $this->designId;
    }

    public function setDesignId(?int $value): static
    {
        $this->designId = $value;
        return $this;
    }

    public function getSizeCm(): ?string
    {
        return HtmlDecode($this->sizeCm);
    }

    public function setSizeCm(?string $value): static
    {
        $this->sizeCm = RemoveXss($value);
        return $this;
    }

    public function getSqm(): string
    {
        return $this->sqm;
    }

    public function setSqm(string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getJcNo(): ?int
    {
        return $this->jcNo;
    }

    public function setJcNo(?int $value): static
    {
        $this->jcNo = $value;
        return $this;
    }

    public function getLoomId(): ?string
    {
        return HtmlDecode($this->loomId);
    }

    public function setLoomId(?string $value): static
    {
        $this->loomId = RemoveXss($value);
        return $this;
    }
}
