<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "process_action_payment_pe" table
 */
#[Entity]
#[Table(name: "process_action_payment_pe")]
class ProcessActionPaymentPe extends AbstractEntity
{
    #[Column(type: "smallint", nullable: true)]
    private ?int $location;

    #[Column(type: "decimal", nullable: true)]
    private ?string $process;

    #[Column(name: "emp_id", type: "decimal", nullable: true)]
    private ?string $empId;

    #[Column(type: "string", nullable: true)]
    private ?string $contractor;

    #[Column(type: "decimal", nullable: true)]
    private ?string $qty;

    #[Column(type: "float")]
    private float $sqm;

    #[Column(type: "float", nullable: true)]
    private ?float $amount;

    #[Column(type: "string", nullable: true)]
    private ?string $payment;

    #[Column(type: "string")]
    private string $remarks;

    public function getLocation(): ?int
    {
        return $this->location;
    }

    public function setLocation(?int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getProcess(): ?string
    {
        return $this->process;
    }

    public function setProcess(?string $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getEmpId(): ?string
    {
        return $this->empId;
    }

    public function setEmpId(?string $value): static
    {
        $this->empId = $value;
        return $this;
    }

    public function getContractor(): ?string
    {
        return HtmlDecode($this->contractor);
    }

    public function setContractor(?string $value): static
    {
        $this->contractor = RemoveXss($value);
        return $this;
    }

    public function getQty(): ?string
    {
        return $this->qty;
    }

    public function setQty(?string $value): static
    {
        $this->qty = $value;
        return $this;
    }

    public function getSqm(): float
    {
        return $this->sqm;
    }

    public function setSqm(float $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getAmount(): ?float
    {
        return $this->amount;
    }

    public function setAmount(?float $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getPayment(): ?string
    {
        return HtmlDecode($this->payment);
    }

    public function setPayment(?string $value): static
    {
        $this->payment = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }
}
