<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "process_action_payment_emp_ref_grp" table
 */
#[Entity]
#[Table(name: "process_action_payment_emp_ref_grp")]
class ProcessActionPaymentEmpRefGrp extends AbstractEntity
{
    #[Column(type: "smallint", nullable: true)]
    private ?int $process;

    #[Column(name: "emp_id", type: "smallint", nullable: true)]
    private ?int $empId;

    #[Column(name: "emp_grp", type: "string")]
    private string $empGrp;

    #[Column(type: "string")]
    private string $ref;

    #[Column(name: "size_wl", type: "string", nullable: true)]
    private ?string $sizeWl;

    #[Column(type: "bigint")]
    private string $count;

    #[Column(name: "`@`", options: ["name" => "@"], type: "float")]
    private float $40;

    #[Column(type: "float", nullable: true)]
    private ?float $amount;

    #[Column(type: "string", nullable: true)]
    private ?string $payment;

    public function __construct()
    {
        $this->count = "0";
        $this->40 = 0;
    }

    public function getProcess(): ?int
    {
        return $this->process;
    }

    public function setProcess(?int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getEmpId(): ?int
    {
        return $this->empId;
    }

    public function setEmpId(?int $value): static
    {
        $this->empId = $value;
        return $this;
    }

    public function getEmpGrp(): string
    {
        return HtmlDecode($this->empGrp);
    }

    public function setEmpGrp(string $value): static
    {
        $this->empGrp = RemoveXss($value);
        return $this;
    }

    public function getRef(): string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }

    public function getSizeWl(): ?string
    {
        return HtmlDecode($this->sizeWl);
    }

    public function setSizeWl(?string $value): static
    {
        $this->sizeWl = RemoveXss($value);
        return $this;
    }

    public function getCount(): string
    {
        return $this->count;
    }

    public function setCount(string $value): static
    {
        $this->count = $value;
        return $this;
    }

    public function get40(): float
    {
        return $this->40;
    }

    public function set40(float $value): static
    {
        $this->40 = $value;
        return $this;
    }

    public function getAmount(): ?float
    {
        return $this->amount;
    }

    public function setAmount(?float $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getPayment(): ?string
    {
        return HtmlDecode($this->payment);
    }

    public function setPayment(?string $value): static
    {
        $this->payment = RemoveXss($value);
        return $this;
    }
}
