<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "process_action_payment_e" table
 */
#[Entity]
#[Table(name: "process_action_payment_e")]
class ProcessActionPaymentE extends AbstractEntity
{
    #[Column(type: "text", nullable: true)]
    private ?string $location;

    #[Column(name: "emp_id", type: "decimal", nullable: true)]
    private ?string $empId;

    #[Column(name: "employee_name", type: "string", nullable: true)]
    private ?string $employeeName;

    #[Column(type: "string", nullable: true)]
    private ?string $contractor;

    #[Column(type: "float", nullable: true)]
    private ?float $amount;

    #[Column(type: "string", nullable: true)]
    private ?string $payment;

    #[Column(name: "bank_name", type: "string", nullable: true)]
    private ?string $bankName;

    #[Column(name: "bank_ifsc_code", type: "string", nullable: true)]
    private ?string $bankIfscCode;

    #[Column(name: "bank_account_no", type: "string", nullable: true)]
    private ?string $bankAccountNo;

    public function getLocation(): ?string
    {
        return HtmlDecode($this->location);
    }

    public function setLocation(?string $value): static
    {
        $this->location = RemoveXss($value);
        return $this;
    }

    public function getEmpId(): ?string
    {
        return $this->empId;
    }

    public function setEmpId(?string $value): static
    {
        $this->empId = $value;
        return $this;
    }

    public function getEmployeeName(): ?string
    {
        return HtmlDecode($this->employeeName);
    }

    public function setEmployeeName(?string $value): static
    {
        $this->employeeName = RemoveXss($value);
        return $this;
    }

    public function getContractor(): ?string
    {
        return HtmlDecode($this->contractor);
    }

    public function setContractor(?string $value): static
    {
        $this->contractor = RemoveXss($value);
        return $this;
    }

    public function getAmount(): ?float
    {
        return $this->amount;
    }

    public function setAmount(?float $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getPayment(): ?string
    {
        return HtmlDecode($this->payment);
    }

    public function setPayment(?string $value): static
    {
        $this->payment = RemoveXss($value);
        return $this;
    }

    public function getBankName(): ?string
    {
        return HtmlDecode($this->bankName);
    }

    public function setBankName(?string $value): static
    {
        $this->bankName = RemoveXss($value);
        return $this;
    }

    public function getBankIfscCode(): ?string
    {
        return HtmlDecode($this->bankIfscCode);
    }

    public function setBankIfscCode(?string $value): static
    {
        $this->bankIfscCode = RemoveXss($value);
        return $this;
    }

    public function getBankAccountNo(): ?string
    {
        return HtmlDecode($this->bankAccountNo);
    }

    public function setBankAccountNo(?string $value): static
    {
        $this->bankAccountNo = RemoveXss($value);
        return $this;
    }
}
