<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "process_action_payment" table
 */
#[Entity]
#[Table(name: "process_action_payment")]
class ProcessActionPayment extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $location;

    #[Column(type: "smallint", nullable: true)]
    private ?int $process;

    #[Column(name: "emp_id", type: "smallint", nullable: true)]
    private ?int $empId;

    #[Column(name: "emp_grp", type: "string")]
    private string $empGrp;

    #[Column(type: "bigint")]
    private string $code;

    #[Column(type: "string")]
    private string $ref;

    #[Column(name: "size_wl", type: "string", nullable: true)]
    private ?string $sizeWl;

    #[Column(name: "`process_@`", options: ["name" => "process_@"], type: "float", nullable: true)]
    private ?float $process;

    #[Column(name: "final_amount", type: "float")]
    private float $finalAmount;

    #[Column(type: "float")]
    private float $amount;

    #[Column(name: "c_charge", type: "float")]
    private float $cCharge;

    #[Column(name: "c_id", type: "smallint")]
    private int $cId;

    #[Column(name: "custom_size", type: "float")]
    private float $customSize;

    #[Column(name: "ded_jc", type: "decimal", nullable: true)]
    private ?string $dedJc;

    #[Column(name: "ded_pa", type: "decimal", nullable: true)]
    private ?string $dedPa;

    #[Column(name: "payment_type", type: "integer")]
    private int $paymentType;

    #[Column(type: "float", nullable: true)]
    private ?float $sqm;

    #[Column(name: "sqm_grp", type: "float", nullable: true)]
    private ?float $sqmGrp;

    #[Column(name: "`2_srm`", options: ["name" => "2_srm"], type: "float", nullable: true)]
    private ?float $2Srm;

    #[Column(name: "`4_srm`", options: ["name" => "4_srm"], type: "float", nullable: true)]
    private ?float $4Srm;

    #[Column(name: "process_fix", type: "smallint", nullable: true)]
    private ?int $processFix;

    #[Column(type: "smallint", nullable: true)]
    private ?int $method;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "string", nullable: true)]
    private ?string $payment;

    #[Column(type: "integer")]
    private int $grp;

    #[Column(type: "string")]
    private string $remark;

    #[Column(type: "smallint")]
    private int $pps;

    #[Column(type: "smallint", nullable: true)]
    private ?int $category;

    #[Column(name: "c_method", type: "smallint", nullable: true)]
    private ?int $cMethod;

    #[Column(type: "string", unique: true, nullable: true)]
    private ?string $uid;

    public function __construct()
    {
        $this->finalAmount = 0;
        $this->cCharge = 0;
        $this->cId = 0;
        $this->customSize = 0;
        $this->pps = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLocation(): ?int
    {
        return $this->location;
    }

    public function setLocation(?int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getProcess(): ?int
    {
        return $this->process;
    }

    public function setProcess(?int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getEmpId(): ?int
    {
        return $this->empId;
    }

    public function setEmpId(?int $value): static
    {
        $this->empId = $value;
        return $this;
    }

    public function getEmpGrp(): string
    {
        return HtmlDecode($this->empGrp);
    }

    public function setEmpGrp(string $value): static
    {
        $this->empGrp = RemoveXss($value);
        return $this;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $value): static
    {
        $this->code = $value;
        return $this;
    }

    public function getRef(): string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }

    public function getSizeWl(): ?string
    {
        return HtmlDecode($this->sizeWl);
    }

    public function setSizeWl(?string $value): static
    {
        $this->sizeWl = RemoveXss($value);
        return $this;
    }

    public function getProcess(): ?float
    {
        return $this->process;
    }

    public function setProcess(?float $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getFinalAmount(): float
    {
        return $this->finalAmount;
    }

    public function setFinalAmount(float $value): static
    {
        $this->finalAmount = $value;
        return $this;
    }

    public function getAmount(): float
    {
        return $this->amount;
    }

    public function setAmount(float $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getCCharge(): float
    {
        return $this->cCharge;
    }

    public function setCCharge(float $value): static
    {
        $this->cCharge = $value;
        return $this;
    }

    public function getCId(): int
    {
        return $this->cId;
    }

    public function setCId(int $value): static
    {
        $this->cId = $value;
        return $this;
    }

    public function getCustomSize(): float
    {
        return $this->customSize;
    }

    public function setCustomSize(float $value): static
    {
        $this->customSize = $value;
        return $this;
    }

    public function getDedJc(): ?string
    {
        return $this->dedJc;
    }

    public function setDedJc(?string $value): static
    {
        $this->dedJc = $value;
        return $this;
    }

    public function getDedPa(): ?string
    {
        return $this->dedPa;
    }

    public function setDedPa(?string $value): static
    {
        $this->dedPa = $value;
        return $this;
    }

    public function getPaymentType(): int
    {
        return $this->paymentType;
    }

    public function setPaymentType(int $value): static
    {
        $this->paymentType = $value;
        return $this;
    }

    public function getSqm(): ?float
    {
        return $this->sqm;
    }

    public function setSqm(?float $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getSqmGrp(): ?float
    {
        return $this->sqmGrp;
    }

    public function setSqmGrp(?float $value): static
    {
        $this->sqmGrp = $value;
        return $this;
    }

    public function get2Srm(): ?float
    {
        return $this->2Srm;
    }

    public function set2Srm(?float $value): static
    {
        $this->2Srm = $value;
        return $this;
    }

    public function get4Srm(): ?float
    {
        return $this->4Srm;
    }

    public function set4Srm(?float $value): static
    {
        $this->4Srm = $value;
        return $this;
    }

    public function getProcessFix(): ?int
    {
        return $this->processFix;
    }

    public function setProcessFix(?int $value): static
    {
        $this->processFix = $value;
        return $this;
    }

    public function getMethod(): ?int
    {
        return $this->method;
    }

    public function setMethod(?int $value): static
    {
        $this->method = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getPayment(): ?string
    {
        return HtmlDecode($this->payment);
    }

    public function setPayment(?string $value): static
    {
        $this->payment = RemoveXss($value);
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getRemark(): string
    {
        return HtmlDecode($this->remark);
    }

    public function setRemark(string $value): static
    {
        $this->remark = RemoveXss($value);
        return $this;
    }

    public function getPps(): int
    {
        return $this->pps;
    }

    public function setPps(int $value): static
    {
        $this->pps = $value;
        return $this;
    }

    public function getCategory(): ?int
    {
        return $this->category;
    }

    public function setCategory(?int $value): static
    {
        $this->category = $value;
        return $this;
    }

    public function getCMethod(): ?int
    {
        return $this->cMethod;
    }

    public function setCMethod(?int $value): static
    {
        $this->cMethod = $value;
        return $this;
    }

    public function getUid(): ?string
    {
        return HtmlDecode($this->uid);
    }

    public function setUid(?string $value): static
    {
        $this->uid = RemoveXss($value);
        return $this;
    }
}
