<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "process_action_material_payment" table
 */
#[Entity]
#[Table(name: "process_action_material_payment")]
class ProcessActionMaterialPayment extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $location;

    #[Column(type: "smallint")]
    private int $process;

    #[Column(name: "emp_id", type: "smallint", nullable: true)]
    private ?int $empId;

    #[Column(type: "smallint", nullable: true)]
    private ?int $rid;

    #[Column(type: "decimal", nullable: true)]
    private ?string $quantity;

    #[Column(name: "process_from", type: "smallint")]
    private int $processFrom;

    #[Column(name: "process_to", type: "smallint")]
    private int $processTo;

    #[Column(name: "process_method", type: "integer", nullable: true)]
    private ?int $processMethod;

    #[Column(type: "smallint")]
    private int $ply;

    #[Column(name: "rid_new", type: "smallint")]
    private int $ridNew;

    #[Column(name: "`process_@`", options: ["name" => "process_@"], type: "decimal", nullable: true)]
    private ?string $process;

    #[Column(type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(type: "decimal")]
    private string $incentive;

    #[Column(name: "final_amount", type: "decimal", nullable: true)]
    private ?string $finalAmount;

    #[Column(type: "string", nullable: true)]
    private ?string $description;

    #[Column(type: "string")]
    private string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $payment;

    #[Column(name: "pp_id", type: "smallint", nullable: true)]
    private ?int $ppId;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->process = ((isset($_COOKIE["prid"]))? $_COOKIE["prid"]:'');
        $this->incentive = "0";
        $this->finalAmount = "0";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLocation(): int
    {
        return $this->location;
    }

    public function setLocation(int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getProcess(): int
    {
        return $this->process;
    }

    public function setProcess(int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getEmpId(): ?int
    {
        return $this->empId;
    }

    public function setEmpId(?int $value): static
    {
        $this->empId = $value;
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    public function setQuantity(?string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getProcessFrom(): int
    {
        return $this->processFrom;
    }

    public function setProcessFrom(int $value): static
    {
        $this->processFrom = $value;
        return $this;
    }

    public function getProcessTo(): int
    {
        return $this->processTo;
    }

    public function setProcessTo(int $value): static
    {
        $this->processTo = $value;
        return $this;
    }

    public function getProcessMethod(): ?int
    {
        return $this->processMethod;
    }

    public function setProcessMethod(?int $value): static
    {
        $this->processMethod = $value;
        return $this;
    }

    public function getPly(): int
    {
        return $this->ply;
    }

    public function setPly(int $value): static
    {
        $this->ply = $value;
        return $this;
    }

    public function getRidNew(): int
    {
        return $this->ridNew;
    }

    public function setRidNew(int $value): static
    {
        $this->ridNew = $value;
        return $this;
    }

    public function getProcess(): ?string
    {
        return $this->process;
    }

    public function setProcess(?string $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getIncentive(): string
    {
        return $this->incentive;
    }

    public function setIncentive(string $value): static
    {
        $this->incentive = $value;
        return $this;
    }

    public function getFinalAmount(): ?string
    {
        return $this->finalAmount;
    }

    public function setFinalAmount(?string $value): static
    {
        $this->finalAmount = $value;
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getPayment(): ?int
    {
        return $this->payment;
    }

    public function setPayment(?int $value): static
    {
        $this->payment = $value;
        return $this;
    }

    public function getPpId(): ?int
    {
        return $this->ppId;
    }

    public function setPpId(?int $value): static
    {
        $this->ppId = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
