<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "process_action_material_old" table
 */
#[Entity]
#[Table(name: "process_action_material_old")]
class ProcessActionMaterialOld extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $site;

    #[Column(type: "smallint")]
    private int $process;

    #[Column(type: "string", nullable: true)]
    private ?string $poid;

    #[Column(name: "jc_no", type: "integer")]
    private int $jcNo;

    #[Column(name: "emp_name", type: "string")]
    private string $empName;

    #[Column(type: "integer", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(type: "smallint")]
    private int $rid;

    #[Column(name: "rid_2", type: "string", nullable: true)]
    private ?string $rid2;

    #[Column(type: "decimal")]
    private string $quantity;

    #[Column(type: "decimal", nullable: true)]
    private ?string $packets;

    #[Column(name: "lot_no", type: "string")]
    private string $lotNo;

    #[Column(type: "smallint")]
    private int $packing;

    #[Column(type: "smallint")]
    private int $godown;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(name: "sub_process", type: "smallint")]
    private int $subProcess;

    #[Column(name: "process_method", type: "smallint")]
    private int $processMethod;

    #[Column(type: "smallint", nullable: true)]
    private ?int $ply;

    #[Column(name: "rid_new", type: "smallint", nullable: true)]
    private ?int $ridNew;

    #[Column(type: "string", nullable: true)]
    private ?string $remark;

    #[Column(type: "string", nullable: true)]
    private ?string $payment;

    #[Column(type: "date")]
    private DateTime $dated;

    #[Column(type: "smallint")]
    private int $opeartor;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "rid_new_lot_no", type: "string", nullable: true)]
    private ?string $ridNewLotNo;

    public function __construct()
    {
        $this->site = ((isset($_COOKIE["Location"]))? $_COOKIE["Location"]:'');
        $this->process = ((isset($_COOKIE["PROC"]))? $_COOKIE["PROC"]:'');
        $this->poid = "0";
        $this->grp = (isset($_GET['GRP'])) ? $_GET['GRP'] :((isset($_COOKIE['GRP'])) ? $_COOKIE['GRP'] : 2);
        $this->sGrp = (isset($_GET['SGRP']))  ? $_GET['SGRP'] : ((isset($_COOKIE['SGRP']))  ? $_COOKIE['SGRP'] : '');
        $this->product = (isset($_GET['PR']))  ? $_GET['PR'] : ((isset($_COOKIE['PR']))  ? $_COOKIE['PR'] : '');
        $this->packing = (isset($_GET['PK']))  ? $_GET['PK'] : ((isset($_COOKIE['PK']))  ? $_COOKIE['PK'] : '');
        $this->subProcess = pamot();
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getSite(): int
    {
        return $this->site;
    }

    public function setSite(int $value): static
    {
        $this->site = $value;
        return $this;
    }

    public function getProcess(): int
    {
        return $this->process;
    }

    public function setProcess(int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getPoid(): ?string
    {
        return HtmlDecode($this->poid);
    }

    public function setPoid(?string $value): static
    {
        $this->poid = RemoveXss($value);
        return $this;
    }

    public function getJcNo(): int
    {
        return $this->jcNo;
    }

    public function setJcNo(int $value): static
    {
        $this->jcNo = $value;
        return $this;
    }

    public function getEmpName(): string
    {
        return HtmlDecode($this->empName);
    }

    public function setEmpName(string $value): static
    {
        $this->empName = RemoveXss($value);
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getRid2(): ?string
    {
        return HtmlDecode($this->rid2);
    }

    public function setRid2(?string $value): static
    {
        $this->rid2 = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): string
    {
        return $this->quantity;
    }

    public function setQuantity(string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getPackets(): ?string
    {
        return $this->packets;
    }

    public function setPackets(?string $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getLotNo(): string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getPacking(): int
    {
        return $this->packing;
    }

    public function setPacking(int $value): static
    {
        $this->packing = $value;
        return $this;
    }

    public function getGodown(): int
    {
        return $this->godown;
    }

    public function setGodown(int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getSubProcess(): int
    {
        return $this->subProcess;
    }

    public function setSubProcess(int $value): static
    {
        $this->subProcess = $value;
        return $this;
    }

    public function getProcessMethod(): int
    {
        return $this->processMethod;
    }

    public function setProcessMethod(int $value): static
    {
        $this->processMethod = $value;
        return $this;
    }

    public function getPly(): ?int
    {
        return $this->ply;
    }

    public function setPly(?int $value): static
    {
        $this->ply = $value;
        return $this;
    }

    public function getRidNew(): ?int
    {
        return $this->ridNew;
    }

    public function setRidNew(?int $value): static
    {
        $this->ridNew = $value;
        return $this;
    }

    public function getRemark(): ?string
    {
        return HtmlDecode($this->remark);
    }

    public function setRemark(?string $value): static
    {
        $this->remark = RemoveXss($value);
        return $this;
    }

    public function getPayment(): ?string
    {
        return HtmlDecode($this->payment);
    }

    public function setPayment(?string $value): static
    {
        $this->payment = RemoveXss($value);
        return $this;
    }

    public function getDated(): DateTime
    {
        return $this->dated;
    }

    public function setDated(DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getOpeartor(): int
    {
        return $this->opeartor;
    }

    public function setOpeartor(int $value): static
    {
        $this->opeartor = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getRidNewLotNo(): ?string
    {
        return HtmlDecode($this->ridNewLotNo);
    }

    public function setRidNewLotNo(?string $value): static
    {
        $this->ridNewLotNo = RemoveXss($value);
        return $this;
    }
}
