<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "process_action" table
 */
#[Entity]
#[Table(name: "process_action")]
class ProcessAction extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $process;

    #[Column(name: "confirm_process", type: "smallint")]
    private int $confirmProcess;

    #[Column(name: "process_other", type: "string", nullable: true)]
    private ?string $processOther;

    #[Column(type: "smallint")]
    private int $location;

    #[Column(type: "smallint", nullable: true)]
    private ?int $godown;

    #[Column(type: "string")]
    private string $code;

    #[Column(name: "code_last", type: "string")]
    private string $codeLast;

    #[Column(name: "employee_1", type: "smallint", nullable: true)]
    private ?int $employee1;

    #[Column(name: "employee_2", type: "smallint", nullable: true)]
    private ?int $employee2;

    #[Column(name: "employee_3", type: "smallint", nullable: true)]
    private ?int $employee3;

    #[Column(name: "employee_id", type: "string", nullable: true)]
    private ?string $employeeId;

    #[Column(type: "smallint", nullable: true)]
    private ?int $qty;

    #[Column(name: "roll_no", type: "smallint", nullable: true)]
    private ?int $rollNo;

    #[Column(name: "size_w", type: "smallint", nullable: true)]
    private ?int $sizeW;

    #[Column(name: "size_l", type: "smallint", nullable: true)]
    private ?int $sizeL;

    #[Column(name: "size_h", type: "smallint", nullable: true)]
    private ?int $sizeH;

    #[Column(name: "size_actual", type: "string", nullable: true)]
    private ?string $sizeActual;

    #[Column(name: "weight_actual", type: "decimal", nullable: true)]
    private ?string $weightActual;

    #[Column(name: "lines_in_30cm", type: "string", nullable: true)]
    private ?string $linesIn30cm;

    #[Column(name: "d_01", type: "string", nullable: true)]
    private ?string $d01;

    #[Column(name: "d_02", type: "string", nullable: true)]
    private ?string $d02;

    #[Column(name: "d_03", type: "string", nullable: true)]
    private ?string $d03;

    #[Column(name: "d_04", type: "string", nullable: true)]
    private ?string $d04;

    #[Column(name: "d_05", type: "string", nullable: true)]
    private ?string $d05;

    #[Column(name: "d_06", type: "string", nullable: true)]
    private ?string $d06;

    #[Column(name: "d_07", type: "string", nullable: true)]
    private ?string $d07;

    #[Column(name: "d_08", type: "string", nullable: true)]
    private ?string $d08;

    #[Column(name: "d_09", type: "string", nullable: true)]
    private ?string $d09;

    #[Column(name: "d_10", type: "string", nullable: true)]
    private ?string $d10;

    #[Column(type: "smallint", nullable: true)]
    private ?int $valuation;

    #[Column(type: "decimal")]
    private string $deduction;

    #[Column(type: "string", nullable: true)]
    private ?string $remark;

    #[Column(type: "string", nullable: true)]
    private ?string $upload;

    #[Column(type: "string")]
    private string $uid;

    #[Column(type: "smallint", nullable: true)]
    private ?int $payment;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->process = ((isset($_GET["prid"]))? $_GET["prid"]:((isset($_COOKIE["prid"]))? $_COOKIE["prid"]:''));
        $this->confirmProcess = ((isset($_GET["prid"]))? $_GET["prid"]:((isset($_COOKIE["prid"]))? $_COOKIE["prid"]:''));
        $this->processOther = ((isset($_COOKIE["poa"]))? $_COOKIE["poa"]:'');
        $this->location = ((isset($_COOKIE["Location"]))? $_COOKIE["Location"]:'');
        $this->employee1 = ((isset($_COOKIE["PA_LID1"]))? $_COOKIE["PA_LID1"]:'10000');
        $this->employee2 = 10000;
        $this->employee3 = 10000;
        $this->qty = ((isset($_COOKIE["nop"]))? $_COOKIE["nop"]:0);
        $this->rollNo = ((isset($_COOKIE["rn"]))? $_COOKIE["rn"]:0);
        $this->valuation = 0;
        $this->deduction = "0.00";
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getProcess(): int
    {
        return $this->process;
    }

    public function setProcess(int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getConfirmProcess(): int
    {
        return $this->confirmProcess;
    }

    public function setConfirmProcess(int $value): static
    {
        $this->confirmProcess = $value;
        return $this;
    }

    public function getProcessOther(): ?string
    {
        return HtmlDecode($this->processOther);
    }

    public function setProcessOther(?string $value): static
    {
        $this->processOther = RemoveXss($value);
        return $this;
    }

    public function getLocation(): int
    {
        return $this->location;
    }

    public function setLocation(int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getGodown(): ?int
    {
        return $this->godown;
    }

    public function setGodown(?int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getCode(): string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getCodeLast(): string
    {
        return HtmlDecode($this->codeLast);
    }

    public function setCodeLast(string $value): static
    {
        $this->codeLast = RemoveXss($value);
        return $this;
    }

    public function getEmployee1(): ?int
    {
        return $this->employee1;
    }

    public function setEmployee1(?int $value): static
    {
        $this->employee1 = $value;
        return $this;
    }

    public function getEmployee2(): ?int
    {
        return $this->employee2;
    }

    public function setEmployee2(?int $value): static
    {
        $this->employee2 = $value;
        return $this;
    }

    public function getEmployee3(): ?int
    {
        return $this->employee3;
    }

    public function setEmployee3(?int $value): static
    {
        $this->employee3 = $value;
        return $this;
    }

    public function getEmployeeId(): ?string
    {
        return HtmlDecode($this->employeeId);
    }

    public function setEmployeeId(?string $value): static
    {
        $this->employeeId = RemoveXss($value);
        return $this;
    }

    public function getQty(): ?int
    {
        return $this->qty;
    }

    public function setQty(?int $value): static
    {
        $this->qty = $value;
        return $this;
    }

    public function getRollNo(): ?int
    {
        return $this->rollNo;
    }

    public function setRollNo(?int $value): static
    {
        $this->rollNo = $value;
        return $this;
    }

    public function getSizeW(): ?int
    {
        return $this->sizeW;
    }

    public function setSizeW(?int $value): static
    {
        $this->sizeW = $value;
        return $this;
    }

    public function getSizeL(): ?int
    {
        return $this->sizeL;
    }

    public function setSizeL(?int $value): static
    {
        $this->sizeL = $value;
        return $this;
    }

    public function getSizeH(): ?int
    {
        return $this->sizeH;
    }

    public function setSizeH(?int $value): static
    {
        $this->sizeH = $value;
        return $this;
    }

    public function getSizeActual(): ?string
    {
        return HtmlDecode($this->sizeActual);
    }

    public function setSizeActual(?string $value): static
    {
        $this->sizeActual = RemoveXss($value);
        return $this;
    }

    public function getWeightActual(): ?string
    {
        return $this->weightActual;
    }

    public function setWeightActual(?string $value): static
    {
        $this->weightActual = $value;
        return $this;
    }

    public function getLinesIn30cm(): ?string
    {
        return HtmlDecode($this->linesIn30cm);
    }

    public function setLinesIn30cm(?string $value): static
    {
        $this->linesIn30cm = RemoveXss($value);
        return $this;
    }

    public function getD01(): ?string
    {
        return HtmlDecode($this->d01);
    }

    public function setD01(?string $value): static
    {
        $this->d01 = RemoveXss($value);
        return $this;
    }

    public function getD02(): ?string
    {
        return HtmlDecode($this->d02);
    }

    public function setD02(?string $value): static
    {
        $this->d02 = RemoveXss($value);
        return $this;
    }

    public function getD03(): ?string
    {
        return HtmlDecode($this->d03);
    }

    public function setD03(?string $value): static
    {
        $this->d03 = RemoveXss($value);
        return $this;
    }

    public function getD04(): ?string
    {
        return HtmlDecode($this->d04);
    }

    public function setD04(?string $value): static
    {
        $this->d04 = RemoveXss($value);
        return $this;
    }

    public function getD05(): ?string
    {
        return HtmlDecode($this->d05);
    }

    public function setD05(?string $value): static
    {
        $this->d05 = RemoveXss($value);
        return $this;
    }

    public function getD06(): ?string
    {
        return HtmlDecode($this->d06);
    }

    public function setD06(?string $value): static
    {
        $this->d06 = RemoveXss($value);
        return $this;
    }

    public function getD07(): ?string
    {
        return HtmlDecode($this->d07);
    }

    public function setD07(?string $value): static
    {
        $this->d07 = RemoveXss($value);
        return $this;
    }

    public function getD08(): ?string
    {
        return HtmlDecode($this->d08);
    }

    public function setD08(?string $value): static
    {
        $this->d08 = RemoveXss($value);
        return $this;
    }

    public function getD09(): ?string
    {
        return HtmlDecode($this->d09);
    }

    public function setD09(?string $value): static
    {
        $this->d09 = RemoveXss($value);
        return $this;
    }

    public function getD10(): ?string
    {
        return HtmlDecode($this->d10);
    }

    public function setD10(?string $value): static
    {
        $this->d10 = RemoveXss($value);
        return $this;
    }

    public function getValuation(): ?int
    {
        return $this->valuation;
    }

    public function setValuation(?int $value): static
    {
        $this->valuation = $value;
        return $this;
    }

    public function getDeduction(): string
    {
        return $this->deduction;
    }

    public function setDeduction(string $value): static
    {
        $this->deduction = $value;
        return $this;
    }

    public function getRemark(): ?string
    {
        return HtmlDecode($this->remark);
    }

    public function setRemark(?string $value): static
    {
        $this->remark = RemoveXss($value);
        return $this;
    }

    public function getUpload(): ?string
    {
        return HtmlDecode($this->upload);
    }

    public function setUpload(?string $value): static
    {
        $this->upload = RemoveXss($value);
        return $this;
    }

    public function getUid(): string
    {
        return HtmlDecode($this->uid);
    }

    public function setUid(string $value): static
    {
        $this->uid = RemoveXss($value);
        return $this;
    }

    public function getPayment(): ?int
    {
        return $this->payment;
    }

    public function setPayment(?int $value): static
    {
        $this->payment = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
