<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "pp_verify_compiled" table
 */
#[Entity]
#[Table(name: "pp_verify_compiled")]
class PpVerifyCompiled extends AbstractEntity
{
    #[Column(type: "integer")]
    private int $id;

    #[Column(type: "text", nullable: true)]
    private ?string $pid;

    #[Column(type: "text", nullable: true)]
    private ?string $location;

    #[Column(name: "product_type", type: "text", nullable: true)]
    private ?string $productType;

    #[Column(type: "text", nullable: true)]
    private ?string $shape;

    #[Column(name: "plan_type", type: "text", nullable: true)]
    private ?string $planType;

    #[Column(type: "string", nullable: true)]
    private ?string $gcode;

    #[Column(name: "design_id", type: "text", nullable: true)]
    private ?string $designId;

    #[Column(type: "text", nullable: true)]
    private ?string $process;

    #[Column(name: "yes_no", type: "text", nullable: true)]
    private ?string $yesNo;

    #[Column(type: "text", nullable: true)]
    private ?string $fix;

    #[Column(type: "text", nullable: true)]
    private ?string $unit;

    #[Column(name: "`@unit`", options: ["name" => "@unit"], type: "text", nullable: true)]
    private ?string $unit;

    #[Column(name: "`@`", options: ["name" => "@"], type: "text", nullable: true)]
    private ?string $40;

    #[Column(name: "extra_plan", type: "text", nullable: true)]
    private ?string $extraPlan;

    #[Column(name: "custom_size", type: "text", nullable: true)]
    private ?string $customSize;

    #[Column(name: "custom_size_below_st", type: "text", nullable: true)]
    private ?string $customSizeBelowSt;

    #[Column(type: "text", nullable: true)]
    private ?string $method;

    #[Column(type: "text", nullable: true)]
    private ?string $category;

    public function __construct()
    {
        $this->planType = "1";
        $this->fix = "1";
        $this->unit = "5";
        $this->unit = "0";
        $this->40 = "0";
        $this->customSize = "0";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPid(): ?string
    {
        return HtmlDecode($this->pid);
    }

    public function setPid(?string $value): static
    {
        $this->pid = RemoveXss($value);
        return $this;
    }

    public function getLocation(): ?string
    {
        return HtmlDecode($this->location);
    }

    public function setLocation(?string $value): static
    {
        $this->location = RemoveXss($value);
        return $this;
    }

    public function getProductType(): ?string
    {
        return HtmlDecode($this->productType);
    }

    public function setProductType(?string $value): static
    {
        $this->productType = RemoveXss($value);
        return $this;
    }

    public function getShape(): ?string
    {
        return HtmlDecode($this->shape);
    }

    public function setShape(?string $value): static
    {
        $this->shape = RemoveXss($value);
        return $this;
    }

    public function getPlanType(): ?string
    {
        return HtmlDecode($this->planType);
    }

    public function setPlanType(?string $value): static
    {
        $this->planType = RemoveXss($value);
        return $this;
    }

    public function getGcode(): ?string
    {
        return HtmlDecode($this->gcode);
    }

    public function setGcode(?string $value): static
    {
        $this->gcode = RemoveXss($value);
        return $this;
    }

    public function getDesignId(): ?string
    {
        return HtmlDecode($this->designId);
    }

    public function setDesignId(?string $value): static
    {
        $this->designId = RemoveXss($value);
        return $this;
    }

    public function getProcess(): ?string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(?string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }

    public function getYesNo(): ?string
    {
        return HtmlDecode($this->yesNo);
    }

    public function setYesNo(?string $value): static
    {
        $this->yesNo = RemoveXss($value);
        return $this;
    }

    public function getFix(): ?string
    {
        return HtmlDecode($this->fix);
    }

    public function setFix(?string $value): static
    {
        $this->fix = RemoveXss($value);
        return $this;
    }

    public function getUnit(): ?string
    {
        return HtmlDecode($this->unit);
    }

    public function setUnit(?string $value): static
    {
        $this->unit = RemoveXss($value);
        return $this;
    }

    public function getUnit(): ?string
    {
        return HtmlDecode($this->unit);
    }

    public function setUnit(?string $value): static
    {
        $this->unit = RemoveXss($value);
        return $this;
    }

    public function get40(): ?string
    {
        return HtmlDecode($this->40);
    }

    public function set40(?string $value): static
    {
        $this->40 = RemoveXss($value);
        return $this;
    }

    public function getExtraPlan(): ?string
    {
        return HtmlDecode($this->extraPlan);
    }

    public function setExtraPlan(?string $value): static
    {
        $this->extraPlan = RemoveXss($value);
        return $this;
    }

    public function getCustomSize(): ?string
    {
        return HtmlDecode($this->customSize);
    }

    public function setCustomSize(?string $value): static
    {
        $this->customSize = RemoveXss($value);
        return $this;
    }

    public function getCustomSizeBelowSt(): ?string
    {
        return HtmlDecode($this->customSizeBelowSt);
    }

    public function setCustomSizeBelowSt(?string $value): static
    {
        $this->customSizeBelowSt = RemoveXss($value);
        return $this;
    }

    public function getMethod(): ?string
    {
        return HtmlDecode($this->method);
    }

    public function setMethod(?string $value): static
    {
        $this->method = RemoveXss($value);
        return $this;
    }

    public function getCategory(): ?string
    {
        return HtmlDecode($this->category);
    }

    public function setCategory(?string $value): static
    {
        $this->category = RemoveXss($value);
        return $this;
    }
}
