<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "pp_verify" table
 */
#[Entity]
#[Table(name: "pp_verify")]
class PpVerify extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer")]
    private int $pid;

    #[Column(type: "string")]
    private string $location;

    #[Column(name: "product_type", type: "string")]
    private string $productType;

    #[Column(type: "string")]
    private string $shape;

    #[Column(name: "plan_type", type: "smallint")]
    private int $planType;

    #[Column(name: "design_id", type: "string", nullable: true)]
    private ?string $designId;

    #[Column(type: "string", nullable: true)]
    private ?string $process;

    #[Column(name: "yes_no", type: "smallint")]
    private int $yesNo;

    #[Column(type: "smallint")]
    private int $fix;

    #[Column(type: "smallint", nullable: true)]
    private ?int $unit;

    #[Column(name: "`@unit`", options: ["name" => "@unit"], type: "float", nullable: true)]
    private ?float $unit;

    #[Column(name: "`@`", options: ["name" => "@"], type: "decimal")]
    private string $40;

    #[Column(name: "extra_plan", type: "smallint")]
    private int $extraPlan;

    #[Column(name: "custom_size", type: "decimal")]
    private string $customSize;

    #[Column(name: "custom_size_below_st", type: "decimal")]
    private string $customSizeBelowSt;

    #[Column(type: "integer")]
    private int $method;

    #[Column(type: "integer")]
    private int $category;

    public function __construct()
    {
        $this->planType = 1;
        $this->designId = (isset($_GET['RID']))  ? $_GET['RID'] : '';
        $this->fix = 1;
        $this->unit = 5;
        $this->unit = 0;
        $this->40 = "0";
        $this->customSize = "0";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPid(): int
    {
        return $this->pid;
    }

    public function setPid(int $value): static
    {
        $this->pid = $value;
        return $this;
    }

    public function getLocation(): string
    {
        return HtmlDecode($this->location);
    }

    public function setLocation(string $value): static
    {
        $this->location = RemoveXss($value);
        return $this;
    }

    public function getProductType(): string
    {
        return HtmlDecode($this->productType);
    }

    public function setProductType(string $value): static
    {
        $this->productType = RemoveXss($value);
        return $this;
    }

    public function getShape(): string
    {
        return HtmlDecode($this->shape);
    }

    public function setShape(string $value): static
    {
        $this->shape = RemoveXss($value);
        return $this;
    }

    public function getPlanType(): int
    {
        return $this->planType;
    }

    public function setPlanType(int $value): static
    {
        $this->planType = $value;
        return $this;
    }

    public function getDesignId(): ?string
    {
        return HtmlDecode($this->designId);
    }

    public function setDesignId(?string $value): static
    {
        $this->designId = RemoveXss($value);
        return $this;
    }

    public function getProcess(): ?string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(?string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }

    public function getYesNo(): int
    {
        return $this->yesNo;
    }

    public function setYesNo(int $value): static
    {
        $this->yesNo = $value;
        return $this;
    }

    public function getFix(): int
    {
        return $this->fix;
    }

    public function setFix(int $value): static
    {
        $this->fix = $value;
        return $this;
    }

    public function getUnit(): ?int
    {
        return $this->unit;
    }

    public function setUnit(?int $value): static
    {
        $this->unit = $value;
        return $this;
    }

    public function getUnit(): ?float
    {
        return $this->unit;
    }

    public function setUnit(?float $value): static
    {
        $this->unit = $value;
        return $this;
    }

    public function get40(): string
    {
        return $this->40;
    }

    public function set40(string $value): static
    {
        $this->40 = $value;
        return $this;
    }

    public function getExtraPlan(): int
    {
        return $this->extraPlan;
    }

    public function setExtraPlan(int $value): static
    {
        $this->extraPlan = $value;
        return $this;
    }

    public function getCustomSize(): string
    {
        return $this->customSize;
    }

    public function setCustomSize(string $value): static
    {
        $this->customSize = $value;
        return $this;
    }

    public function getCustomSizeBelowSt(): string
    {
        return $this->customSizeBelowSt;
    }

    public function setCustomSizeBelowSt(string $value): static
    {
        $this->customSizeBelowSt = $value;
        return $this;
    }

    public function getMethod(): int
    {
        return $this->method;
    }

    public function setMethod(int $value): static
    {
        $this->method = $value;
        return $this;
    }

    public function getCategory(): int
    {
        return $this->category;
    }

    public function setCategory(int $value): static
    {
        $this->category = $value;
        return $this;
    }
}
