<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "portal_version" table
 */
#[Entity]
#[Table(name: "portal_version")]
class PortalVersion extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "string", nullable: true)]
    private ?string $version;

    #[Column(name: "php_code", type: "string", nullable: true)]
    private ?string $phpCode;

    #[Column(name: "portal_d_php_code", type: "text", nullable: true)]
    private ?string $portalDPhpCode;

    #[Column(name: "portal_d_apc_query", type: "text", nullable: true)]
    private ?string $portalDApcQuery;

    #[Column(name: "portal_d_mysql_query", type: "text", nullable: true)]
    private ?string $portalDMysqlQuery;

    #[Column(name: "portal_d_sp_query", type: "text", nullable: true)]
    private ?string $portalDSpQuery;

    #[Column(name: "portal_d_url_link", type: "text", nullable: true)]
    private ?string $portalDUrlLink;

    #[Column(name: "portal_c_php_code", type: "text", nullable: true)]
    private ?string $portalCPhpCode;

    #[Column(name: "mysql_query", type: "text", nullable: true)]
    private ?string $mysqlQuery;

    #[Column(name: "portal_c_mysql_query", type: "text", nullable: true)]
    private ?string $portalCMysqlQuery;

    #[Column(name: "sp_query", type: "text", nullable: true)]
    private ?string $spQuery;

    #[Column(name: "portal_c_sp_query", type: "text", nullable: true)]
    private ?string $portalCSpQuery;

    #[Column(name: "apc_query", type: "text", nullable: true)]
    private ?string $apcQuery;

    #[Column(name: "portal_c_apc_query", type: "text", nullable: true)]
    private ?string $portalCApcQuery;

    #[Column(name: "url_link", type: "string", nullable: true)]
    private ?string $urlLink;

    #[Column(name: "u_type", type: "smallint")]
    private int $uType;

    public function __construct()
    {
        $this->phpCode = 'd0a125f695437c8e79d67fb6b96087ac' . date("ymdhis");
        $this->uType = 1;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getVersion(): ?string
    {
        return HtmlDecode($this->version);
    }

    public function setVersion(?string $value): static
    {
        $this->version = RemoveXss($value);
        return $this;
    }

    public function getPhpCode(): ?string
    {
        return HtmlDecode($this->phpCode);
    }

    public function setPhpCode(?string $value): static
    {
        $this->phpCode = RemoveXss($value);
        return $this;
    }

    public function getPortalDPhpCode(): ?string
    {
        return HtmlDecode($this->portalDPhpCode);
    }

    public function setPortalDPhpCode(?string $value): static
    {
        $this->portalDPhpCode = RemoveXss($value);
        return $this;
    }

    public function getPortalDApcQuery(): ?string
    {
        return HtmlDecode($this->portalDApcQuery);
    }

    public function setPortalDApcQuery(?string $value): static
    {
        $this->portalDApcQuery = RemoveXss($value);
        return $this;
    }

    public function getPortalDMysqlQuery(): ?string
    {
        return HtmlDecode($this->portalDMysqlQuery);
    }

    public function setPortalDMysqlQuery(?string $value): static
    {
        $this->portalDMysqlQuery = RemoveXss($value);
        return $this;
    }

    public function getPortalDSpQuery(): ?string
    {
        return HtmlDecode($this->portalDSpQuery);
    }

    public function setPortalDSpQuery(?string $value): static
    {
        $this->portalDSpQuery = RemoveXss($value);
        return $this;
    }

    public function getPortalDUrlLink(): ?string
    {
        return HtmlDecode($this->portalDUrlLink);
    }

    public function setPortalDUrlLink(?string $value): static
    {
        $this->portalDUrlLink = RemoveXss($value);
        return $this;
    }

    public function getPortalCPhpCode(): ?string
    {
        return HtmlDecode($this->portalCPhpCode);
    }

    public function setPortalCPhpCode(?string $value): static
    {
        $this->portalCPhpCode = RemoveXss($value);
        return $this;
    }

    public function getMysqlQuery(): ?string
    {
        return HtmlDecode($this->mysqlQuery);
    }

    public function setMysqlQuery(?string $value): static
    {
        $this->mysqlQuery = RemoveXss($value);
        return $this;
    }

    public function getPortalCMysqlQuery(): ?string
    {
        return HtmlDecode($this->portalCMysqlQuery);
    }

    public function setPortalCMysqlQuery(?string $value): static
    {
        $this->portalCMysqlQuery = RemoveXss($value);
        return $this;
    }

    public function getSpQuery(): ?string
    {
        return HtmlDecode($this->spQuery);
    }

    public function setSpQuery(?string $value): static
    {
        $this->spQuery = RemoveXss($value);
        return $this;
    }

    public function getPortalCSpQuery(): ?string
    {
        return HtmlDecode($this->portalCSpQuery);
    }

    public function setPortalCSpQuery(?string $value): static
    {
        $this->portalCSpQuery = RemoveXss($value);
        return $this;
    }

    public function getApcQuery(): ?string
    {
        return HtmlDecode($this->apcQuery);
    }

    public function setApcQuery(?string $value): static
    {
        $this->apcQuery = RemoveXss($value);
        return $this;
    }

    public function getPortalCApcQuery(): ?string
    {
        return HtmlDecode($this->portalCApcQuery);
    }

    public function setPortalCApcQuery(?string $value): static
    {
        $this->portalCApcQuery = RemoveXss($value);
        return $this;
    }

    public function getUrlLink(): ?string
    {
        return HtmlDecode($this->urlLink);
    }

    public function setUrlLink(?string $value): static
    {
        $this->urlLink = RemoveXss($value);
        return $this;
    }

    public function getUType(): int
    {
        return $this->uType;
    }

    public function setUType(int $value): static
    {
        $this->uType = $value;
        return $this;
    }
}
