<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "portal_setup" table
 */
#[Entity]
#[Table(name: "portal_setup")]
class PortalSetup extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string")]
    private string $url;

    #[Column(name: "admin_url", type: "string")]
    private string $adminUrl;

    #[Column(name: "mail_code", type: "text")]
    private string $mailCode;

    #[Column(name: "footer_line", type: "text")]
    private string $footerLine;

    #[Column(name: "portal_category", type: "string", nullable: true)]
    private ?string $portalCategory;

    #[Column(type: "integer")]
    private int $mcu;

    #[Column(name: "fcm_server_key", type: "string")]
    private string $fcmServerKey;

    #[Column(name: "app_version", type: "integer")]
    private int $appVersion;

    #[Column(name: "pd_byepass", type: "integer")]
    private int $pdByepass;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(name: "google_map_api", type: "string")]
    private string $googleMapApi;

    #[Column(name: "material_payment_type", type: "integer")]
    private int $materialPaymentType;

    #[Column(name: "material_payment_varient", type: "integer")]
    private int $materialPaymentVarient;

    #[Column(name: "footer_line_be", type: "string")]
    private string $footerLineBe;

    #[Column(name: "allow_reg", type: "smallint")]
    private int $allowReg;

    #[Column(name: "login_remember", type: "integer", nullable: true)]
    private ?int $loginRemember;

    #[Column(name: "gp_p_check", type: "integer")]
    private int $gpPCheck;

    #[Column(name: "fe_version", type: "string")]
    private string $feVersion;

    #[Column(name: "admin_version", type: "string", nullable: true)]
    private ?string $adminVersion;

    #[Column(type: "smallint")]
    private int $dashboard;

    #[Column(name: "developer_upi_id", type: "string", nullable: true)]
    private ?string $developerUpiId;

    #[Column(name: "developer_company", type: "string", nullable: true)]
    private ?string $developerCompany;

    #[Column(name: "default_page", type: "string")]
    private string $defaultPage;

    #[Column(name: "bom_edit", type: "string", nullable: true)]
    private ?string $bomEdit;

    public function __construct()
    {
        $this->mcu = 0;
        $this->operator = 0;
        $this->allowReg = 0;
        $this->loginRemember = 0;
        $this->gpPCheck = 0;
        $this->dashboard = 1;
        $this->defaultPage = "db2";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getUrl(): string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }

    public function getAdminUrl(): string
    {
        return HtmlDecode($this->adminUrl);
    }

    public function setAdminUrl(string $value): static
    {
        $this->adminUrl = RemoveXss($value);
        return $this;
    }

    public function getMailCode(): string
    {
        return HtmlDecode($this->mailCode);
    }

    public function setMailCode(string $value): static
    {
        $this->mailCode = RemoveXss($value);
        return $this;
    }

    public function getFooterLine(): string
    {
        return HtmlDecode($this->footerLine);
    }

    public function setFooterLine(string $value): static
    {
        $this->footerLine = RemoveXss($value);
        return $this;
    }

    public function getPortalCategory(): ?string
    {
        return HtmlDecode($this->portalCategory);
    }

    public function setPortalCategory(?string $value): static
    {
        $this->portalCategory = RemoveXss($value);
        return $this;
    }

    public function getMcu(): int
    {
        return $this->mcu;
    }

    public function setMcu(int $value): static
    {
        $this->mcu = $value;
        return $this;
    }

    public function getFcmServerKey(): string
    {
        return HtmlDecode($this->fcmServerKey);
    }

    public function setFcmServerKey(string $value): static
    {
        $this->fcmServerKey = RemoveXss($value);
        return $this;
    }

    public function getAppVersion(): int
    {
        return $this->appVersion;
    }

    public function setAppVersion(int $value): static
    {
        $this->appVersion = $value;
        return $this;
    }

    public function getPdByepass(): int
    {
        return $this->pdByepass;
    }

    public function setPdByepass(int $value): static
    {
        $this->pdByepass = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getGoogleMapApi(): string
    {
        return HtmlDecode($this->googleMapApi);
    }

    public function setGoogleMapApi(string $value): static
    {
        $this->googleMapApi = RemoveXss($value);
        return $this;
    }

    public function getMaterialPaymentType(): int
    {
        return $this->materialPaymentType;
    }

    public function setMaterialPaymentType(int $value): static
    {
        $this->materialPaymentType = $value;
        return $this;
    }

    public function getMaterialPaymentVarient(): int
    {
        return $this->materialPaymentVarient;
    }

    public function setMaterialPaymentVarient(int $value): static
    {
        $this->materialPaymentVarient = $value;
        return $this;
    }

    public function getFooterLineBe(): string
    {
        return HtmlDecode($this->footerLineBe);
    }

    public function setFooterLineBe(string $value): static
    {
        $this->footerLineBe = RemoveXss($value);
        return $this;
    }

    public function getAllowReg(): int
    {
        return $this->allowReg;
    }

    public function setAllowReg(int $value): static
    {
        $this->allowReg = $value;
        return $this;
    }

    public function getLoginRemember(): ?int
    {
        return $this->loginRemember;
    }

    public function setLoginRemember(?int $value): static
    {
        $this->loginRemember = $value;
        return $this;
    }

    public function getGpPCheck(): int
    {
        return $this->gpPCheck;
    }

    public function setGpPCheck(int $value): static
    {
        $this->gpPCheck = $value;
        return $this;
    }

    public function getFeVersion(): string
    {
        return HtmlDecode($this->feVersion);
    }

    public function setFeVersion(string $value): static
    {
        $this->feVersion = RemoveXss($value);
        return $this;
    }

    public function getAdminVersion(): ?string
    {
        return HtmlDecode($this->adminVersion);
    }

    public function setAdminVersion(?string $value): static
    {
        $this->adminVersion = RemoveXss($value);
        return $this;
    }

    public function getDashboard(): int
    {
        return $this->dashboard;
    }

    public function setDashboard(int $value): static
    {
        $this->dashboard = $value;
        return $this;
    }

    public function getDeveloperUpiId(): ?string
    {
        return HtmlDecode($this->developerUpiId);
    }

    public function setDeveloperUpiId(?string $value): static
    {
        $this->developerUpiId = RemoveXss($value);
        return $this;
    }

    public function getDeveloperCompany(): ?string
    {
        return HtmlDecode($this->developerCompany);
    }

    public function setDeveloperCompany(?string $value): static
    {
        $this->developerCompany = RemoveXss($value);
        return $this;
    }

    public function getDefaultPage(): string
    {
        return HtmlDecode($this->defaultPage);
    }

    public function setDefaultPage(string $value): static
    {
        $this->defaultPage = RemoveXss($value);
        return $this;
    }

    public function getBomEdit(): ?string
    {
        return HtmlDecode($this->bomEdit);
    }

    public function setBomEdit(?string $value): static
    {
        $this->bomEdit = RemoveXss($value);
        return $this;
    }
}
