<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "portal_info" table
 */
#[Entity]
#[Table(name: "portal_info")]
class PortalInfo extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $logo;

    #[Column(name: "mobile_logo", type: "string", nullable: true)]
    private ?string $mobileLogo;

    #[Column(name: "fav_icon", type: "string", nullable: true)]
    private ?string $favIcon;

    #[Column(type: "string")]
    private string $name;

    #[Column(type: "text")]
    private string $address;

    #[Column(type: "string")]
    private string $email;

    #[Column(type: "string")]
    private string $mobile;

    #[Column(type: "string", nullable: true)]
    private ?string $gst;

    #[Column(type: "string", nullable: true)]
    private ?string $other;

    #[Column(name: "admin_mobile", type: "string", nullable: true)]
    private ?string $adminMobile;

    #[Column(type: "text", nullable: true)]
    private ?string $header;

    #[Column(type: "text", nullable: true)]
    private ?string $footer;

    #[Column(name: "tag_line", type: "string", nullable: true)]
    private ?string $tagLine;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "r_text", type: "text", nullable: true)]
    private ?string $rText;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLogo(): ?string
    {
        return HtmlDecode($this->logo);
    }

    public function setLogo(?string $value): static
    {
        $this->logo = RemoveXss($value);
        return $this;
    }

    public function getMobileLogo(): ?string
    {
        return HtmlDecode($this->mobileLogo);
    }

    public function setMobileLogo(?string $value): static
    {
        $this->mobileLogo = RemoveXss($value);
        return $this;
    }

    public function getFavIcon(): ?string
    {
        return HtmlDecode($this->favIcon);
    }

    public function setFavIcon(?string $value): static
    {
        $this->favIcon = RemoveXss($value);
        return $this;
    }

    public function getName(): string
    {
        return HtmlDecode($this->name);
    }

    public function setName(string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getAddress(): string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getEmail(): string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getMobile(): string
    {
        return HtmlDecode($this->mobile);
    }

    public function setMobile(string $value): static
    {
        $this->mobile = RemoveXss($value);
        return $this;
    }

    public function getGst(): ?string
    {
        return HtmlDecode($this->gst);
    }

    public function setGst(?string $value): static
    {
        $this->gst = RemoveXss($value);
        return $this;
    }

    public function getOther(): ?string
    {
        return HtmlDecode($this->other);
    }

    public function setOther(?string $value): static
    {
        $this->other = RemoveXss($value);
        return $this;
    }

    public function getAdminMobile(): ?string
    {
        return HtmlDecode($this->adminMobile);
    }

    public function setAdminMobile(?string $value): static
    {
        $this->adminMobile = RemoveXss($value);
        return $this;
    }

    public function getHeader(): ?string
    {
        return HtmlDecode($this->header);
    }

    public function setHeader(?string $value): static
    {
        $this->header = RemoveXss($value);
        return $this;
    }

    public function getFooter(): ?string
    {
        return HtmlDecode($this->footer);
    }

    public function setFooter(?string $value): static
    {
        $this->footer = RemoveXss($value);
        return $this;
    }

    public function getTagLine(): ?string
    {
        return HtmlDecode($this->tagLine);
    }

    public function setTagLine(?string $value): static
    {
        $this->tagLine = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getRText(): ?string
    {
        return HtmlDecode($this->rText);
    }

    public function setRText(?string $value): static
    {
        $this->rText = RemoveXss($value);
        return $this;
    }
}
