<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "po_status" table
 */
#[Entity]
#[Table(name: "po_status")]
class PoStatus extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $po;

    #[Column(name: "delivery_date", type: "date")]
    private DateTime $deliveryDate;

    #[Column(name: "reminder_date", type: "datetime")]
    private DateTime $reminderDate;

    #[Column(name: "reminder_for", type: "string")]
    private string $reminderFor;

    #[Column(name: "po_current_status", type: "text", nullable: true)]
    private ?string $poCurrentStatus;

    #[Column(name: "pp_operator", type: "smallint", nullable: true)]
    private ?int $ppOperator;

    #[Column(name: "pp_datetime", type: "datetime", nullable: true)]
    private ?DateTime $ppDatetime;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPo(): int
    {
        return $this->po;
    }

    public function setPo(int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getDeliveryDate(): DateTime
    {
        return $this->deliveryDate;
    }

    public function setDeliveryDate(DateTime $value): static
    {
        $this->deliveryDate = $value;
        return $this;
    }

    public function getReminderDate(): DateTime
    {
        return $this->reminderDate;
    }

    public function setReminderDate(DateTime $value): static
    {
        $this->reminderDate = $value;
        return $this;
    }

    public function getReminderFor(): string
    {
        return HtmlDecode($this->reminderFor);
    }

    public function setReminderFor(string $value): static
    {
        $this->reminderFor = RemoveXss($value);
        return $this;
    }

    public function getPoCurrentStatus(): ?string
    {
        return HtmlDecode($this->poCurrentStatus);
    }

    public function setPoCurrentStatus(?string $value): static
    {
        $this->poCurrentStatus = RemoveXss($value);
        return $this;
    }

    public function getPpOperator(): ?int
    {
        return $this->ppOperator;
    }

    public function setPpOperator(?int $value): static
    {
        $this->ppOperator = $value;
        return $this;
    }

    public function getPpDatetime(): ?DateTime
    {
        return $this->ppDatetime;
    }

    public function setPpDatetime(?DateTime $value): static
    {
        $this->ppDatetime = $value;
        return $this;
    }
}
