<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "po_setup" table
 */
#[Entity]
#[Table(name: "po_setup")]
class PoSetup extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    private int $id;

    #[Column(name: "gst_included", type: "integer")]
    private int $gstIncluded;

    #[Column(name: "po_b_transfer", type: "integer")]
    private int $poBTransfer;

    #[Column(name: "po_b_sample_auto_auth", type: "integer")]
    private int $poBSampleAutoAuth;

    #[Column(name: "po_s_sample_auto_auth", type: "integer")]
    private int $poSSampleAutoAuth;

    #[Column(name: "po_cbm", type: "integer")]
    private int $poCbm;

    #[Column(name: "po_buyer_uid", type: "integer")]
    private int $poBuyerUid;

    #[Column(name: "po_gst", type: "integer")]
    private int $poGst;

    #[Column(name: "po_sqm", type: "integer")]
    private int $poSqm;

    #[Column(name: "po_prod_price", type: "integer")]
    private int $poProdPrice;

    #[Column(name: "po_size", type: "integer")]
    private int $poSize;

    #[Column(name: "po_bom", type: "smallint")]
    private int $poBom;

    #[Column(name: "po_process", type: "integer")]
    private int $poProcess;

    #[Column(name: "po_buyer_code_prod", type: "integer")]
    private int $poBuyerCodeProd;

    #[Column(name: "mr_live_datetime", type: "datetime", nullable: true)]
    private ?DateTime $mrLiveDatetime;

    #[Column(name: "po_b_unauthorize", type: "string", nullable: true)]
    private ?string $poBUnauthorize;

    #[Column(name: "cart_b_password", type: "string", nullable: true)]
    private ?string $cartBPassword;

    #[Column(name: "cart_s_password", type: "string", nullable: true)]
    private ?string $cartSPassword;

    #[Column(name: "jc_po_yesno", type: "integer")]
    private int $jcPoYesno;

    public function __construct()
    {
        $this->gstIncluded = 0;
        $this->poBSampleAutoAuth = 0;
        $this->poSSampleAutoAuth = 0;
        $this->poCbm = 0;
        $this->poBuyerUid = 1;
        $this->poGst = 1;
        $this->poSize = 0;
        $this->poBuyerCodeProd = 0;
        $this->jcPoYesno = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGstIncluded(): int
    {
        return $this->gstIncluded;
    }

    public function setGstIncluded(int $value): static
    {
        $this->gstIncluded = $value;
        return $this;
    }

    public function getPoBTransfer(): int
    {
        return $this->poBTransfer;
    }

    public function setPoBTransfer(int $value): static
    {
        $this->poBTransfer = $value;
        return $this;
    }

    public function getPoBSampleAutoAuth(): int
    {
        return $this->poBSampleAutoAuth;
    }

    public function setPoBSampleAutoAuth(int $value): static
    {
        $this->poBSampleAutoAuth = $value;
        return $this;
    }

    public function getPoSSampleAutoAuth(): int
    {
        return $this->poSSampleAutoAuth;
    }

    public function setPoSSampleAutoAuth(int $value): static
    {
        $this->poSSampleAutoAuth = $value;
        return $this;
    }

    public function getPoCbm(): int
    {
        return $this->poCbm;
    }

    public function setPoCbm(int $value): static
    {
        $this->poCbm = $value;
        return $this;
    }

    public function getPoBuyerUid(): int
    {
        return $this->poBuyerUid;
    }

    public function setPoBuyerUid(int $value): static
    {
        $this->poBuyerUid = $value;
        return $this;
    }

    public function getPoGst(): int
    {
        return $this->poGst;
    }

    public function setPoGst(int $value): static
    {
        $this->poGst = $value;
        return $this;
    }

    public function getPoSqm(): int
    {
        return $this->poSqm;
    }

    public function setPoSqm(int $value): static
    {
        $this->poSqm = $value;
        return $this;
    }

    public function getPoProdPrice(): int
    {
        return $this->poProdPrice;
    }

    public function setPoProdPrice(int $value): static
    {
        $this->poProdPrice = $value;
        return $this;
    }

    public function getPoSize(): int
    {
        return $this->poSize;
    }

    public function setPoSize(int $value): static
    {
        $this->poSize = $value;
        return $this;
    }

    public function getPoBom(): int
    {
        return $this->poBom;
    }

    public function setPoBom(int $value): static
    {
        $this->poBom = $value;
        return $this;
    }

    public function getPoProcess(): int
    {
        return $this->poProcess;
    }

    public function setPoProcess(int $value): static
    {
        $this->poProcess = $value;
        return $this;
    }

    public function getPoBuyerCodeProd(): int
    {
        return $this->poBuyerCodeProd;
    }

    public function setPoBuyerCodeProd(int $value): static
    {
        $this->poBuyerCodeProd = $value;
        return $this;
    }

    public function getMrLiveDatetime(): ?DateTime
    {
        return $this->mrLiveDatetime;
    }

    public function setMrLiveDatetime(?DateTime $value): static
    {
        $this->mrLiveDatetime = $value;
        return $this;
    }

    public function getPoBUnauthorize(): ?string
    {
        return HtmlDecode($this->poBUnauthorize);
    }

    public function setPoBUnauthorize(?string $value): static
    {
        $this->poBUnauthorize = RemoveXss($value);
        return $this;
    }

    public function getCartBPassword(): ?string
    {
        return HtmlDecode($this->cartBPassword);
    }

    public function setCartBPassword(?string $value): static
    {
        $this->cartBPassword = RemoveXss($value);
        return $this;
    }

    public function getCartSPassword(): ?string
    {
        return HtmlDecode($this->cartSPassword);
    }

    public function setCartSPassword(?string $value): static
    {
        $this->cartSPassword = RemoveXss($value);
        return $this;
    }

    public function getJcPoYesno(): int
    {
        return $this->jcPoYesno;
    }

    public function setJcPoYesno(int $value): static
    {
        $this->jcPoYesno = $value;
        return $this;
    }
}
