<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "po_s_pending_p_remarks" table
 */
#[Entity]
#[Table(name: "po_s_pending_p_remarks")]
class PoSPendingPRemark extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer")]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "rid_1", type: "text", nullable: true)]
    private ?string $rid1;

    #[Column(type: "decimal")]
    private string $quantity;

    #[Column(type: "decimal")]
    private string $pending;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "p_remarks", type: "string", nullable: true)]
    private ?string $pRemarks;

    public function __construct()
    {
        $this->pending = "0.000";
        $this->pRemarks = "Order Placed";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getRid1(): ?string
    {
        return HtmlDecode($this->rid1);
    }

    public function setRid1(?string $value): static
    {
        $this->rid1 = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): string
    {
        return $this->quantity;
    }

    public function setQuantity(string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getPending(): string
    {
        return $this->pending;
    }

    public function setPending(string $value): static
    {
        $this->pending = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getPRemarks(): ?string
    {
        return HtmlDecode($this->pRemarks);
    }

    public function setPRemarks(?string $value): static
    {
        $this->pRemarks = RemoveXss($value);
        return $this;
    }
}
