<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "po_s_pending" table
 */
#[Entity]
#[Table(name: "po_s_pending")]
class PoSPending extends AbstractEntity
{
    #[Id]
    #[Column(name: "cart_id", type: "integer")]
    private int $cartId;

    #[Column(name: "po_id", type: "smallint", nullable: true)]
    private ?int $poId;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(name: "partner_id", type: "integer", nullable: true)]
    private ?int $partnerId;

    #[Column(name: "partner_order_no", type: "string", nullable: true)]
    private ?string $partnerOrderNo;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "p_remarks", type: "string", nullable: true)]
    private ?string $pRemarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(type: "smallint", nullable: true)]
    private ?int $ref;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(name: "order_quantity", type: "decimal")]
    private string $orderQuantity;

    #[Column(type: "decimal")]
    private string $purchase;

    #[Column(name: "pending_qty", type: "decimal")]
    private string $pendingQty;

    #[Column(name: "order_date", type: "datetime", nullable: true)]
    private ?DateTime $orderDate;

    #[Column(name: "despatch_date", type: "date", nullable: true)]
    private ?DateTime $despatchDate;

    #[Column(name: "avg_quantity", type: "smallint", nullable: true)]
    private ?int $avgQuantity;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(type: "integer")]
    private int $status;

    #[Column(name: "p_id", type: "string", nullable: true)]
    private ?string $pId;

    #[Column(name: "partner_name", type: "string", nullable: true)]
    private ?string $partnerName;

    #[Column(name: "p_qty", type: "decimal")]
    private string $pQty;

    public function __construct()
    {
        $this->cartId = 0;
        $this->pRemarks = "Order Placed";
        $this->status = 0;
        $this->pQty = "0.000";
    }

    public function getCartId(): int
    {
        return $this->cartId;
    }

    public function setCartId(int $value): static
    {
        $this->cartId = $value;
        return $this;
    }

    public function getPoId(): ?int
    {
        return $this->poId;
    }

    public function setPoId(?int $value): static
    {
        $this->poId = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getPartnerId(): ?int
    {
        return $this->partnerId;
    }

    public function setPartnerId(?int $value): static
    {
        $this->partnerId = $value;
        return $this;
    }

    public function getPartnerOrderNo(): ?string
    {
        return HtmlDecode($this->partnerOrderNo);
    }

    public function setPartnerOrderNo(?string $value): static
    {
        $this->partnerOrderNo = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getPRemarks(): ?string
    {
        return HtmlDecode($this->pRemarks);
    }

    public function setPRemarks(?string $value): static
    {
        $this->pRemarks = RemoveXss($value);
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRef(): ?int
    {
        return $this->ref;
    }

    public function setRef(?int $value): static
    {
        $this->ref = $value;
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getOrderQuantity(): string
    {
        return $this->orderQuantity;
    }

    public function setOrderQuantity(string $value): static
    {
        $this->orderQuantity = $value;
        return $this;
    }

    public function getPurchase(): string
    {
        return $this->purchase;
    }

    public function setPurchase(string $value): static
    {
        $this->purchase = $value;
        return $this;
    }

    public function getPendingQty(): string
    {
        return $this->pendingQty;
    }

    public function setPendingQty(string $value): static
    {
        $this->pendingQty = $value;
        return $this;
    }

    public function getOrderDate(): ?DateTime
    {
        return $this->orderDate;
    }

    public function setOrderDate(?DateTime $value): static
    {
        $this->orderDate = $value;
        return $this;
    }

    public function getDespatchDate(): ?DateTime
    {
        return $this->despatchDate;
    }

    public function setDespatchDate(?DateTime $value): static
    {
        $this->despatchDate = $value;
        return $this;
    }

    public function getAvgQuantity(): ?int
    {
        return $this->avgQuantity;
    }

    public function setAvgQuantity(?int $value): static
    {
        $this->avgQuantity = $value;
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getPId(): ?string
    {
        return HtmlDecode($this->pId);
    }

    public function setPId(?string $value): static
    {
        $this->pId = RemoveXss($value);
        return $this;
    }

    public function getPartnerName(): ?string
    {
        return HtmlDecode($this->partnerName);
    }

    public function setPartnerName(?string $value): static
    {
        $this->partnerName = RemoveXss($value);
        return $this;
    }

    public function getPQty(): string
    {
        return $this->pQty;
    }

    public function setPQty(string $value): static
    {
        $this->pQty = $value;
        return $this;
    }
}
