<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "po_s_app" table
 */
#[Entity]
#[Table(name: "po_s_app")]
class PoSApp extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $po;

    #[Column(name: "a_datetime", type: "datetime", nullable: true)]
    private ?DateTime $aDatetime;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(name: "partner_id", type: "integer", nullable: true)]
    private ?int $partnerId;

    #[Column(type: "decimal", nullable: true)]
    private ?string $quantity;

    #[Column(type: "float")]
    private float $sqm;

    #[Column(type: "float")]
    private float $cbm;

    #[Column(type: "string")]
    private string $amount;

    #[Column(name: "app_operator", type: "smallint", nullable: true)]
    private ?int $appOperator;

    #[Column(name: "app_datetime", type: "datetime", nullable: true)]
    private ?DateTime $appDatetime;

    #[Column(name: "a_operator", type: "smallint", nullable: true)]
    private ?int $aOperator;

    #[Column(type: "smallint")]
    private int $request;

    public function __construct()
    {
        $this->request = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPo(): int
    {
        return $this->po;
    }

    public function setPo(int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getADatetime(): ?DateTime
    {
        return $this->aDatetime;
    }

    public function setADatetime(?DateTime $value): static
    {
        $this->aDatetime = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getPartnerId(): ?int
    {
        return $this->partnerId;
    }

    public function setPartnerId(?int $value): static
    {
        $this->partnerId = $value;
        return $this;
    }

    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    public function setQuantity(?string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getSqm(): float
    {
        return $this->sqm;
    }

    public function setSqm(float $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getCbm(): float
    {
        return $this->cbm;
    }

    public function setCbm(float $value): static
    {
        $this->cbm = $value;
        return $this;
    }

    public function getAmount(): string
    {
        return HtmlDecode($this->amount);
    }

    public function setAmount(string $value): static
    {
        $this->amount = RemoveXss($value);
        return $this;
    }

    public function getAppOperator(): ?int
    {
        return $this->appOperator;
    }

    public function setAppOperator(?int $value): static
    {
        $this->appOperator = $value;
        return $this;
    }

    public function getAppDatetime(): ?DateTime
    {
        return $this->appDatetime;
    }

    public function setAppDatetime(?DateTime $value): static
    {
        $this->appDatetime = $value;
        return $this;
    }

    public function getAOperator(): ?int
    {
        return $this->aOperator;
    }

    public function setAOperator(?int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getRequest(): int
    {
        return $this->request;
    }

    public function setRequest(int $value): static
    {
        $this->request = $value;
        return $this;
    }
}
