<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "po_pending_wbc_jobcard" table
 */
#[Entity]
#[Table(name: "po_pending_wbc_jobcard")]
class PoPendingWbcJobcard extends AbstractEntity
{
    #[Column(name: "jc_no", type: "integer", nullable: true)]
    private ?int $jcNo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $rid;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(name: "packing_type", type: "smallint")]
    private int $packingType;

    #[Column(name: "batch_no", type: "string", nullable: true)]
    private ?string $batchNo;

    #[Column(type: "string", nullable: true)]
    private ?string $po;

    #[Column(name: "jc_quantity", type: "float")]
    private float $jcQuantity;

    #[Column(name: "issue_to", type: "integer", nullable: true)]
    private ?int $issueTo;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(name: "pending_quantity", type: "float")]
    private float $pendingQuantity;

    #[Column(name: "issued_actual", type: "decimal", nullable: true)]
    private ?string $issuedActual;

    #[Column(name: "bom_weight", type: "float", nullable: true)]
    private ?float $bomWeight;

    #[Column(name: "received_quantity", type: "decimal")]
    private string $receivedQuantity;

    #[Column(name: "par_com", type: "decimal")]
    private string $parCom;

    #[Column(type: "string", nullable: true)]
    private ?string $ref;

    public function __construct()
    {
        $this->issueTo = 0;
        $this->pendingQuantity = 0.00;
        $this->receivedQuantity = "0.000";
        $this->parCom = "0";
    }

    public function getJcNo(): ?int
    {
        return $this->jcNo;
    }

    public function setJcNo(?int $value): static
    {
        $this->jcNo = $value;
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): int
    {
        return $this->packingType;
    }

    public function setPackingType(int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getBatchNo(): ?string
    {
        return HtmlDecode($this->batchNo);
    }

    public function setBatchNo(?string $value): static
    {
        $this->batchNo = RemoveXss($value);
        return $this;
    }

    public function getPo(): ?string
    {
        return HtmlDecode($this->po);
    }

    public function setPo(?string $value): static
    {
        $this->po = RemoveXss($value);
        return $this;
    }

    public function getJcQuantity(): float
    {
        return $this->jcQuantity;
    }

    public function setJcQuantity(float $value): static
    {
        $this->jcQuantity = $value;
        return $this;
    }

    public function getIssueTo(): ?int
    {
        return $this->issueTo;
    }

    public function setIssueTo(?int $value): static
    {
        $this->issueTo = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getPendingQuantity(): float
    {
        return $this->pendingQuantity;
    }

    public function setPendingQuantity(float $value): static
    {
        $this->pendingQuantity = $value;
        return $this;
    }

    public function getIssuedActual(): ?string
    {
        return $this->issuedActual;
    }

    public function setIssuedActual(?string $value): static
    {
        $this->issuedActual = $value;
        return $this;
    }

    public function getBomWeight(): ?float
    {
        return $this->bomWeight;
    }

    public function setBomWeight(?float $value): static
    {
        $this->bomWeight = $value;
        return $this;
    }

    public function getReceivedQuantity(): string
    {
        return $this->receivedQuantity;
    }

    public function setReceivedQuantity(string $value): static
    {
        $this->receivedQuantity = $value;
        return $this;
    }

    public function getParCom(): string
    {
        return $this->parCom;
    }

    public function setParCom(string $value): static
    {
        $this->parCom = $value;
        return $this;
    }

    public function getRef(): ?string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(?string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }
}
