<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "po_pending_wbc_internal" table
 */
#[Entity]
#[Table(name: "po_pending_wbc_internal")]
class PoPendingWbcInternal extends AbstractEntity
{
    #[Column(type: "integer")]
    private int $id;

    #[Column(type: "integer")]
    private int $po;

    #[Column(type: "string")]
    private string $pod;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(type: "smallint")]
    private int $rid;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(name: "packing_type", type: "integer")]
    private int $packingType;

    #[Column(type: "string")]
    private string $gcode;

    #[Column(name: "batch_no", type: "integer")]
    private int $batchNo;

    #[Column(type: "integer", nullable: true)]
    private ?int $process;

    #[Column(name: "cart_quantity", type: "decimal", nullable: true)]
    private ?string $cartQuantity;

    #[Column(name: "jc_quantity", type: "integer")]
    private int $jcQuantity;

    #[Column(name: "pending_qty", type: "integer")]
    private int $pendingQty;

    #[Column(name: "despatch_week", type: "integer")]
    private int $despatchWeek;

    #[Column(name: "despatch_date", type: "date", nullable: true)]
    private ?DateTime $despatchDate;

    #[Column(name: "jc_no", type: "integer")]
    private int $jcNo;

    #[Column(name: "issue_to", type: "integer", nullable: true)]
    private ?int $issueTo;

    #[Column(name: "pam_id", type: "text", nullable: true)]
    private ?string $pamId;

    #[Column(name: "pam_qty", type: "decimal", nullable: true)]
    private ?string $pamQty;

    #[Column(name: "pp_qty", type: "decimal")]
    private string $ppQty;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    public function __construct()
    {
        $this->id = 0;
        $this->po = 0;
        $this->packingType = 0;
        $this->batchNo = 0;
        $this->jcQuantity = 0;
        $this->pendingQty = 0;
        $this->despatchWeek = 0;
        $this->jcNo = 0;
        $this->ppQty = "0.000";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPo(): int
    {
        return $this->po;
    }

    public function setPo(int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getPod(): string
    {
        return HtmlDecode($this->pod);
    }

    public function setPod(string $value): static
    {
        $this->pod = RemoveXss($value);
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): int
    {
        return $this->packingType;
    }

    public function setPackingType(int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getGcode(): string
    {
        return HtmlDecode($this->gcode);
    }

    public function setGcode(string $value): static
    {
        $this->gcode = RemoveXss($value);
        return $this;
    }

    public function getBatchNo(): int
    {
        return $this->batchNo;
    }

    public function setBatchNo(int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getProcess(): ?int
    {
        return $this->process;
    }

    public function setProcess(?int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getCartQuantity(): ?string
    {
        return $this->cartQuantity;
    }

    public function setCartQuantity(?string $value): static
    {
        $this->cartQuantity = $value;
        return $this;
    }

    public function getJcQuantity(): int
    {
        return $this->jcQuantity;
    }

    public function setJcQuantity(int $value): static
    {
        $this->jcQuantity = $value;
        return $this;
    }

    public function getPendingQty(): int
    {
        return $this->pendingQty;
    }

    public function setPendingQty(int $value): static
    {
        $this->pendingQty = $value;
        return $this;
    }

    public function getDespatchWeek(): int
    {
        return $this->despatchWeek;
    }

    public function setDespatchWeek(int $value): static
    {
        $this->despatchWeek = $value;
        return $this;
    }

    public function getDespatchDate(): ?DateTime
    {
        return $this->despatchDate;
    }

    public function setDespatchDate(?DateTime $value): static
    {
        $this->despatchDate = $value;
        return $this;
    }

    public function getJcNo(): int
    {
        return $this->jcNo;
    }

    public function setJcNo(int $value): static
    {
        $this->jcNo = $value;
        return $this;
    }

    public function getIssueTo(): ?int
    {
        return $this->issueTo;
    }

    public function setIssueTo(?int $value): static
    {
        $this->issueTo = $value;
        return $this;
    }

    public function getPamId(): ?string
    {
        return HtmlDecode($this->pamId);
    }

    public function setPamId(?string $value): static
    {
        $this->pamId = RemoveXss($value);
        return $this;
    }

    public function getPamQty(): ?string
    {
        return $this->pamQty;
    }

    public function setPamQty(?string $value): static
    {
        $this->pamQty = $value;
        return $this;
    }

    public function getPpQty(): string
    {
        return $this->ppQty;
    }

    public function setPpQty(string $value): static
    {
        $this->ppQty = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }
}
