<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "po_pending_wbc" table
 */
#[Entity]
#[Table(name: "po_pending_wbc")]
class PoPendingWbc extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer")]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $po;

    #[Column(type: "string", nullable: true)]
    private ?string $pod;

    #[Column(name: "jc_no", type: "text", nullable: true)]
    private ?string $jcNo;

    #[Column(type: "string", nullable: true)]
    private ?string $gcode;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(name: "batch_no", type: "smallint", nullable: true)]
    private ?int $batchNo;

    #[Column(name: "cart_quantity", type: "float", nullable: true)]
    private ?float $cartQuantity;

    #[Column(name: "pam_qty", type: "decimal", nullable: true)]
    private ?string $pamQty;

    #[Column(name: "pending_qty", type: "float", nullable: true)]
    private ?float $pendingQty;

    #[Column(name: "despatch_week", type: "smallint", nullable: true)]
    private ?int $despatchWeek;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "string", nullable: true)]
    private ?string $rid;

    #[Column(name: "despatch_date", type: "date", nullable: true)]
    private ?DateTime $despatchDate;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(type: "string", nullable: true)]
    private ?string $process;

    #[Column(name: "pam_id", type: "string", nullable: true)]
    private ?string $pamId;

    #[Column(name: "issue_to", type: "integer", nullable: true)]
    private ?int $issueTo;

    #[Column(name: "pp_qty", type: "decimal", nullable: true)]
    private ?string $ppQty;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(name: "jc_quantity", type: "decimal", nullable: true)]
    private ?string $jcQuantity;

    #[Column(name: "buyer_id", type: "integer", nullable: true)]
    private ?int $buyerId;

    #[Column(type: "smallint", nullable: true)]
    private ?int $level;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "decimal")]
    private string $balance;

    public function __construct()
    {
        $this->id = 0;
        $this->po = 0;
        $this->pamQty = "0.000";
        $this->packingType = 0;
        $this->issueTo = 0;
        $this->jcQuantity = "0.000";
        $this->level = 0;
        $this->balance = "0.000";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getPod(): ?string
    {
        return HtmlDecode($this->pod);
    }

    public function setPod(?string $value): static
    {
        $this->pod = RemoveXss($value);
        return $this;
    }

    public function getJcNo(): ?string
    {
        return HtmlDecode($this->jcNo);
    }

    public function setJcNo(?string $value): static
    {
        $this->jcNo = RemoveXss($value);
        return $this;
    }

    public function getGcode(): ?string
    {
        return HtmlDecode($this->gcode);
    }

    public function setGcode(?string $value): static
    {
        $this->gcode = RemoveXss($value);
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getBatchNo(): ?int
    {
        return $this->batchNo;
    }

    public function setBatchNo(?int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getCartQuantity(): ?float
    {
        return $this->cartQuantity;
    }

    public function setCartQuantity(?float $value): static
    {
        $this->cartQuantity = $value;
        return $this;
    }

    public function getPamQty(): ?string
    {
        return $this->pamQty;
    }

    public function setPamQty(?string $value): static
    {
        $this->pamQty = $value;
        return $this;
    }

    public function getPendingQty(): ?float
    {
        return $this->pendingQty;
    }

    public function setPendingQty(?float $value): static
    {
        $this->pendingQty = $value;
        return $this;
    }

    public function getDespatchWeek(): ?int
    {
        return $this->despatchWeek;
    }

    public function setDespatchWeek(?int $value): static
    {
        $this->despatchWeek = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getRid(): ?string
    {
        return HtmlDecode($this->rid);
    }

    public function setRid(?string $value): static
    {
        $this->rid = RemoveXss($value);
        return $this;
    }

    public function getDespatchDate(): ?DateTime
    {
        return $this->despatchDate;
    }

    public function setDespatchDate(?DateTime $value): static
    {
        $this->despatchDate = $value;
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getProcess(): ?string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(?string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }

    public function getPamId(): ?string
    {
        return HtmlDecode($this->pamId);
    }

    public function setPamId(?string $value): static
    {
        $this->pamId = RemoveXss($value);
        return $this;
    }

    public function getIssueTo(): ?int
    {
        return $this->issueTo;
    }

    public function setIssueTo(?int $value): static
    {
        $this->issueTo = $value;
        return $this;
    }

    public function getPpQty(): ?string
    {
        return $this->ppQty;
    }

    public function setPpQty(?string $value): static
    {
        $this->ppQty = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getJcQuantity(): ?string
    {
        return $this->jcQuantity;
    }

    public function setJcQuantity(?string $value): static
    {
        $this->jcQuantity = $value;
        return $this;
    }

    public function getBuyerId(): ?int
    {
        return $this->buyerId;
    }

    public function setBuyerId(?int $value): static
    {
        $this->buyerId = $value;
        return $this;
    }

    public function getLevel(): ?int
    {
        return $this->level;
    }

    public function setLevel(?int $value): static
    {
        $this->level = $value;
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getBalance(): string
    {
        return $this->balance;
    }

    public function setBalance(string $value): static
    {
        $this->balance = $value;
        return $this;
    }
}
