<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "po_pending" table
 */
#[Entity]
#[Table(name: "po_pending")]
class PoPending extends AbstractEntity
{
    #[Id]
    #[Column(name: "cart_id", type: "integer")]
    private int $cartId;

    #[Column(name: "po_id", type: "smallint", nullable: true)]
    private ?int $poId;

    #[Column(name: "partner_order_no", type: "string", nullable: true)]
    private ?string $partnerOrderNo;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(type: "smallint", nullable: true)]
    private ?int $ref;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(type: "decimal")]
    private string $quantity;

    #[Column(type: "decimal", nullable: true)]
    private ?string $stock;

    #[Column(name: "despatch_date", type: "date", nullable: true)]
    private ?DateTime $despatchDate;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(name: "partner_id", type: "integer", nullable: true)]
    private ?int $partnerId;

    #[Column(name: "avg_quantity", type: "decimal", nullable: true)]
    private ?string $avgQuantity;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(name: "packing_type", type: "decimal", nullable: true)]
    private ?string $packingType;

    #[Column(name: "m_out_id", type: "string", nullable: true)]
    private ?string $mOutId;

    public function __construct()
    {
        $this->poId = 0;
        $this->status = 0;
    }

    public function getCartId(): int
    {
        return $this->cartId;
    }

    public function setCartId(int $value): static
    {
        $this->cartId = $value;
        return $this;
    }

    public function getPoId(): ?int
    {
        return $this->poId;
    }

    public function setPoId(?int $value): static
    {
        $this->poId = $value;
        return $this;
    }

    public function getPartnerOrderNo(): ?string
    {
        return HtmlDecode($this->partnerOrderNo);
    }

    public function setPartnerOrderNo(?string $value): static
    {
        $this->partnerOrderNo = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getRef(): ?int
    {
        return $this->ref;
    }

    public function setRef(?int $value): static
    {
        $this->ref = $value;
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): string
    {
        return $this->quantity;
    }

    public function setQuantity(string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getStock(): ?string
    {
        return $this->stock;
    }

    public function setStock(?string $value): static
    {
        $this->stock = $value;
        return $this;
    }

    public function getDespatchDate(): ?DateTime
    {
        return $this->despatchDate;
    }

    public function setDespatchDate(?DateTime $value): static
    {
        $this->despatchDate = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getPartnerId(): ?int
    {
        return $this->partnerId;
    }

    public function setPartnerId(?int $value): static
    {
        $this->partnerId = $value;
        return $this;
    }

    public function getAvgQuantity(): ?string
    {
        return $this->avgQuantity;
    }

    public function setAvgQuantity(?string $value): static
    {
        $this->avgQuantity = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getPackingType(): ?string
    {
        return $this->packingType;
    }

    public function setPackingType(?string $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getMOutId(): ?string
    {
        return HtmlDecode($this->mOutId);
    }

    public function setMOutId(?string $value): static
    {
        $this->mOutId = RemoveXss($value);
        return $this;
    }
}
