<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "po_overall_cross" table
 */
#[Entity]
#[Table(name: "po_overall_cross")]
class PoOverallCross extends AbstractEntity
{
    #[Column(name: "Buyer", type: "integer", nullable: true)]
    private ?int $buyer;

    #[Column(name: "Month", type: "string", nullable: true)]
    private ?string $month;

    #[Column(name: "SQM_CY", type: "decimal")]
    private string $sqmCy;

    #[Column(name: "Amount_CY", type: "string")]
    private string $amountCy;

    #[Column(name: "SQM_PY", type: "decimal")]
    private string $sqmPy;

    #[Column(name: "Amount_PY", type: "string")]
    private string $amountPy;

    #[Column(name: "SQM_BPY", type: "decimal")]
    private string $sqmBpy;

    #[Column(name: "Amount_BPY", type: "string")]
    private string $amountBpy;

    #[Column(name: "SQM_BBPY", type: "decimal")]
    private string $sqmBbpy;

    #[Column(name: "Amount_BBPY", type: "string")]
    private string $amountBbpy;

    public function __construct()
    {
        $this->sqmCy = "0.00";
        $this->sqmPy = "0.00";
        $this->sqmBpy = "0.00";
        $this->sqmBbpy = "0.00";
    }

    public function getBuyer(): ?int
    {
        return $this->buyer;
    }

    public function setBuyer(?int $value): static
    {
        $this->buyer = $value;
        return $this;
    }

    public function getMonth(): ?string
    {
        return HtmlDecode($this->month);
    }

    public function setMonth(?string $value): static
    {
        $this->month = RemoveXss($value);
        return $this;
    }

    public function getSqmCy(): string
    {
        return $this->sqmCy;
    }

    public function setSqmCy(string $value): static
    {
        $this->sqmCy = $value;
        return $this;
    }

    public function getAmountCy(): string
    {
        return HtmlDecode($this->amountCy);
    }

    public function setAmountCy(string $value): static
    {
        $this->amountCy = RemoveXss($value);
        return $this;
    }

    public function getSqmPy(): string
    {
        return $this->sqmPy;
    }

    public function setSqmPy(string $value): static
    {
        $this->sqmPy = $value;
        return $this;
    }

    public function getAmountPy(): string
    {
        return HtmlDecode($this->amountPy);
    }

    public function setAmountPy(string $value): static
    {
        $this->amountPy = RemoveXss($value);
        return $this;
    }

    public function getSqmBpy(): string
    {
        return $this->sqmBpy;
    }

    public function setSqmBpy(string $value): static
    {
        $this->sqmBpy = $value;
        return $this;
    }

    public function getAmountBpy(): string
    {
        return HtmlDecode($this->amountBpy);
    }

    public function setAmountBpy(string $value): static
    {
        $this->amountBpy = RemoveXss($value);
        return $this;
    }

    public function getSqmBbpy(): string
    {
        return $this->sqmBbpy;
    }

    public function setSqmBbpy(string $value): static
    {
        $this->sqmBbpy = $value;
        return $this;
    }

    public function getAmountBbpy(): string
    {
        return HtmlDecode($this->amountBbpy);
    }

    public function setAmountBbpy(string $value): static
    {
        $this->amountBbpy = RemoveXss($value);
        return $this;
    }
}
