<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "po_overall_compiled" table
 */
#[Entity]
#[Table(name: "po_overall_compiled")]
class PoOverallCompiled extends AbstractEntity
{
    #[Column(name: "buyer_id", type: "integer", nullable: true)]
    private ?int $buyerId;

    #[Column(name: "reports_to", type: "text", nullable: true)]
    private ?string $reportsTo;

    #[Column(type: "smallint")]
    private int $year;

    #[Column(type: "decimal", nullable: true)]
    private ?string $sqm;

    #[Column(type: "decimal", nullable: true)]
    private ?string $usd;

    #[Column(type: "decimal", nullable: true)]
    private ?string $euro;

    #[Column(type: "decimal", nullable: true)]
    private ?string $inr;

    public function getBuyerId(): ?int
    {
        return $this->buyerId;
    }

    public function setBuyerId(?int $value): static
    {
        $this->buyerId = $value;
        return $this;
    }

    public function getReportsTo(): ?string
    {
        return HtmlDecode($this->reportsTo);
    }

    public function setReportsTo(?string $value): static
    {
        $this->reportsTo = RemoveXss($value);
        return $this;
    }

    public function getYear(): int
    {
        return $this->year;
    }

    public function setYear(int $value): static
    {
        $this->year = $value;
        return $this;
    }

    public function getSqm(): ?string
    {
        return $this->sqm;
    }

    public function setSqm(?string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getUsd(): ?string
    {
        return $this->usd;
    }

    public function setUsd(?string $value): static
    {
        $this->usd = $value;
        return $this;
    }

    public function getEuro(): ?string
    {
        return $this->euro;
    }

    public function setEuro(?string $value): static
    {
        $this->euro = $value;
        return $this;
    }

    public function getInr(): ?string
    {
        return $this->inr;
    }

    public function setInr(?string $value): static
    {
        $this->inr = $value;
        return $this;
    }
}
