<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "po_overall" table
 */
#[Entity]
#[Table(name: "po_overall")]
class PoOverall extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "buyer_id", type: "integer", nullable: true)]
    private ?int $buyerId;

    #[Column(name: "reports_to", type: "smallint", nullable: true)]
    private ?int $reportsTo;

    #[Column(type: "smallint")]
    private int $year;

    #[Column(type: "smallint", nullable: true)]
    private ?int $month;

    #[Column(type: "decimal")]
    private string $sqm;

    #[Column(type: "decimal")]
    private string $usd;

    #[Column(type: "decimal")]
    private string $euro;

    #[Column(type: "decimal")]
    private string $inr;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "string", unique: true, nullable: true)]
    private ?string $uid;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getBuyerId(): ?int
    {
        return $this->buyerId;
    }

    public function setBuyerId(?int $value): static
    {
        $this->buyerId = $value;
        return $this;
    }

    public function getReportsTo(): ?int
    {
        return $this->reportsTo;
    }

    public function setReportsTo(?int $value): static
    {
        $this->reportsTo = $value;
        return $this;
    }

    public function getYear(): int
    {
        return $this->year;
    }

    public function setYear(int $value): static
    {
        $this->year = $value;
        return $this;
    }

    public function getMonth(): ?int
    {
        return $this->month;
    }

    public function setMonth(?int $value): static
    {
        $this->month = $value;
        return $this;
    }

    public function getSqm(): string
    {
        return $this->sqm;
    }

    public function setSqm(string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getUsd(): string
    {
        return $this->usd;
    }

    public function setUsd(string $value): static
    {
        $this->usd = $value;
        return $this;
    }

    public function getEuro(): string
    {
        return $this->euro;
    }

    public function setEuro(string $value): static
    {
        $this->euro = $value;
        return $this;
    }

    public function getInr(): string
    {
        return $this->inr;
    }

    public function setInr(string $value): static
    {
        $this->inr = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUid(): ?string
    {
        return HtmlDecode($this->uid);
    }

    public function setUid(?string $value): static
    {
        $this->uid = RemoveXss($value);
        return $this;
    }
}
