<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "po_b_auth" table
 */
#[Entity]
#[Table(name: "po_b_auth")]
class PoBAuth extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $po;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(name: "partner_id", type: "integer", nullable: true)]
    private ?int $partnerId;

    #[Column(type: "smallint", nullable: true)]
    private ?int $quantity;

    #[Column(type: "float")]
    private float $sqm;

    #[Column(type: "float")]
    private float $cbm;

    #[Column(type: "string")]
    private string $amount;

    #[Column(name: "e_mail", type: "integer")]
    private int $eMail;

    #[Column(name: "a_operator", type: "smallint", nullable: true)]
    private ?int $aOperator;

    #[Column(name: "a_datetime", type: "datetime", nullable: true)]
    private ?DateTime $aDatetime;

    #[Column(name: "app_operator", type: "smallint", nullable: true)]
    private ?int $appOperator;

    #[Column(name: "app_datetime", type: "datetime", nullable: true)]
    private ?DateTime $appDatetime;

    #[Column(type: "smallint")]
    private int $request;

    #[Column(name: "jc_no", type: "string", nullable: true)]
    private ?string $jcNo;

    #[Column(name: "reports_to", type: "string")]
    private string $reportsTo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    public function __construct()
    {
        $this->po = 0;
        $this->eMail = 0;
        $this->request = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPo(): int
    {
        return $this->po;
    }

    public function setPo(int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getPartnerId(): ?int
    {
        return $this->partnerId;
    }

    public function setPartnerId(?int $value): static
    {
        $this->partnerId = $value;
        return $this;
    }

    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    public function setQuantity(?int $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getSqm(): float
    {
        return $this->sqm;
    }

    public function setSqm(float $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getCbm(): float
    {
        return $this->cbm;
    }

    public function setCbm(float $value): static
    {
        $this->cbm = $value;
        return $this;
    }

    public function getAmount(): string
    {
        return HtmlDecode($this->amount);
    }

    public function setAmount(string $value): static
    {
        $this->amount = RemoveXss($value);
        return $this;
    }

    public function getEMail(): int
    {
        return $this->eMail;
    }

    public function setEMail(int $value): static
    {
        $this->eMail = $value;
        return $this;
    }

    public function getAOperator(): ?int
    {
        return $this->aOperator;
    }

    public function setAOperator(?int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getADatetime(): ?DateTime
    {
        return $this->aDatetime;
    }

    public function setADatetime(?DateTime $value): static
    {
        $this->aDatetime = $value;
        return $this;
    }

    public function getAppOperator(): ?int
    {
        return $this->appOperator;
    }

    public function setAppOperator(?int $value): static
    {
        $this->appOperator = $value;
        return $this;
    }

    public function getAppDatetime(): ?DateTime
    {
        return $this->appDatetime;
    }

    public function setAppDatetime(?DateTime $value): static
    {
        $this->appDatetime = $value;
        return $this;
    }

    public function getRequest(): int
    {
        return $this->request;
    }

    public function setRequest(int $value): static
    {
        $this->request = $value;
        return $this;
    }

    public function getJcNo(): ?string
    {
        return HtmlDecode($this->jcNo);
    }

    public function setJcNo(?string $value): static
    {
        $this->jcNo = RemoveXss($value);
        return $this;
    }

    public function getReportsTo(): string
    {
        return HtmlDecode($this->reportsTo);
    }

    public function setReportsTo(string $value): static
    {
        $this->reportsTo = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }
}
