<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "po_b" table
 */
#[Entity]
#[Table(name: "po_b")]
class PoB extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $location;

    #[Column(type: "string", nullable: true)]
    private ?string $grp;

    #[Column(type: "smallint", unique: true)]
    private int $po;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(name: "partner_id", type: "integer", nullable: true)]
    private ?int $partnerId;

    #[Column(name: "s_grp", type: "string", nullable: true)]
    private ?string $sGrp;

    #[Column(name: "cart_id", type: "text", nullable: true)]
    private ?string $cartId;

    #[Column(type: "smallint", nullable: true)]
    private ?int $quantity;

    #[Column(type: "float")]
    private float $sqm;

    #[Column(type: "string")]
    private string $amount;

    #[Column(type: "float")]
    private float $cbm;

    #[Column(type: "smallint")]
    private int $gst;

    #[Column(name: "partner_order_no", type: "string", nullable: true)]
    private ?string $partnerOrderNo;

    #[Column(name: "partner_order_date", type: "date", nullable: true)]
    private ?DateTime $partnerOrderDate;

    #[Column(name: "despatch_date", type: "date", nullable: true)]
    private ?DateTime $despatchDate;

    #[Column(name: "despatch_week", type: "smallint", nullable: true)]
    private ?int $despatchWeek;

    #[Column(name: "fob_date", type: "date", nullable: true)]
    private ?DateTime $fobDate;

    #[Column(name: "production_plan", type: "smallint", nullable: true)]
    private ?int $productionPlan;

    #[Column(name: "part_dispatch", type: "smallint", nullable: true)]
    private ?int $partDispatch;

    #[Column(name: "payment_terms", type: "string", nullable: true)]
    private ?string $paymentTerms;

    #[Column(name: "transport_type", type: "string", nullable: true)]
    private ?string $transportType;

    #[Column(name: "partner_shipping_id", type: "smallint", nullable: true)]
    private ?int $partnerShippingId;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "buyer_instruction", type: "string", nullable: true)]
    private ?string $buyerInstruction;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(name: "description_01", type: "float", nullable: true)]
    private ?float $description01;

    #[Column(name: "description_02", type: "float", nullable: true)]
    private ?float $description02;

    #[Column(name: "description_03", type: "float", nullable: true)]
    private ?float $description03;

    #[Column(name: "description_04", type: "float", nullable: true)]
    private ?float $description04;

    #[Column(name: "description_05", type: "smallint", nullable: true)]
    private ?int $description05;

    #[Column(name: "description_06", type: "smallint", nullable: true)]
    private ?int $description06;

    #[Column(name: "description_07", type: "smallint", nullable: true)]
    private ?int $description07;

    #[Column(name: "description_08", type: "smallint", nullable: true)]
    private ?int $description08;

    #[Column(name: "description_17", type: "float")]
    private float $description17;

    #[Column(name: "description_18", type: "float")]
    private float $description18;

    #[Column(name: "description_19", type: "float")]
    private float $description19;

    #[Column(name: "description_20", type: "smallint")]
    private int $description20;

    #[Column(name: "d_09_head", type: "smallint", nullable: true)]
    private ?int $d09Head;

    #[Column(name: "description_09", type: "string", nullable: true)]
    private ?string $description09;

    #[Column(name: "d_10_head", type: "smallint", nullable: true)]
    private ?int $d10Head;

    #[Column(name: "description_10", type: "string", nullable: true)]
    private ?string $description10;

    #[Column(name: "d_11_head", type: "smallint", nullable: true)]
    private ?int $d11Head;

    #[Column(name: "description_11", type: "string", nullable: true)]
    private ?string $description11;

    #[Column(name: "d_12_head", type: "smallint", nullable: true)]
    private ?int $d12Head;

    #[Column(name: "description_12", type: "string", nullable: true)]
    private ?string $description12;

    #[Column(name: "production_site", type: "smallint")]
    private int $productionSite;

    #[Column(name: "jc_no", type: "string", nullable: true)]
    private ?string $jcNo;

    #[Column(type: "smallint")]
    private int $request;

    #[Column(name: "balance_quantity", type: "decimal", nullable: true)]
    private ?string $balanceQuantity;

    #[Column(name: "e_mail", type: "integer")]
    private int $eMail;

    #[Column(name: "billing_address_id", type: "smallint", nullable: true)]
    private ?int $billingAddressId;

    #[Column(name: "shipping_address_id", type: "smallint", nullable: true)]
    private ?int $shippingAddressId;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "a_operator", type: "smallint", nullable: true)]
    private ?int $aOperator;

    #[Column(name: "a_datetime", type: "datetime", nullable: true)]
    private ?DateTime $aDatetime;

    #[Column(name: "c_operator", type: "smallint", nullable: true)]
    private ?int $cOperator;

    #[Column(name: "c_datetime", type: "datetime", nullable: true)]
    private ?DateTime $cDatetime;

    #[Column(name: "app_operator", type: "smallint", nullable: true)]
    private ?int $appOperator;

    #[Column(name: "app_datetime", type: "datetime", nullable: true)]
    private ?DateTime $appDatetime;

    #[Column(name: "reports_to", type: "string")]
    private string $reportsTo;

    #[Column(name: "grp_type", type: "smallint", nullable: true)]
    private ?int $grpType;

    #[Column(name: "order_file", type: "string", nullable: true)]
    private ?string $orderFile;

    public function __construct()
    {
        $this->location = 0;
        $this->grp = (isset($_GET["GRP"]))? $_GET["GRP"]:'';
        $this->po = 0;
        $this->companyId = (isset($_GET["CID"]))? $_GET["CID"]:User_Company_ID();
        $this->partnerId = (isset($_GET["PID"]))? $_GET["PID"]:'';
        $this->cartId = (isset($_GET["CAID"]))? $_GET["CAID"]:'';
        $this->gst = 1;
        $this->despatchWeek = date('W');
        $this->description03 = 1;
        $this->description04 = 0;
        $this->description20 = 1;
        $this->balanceQuantity = "0.00";
        $this->eMail = 0;
        $this->status = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLocation(): ?int
    {
        return $this->location;
    }

    public function setLocation(?int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getGrp(): ?string
    {
        return HtmlDecode($this->grp);
    }

    public function setGrp(?string $value): static
    {
        $this->grp = RemoveXss($value);
        return $this;
    }

    public function getPo(): int
    {
        return $this->po;
    }

    public function setPo(int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getPartnerId(): ?int
    {
        return $this->partnerId;
    }

    public function setPartnerId(?int $value): static
    {
        $this->partnerId = $value;
        return $this;
    }

    public function getSGrp(): ?string
    {
        return HtmlDecode($this->sGrp);
    }

    public function setSGrp(?string $value): static
    {
        $this->sGrp = RemoveXss($value);
        return $this;
    }

    public function getCartId(): ?string
    {
        return HtmlDecode($this->cartId);
    }

    public function setCartId(?string $value): static
    {
        $this->cartId = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    public function setQuantity(?int $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getSqm(): float
    {
        return $this->sqm;
    }

    public function setSqm(float $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getAmount(): string
    {
        return HtmlDecode($this->amount);
    }

    public function setAmount(string $value): static
    {
        $this->amount = RemoveXss($value);
        return $this;
    }

    public function getCbm(): float
    {
        return $this->cbm;
    }

    public function setCbm(float $value): static
    {
        $this->cbm = $value;
        return $this;
    }

    public function getGst(): int
    {
        return $this->gst;
    }

    public function setGst(int $value): static
    {
        $this->gst = $value;
        return $this;
    }

    public function getPartnerOrderNo(): ?string
    {
        return HtmlDecode($this->partnerOrderNo);
    }

    public function setPartnerOrderNo(?string $value): static
    {
        $this->partnerOrderNo = RemoveXss($value);
        return $this;
    }

    public function getPartnerOrderDate(): ?DateTime
    {
        return $this->partnerOrderDate;
    }

    public function setPartnerOrderDate(?DateTime $value): static
    {
        $this->partnerOrderDate = $value;
        return $this;
    }

    public function getDespatchDate(): ?DateTime
    {
        return $this->despatchDate;
    }

    public function setDespatchDate(?DateTime $value): static
    {
        $this->despatchDate = $value;
        return $this;
    }

    public function getDespatchWeek(): ?int
    {
        return $this->despatchWeek;
    }

    public function setDespatchWeek(?int $value): static
    {
        $this->despatchWeek = $value;
        return $this;
    }

    public function getFobDate(): ?DateTime
    {
        return $this->fobDate;
    }

    public function setFobDate(?DateTime $value): static
    {
        $this->fobDate = $value;
        return $this;
    }

    public function getProductionPlan(): ?int
    {
        return $this->productionPlan;
    }

    public function setProductionPlan(?int $value): static
    {
        $this->productionPlan = $value;
        return $this;
    }

    public function getPartDispatch(): ?int
    {
        return $this->partDispatch;
    }

    public function setPartDispatch(?int $value): static
    {
        $this->partDispatch = $value;
        return $this;
    }

    public function getPaymentTerms(): ?string
    {
        return HtmlDecode($this->paymentTerms);
    }

    public function setPaymentTerms(?string $value): static
    {
        $this->paymentTerms = RemoveXss($value);
        return $this;
    }

    public function getTransportType(): ?string
    {
        return HtmlDecode($this->transportType);
    }

    public function setTransportType(?string $value): static
    {
        $this->transportType = RemoveXss($value);
        return $this;
    }

    public function getPartnerShippingId(): ?int
    {
        return $this->partnerShippingId;
    }

    public function setPartnerShippingId(?int $value): static
    {
        $this->partnerShippingId = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getBuyerInstruction(): ?string
    {
        return HtmlDecode($this->buyerInstruction);
    }

    public function setBuyerInstruction(?string $value): static
    {
        $this->buyerInstruction = RemoveXss($value);
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getDescription01(): ?float
    {
        return $this->description01;
    }

    public function setDescription01(?float $value): static
    {
        $this->description01 = $value;
        return $this;
    }

    public function getDescription02(): ?float
    {
        return $this->description02;
    }

    public function setDescription02(?float $value): static
    {
        $this->description02 = $value;
        return $this;
    }

    public function getDescription03(): ?float
    {
        return $this->description03;
    }

    public function setDescription03(?float $value): static
    {
        $this->description03 = $value;
        return $this;
    }

    public function getDescription04(): ?float
    {
        return $this->description04;
    }

    public function setDescription04(?float $value): static
    {
        $this->description04 = $value;
        return $this;
    }

    public function getDescription05(): ?int
    {
        return $this->description05;
    }

    public function setDescription05(?int $value): static
    {
        $this->description05 = $value;
        return $this;
    }

    public function getDescription06(): ?int
    {
        return $this->description06;
    }

    public function setDescription06(?int $value): static
    {
        $this->description06 = $value;
        return $this;
    }

    public function getDescription07(): ?int
    {
        return $this->description07;
    }

    public function setDescription07(?int $value): static
    {
        $this->description07 = $value;
        return $this;
    }

    public function getDescription08(): ?int
    {
        return $this->description08;
    }

    public function setDescription08(?int $value): static
    {
        $this->description08 = $value;
        return $this;
    }

    public function getDescription17(): float
    {
        return $this->description17;
    }

    public function setDescription17(float $value): static
    {
        $this->description17 = $value;
        return $this;
    }

    public function getDescription18(): float
    {
        return $this->description18;
    }

    public function setDescription18(float $value): static
    {
        $this->description18 = $value;
        return $this;
    }

    public function getDescription19(): float
    {
        return $this->description19;
    }

    public function setDescription19(float $value): static
    {
        $this->description19 = $value;
        return $this;
    }

    public function getDescription20(): int
    {
        return $this->description20;
    }

    public function setDescription20(int $value): static
    {
        $this->description20 = $value;
        return $this;
    }

    public function getD09Head(): ?int
    {
        return $this->d09Head;
    }

    public function setD09Head(?int $value): static
    {
        $this->d09Head = $value;
        return $this;
    }

    public function getDescription09(): ?string
    {
        return HtmlDecode($this->description09);
    }

    public function setDescription09(?string $value): static
    {
        $this->description09 = RemoveXss($value);
        return $this;
    }

    public function getD10Head(): ?int
    {
        return $this->d10Head;
    }

    public function setD10Head(?int $value): static
    {
        $this->d10Head = $value;
        return $this;
    }

    public function getDescription10(): ?string
    {
        return HtmlDecode($this->description10);
    }

    public function setDescription10(?string $value): static
    {
        $this->description10 = RemoveXss($value);
        return $this;
    }

    public function getD11Head(): ?int
    {
        return $this->d11Head;
    }

    public function setD11Head(?int $value): static
    {
        $this->d11Head = $value;
        return $this;
    }

    public function getDescription11(): ?string
    {
        return HtmlDecode($this->description11);
    }

    public function setDescription11(?string $value): static
    {
        $this->description11 = RemoveXss($value);
        return $this;
    }

    public function getD12Head(): ?int
    {
        return $this->d12Head;
    }

    public function setD12Head(?int $value): static
    {
        $this->d12Head = $value;
        return $this;
    }

    public function getDescription12(): ?string
    {
        return HtmlDecode($this->description12);
    }

    public function setDescription12(?string $value): static
    {
        $this->description12 = RemoveXss($value);
        return $this;
    }

    public function getProductionSite(): int
    {
        return $this->productionSite;
    }

    public function setProductionSite(int $value): static
    {
        $this->productionSite = $value;
        return $this;
    }

    public function getJcNo(): ?string
    {
        return HtmlDecode($this->jcNo);
    }

    public function setJcNo(?string $value): static
    {
        $this->jcNo = RemoveXss($value);
        return $this;
    }

    public function getRequest(): int
    {
        return $this->request;
    }

    public function setRequest(int $value): static
    {
        $this->request = $value;
        return $this;
    }

    public function getBalanceQuantity(): ?string
    {
        return $this->balanceQuantity;
    }

    public function setBalanceQuantity(?string $value): static
    {
        $this->balanceQuantity = $value;
        return $this;
    }

    public function getEMail(): int
    {
        return $this->eMail;
    }

    public function setEMail(int $value): static
    {
        $this->eMail = $value;
        return $this;
    }

    public function getBillingAddressId(): ?int
    {
        return $this->billingAddressId;
    }

    public function setBillingAddressId(?int $value): static
    {
        $this->billingAddressId = $value;
        return $this;
    }

    public function getShippingAddressId(): ?int
    {
        return $this->shippingAddressId;
    }

    public function setShippingAddressId(?int $value): static
    {
        $this->shippingAddressId = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getAOperator(): ?int
    {
        return $this->aOperator;
    }

    public function setAOperator(?int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getADatetime(): ?DateTime
    {
        return $this->aDatetime;
    }

    public function setADatetime(?DateTime $value): static
    {
        $this->aDatetime = $value;
        return $this;
    }

    public function getCOperator(): ?int
    {
        return $this->cOperator;
    }

    public function setCOperator(?int $value): static
    {
        $this->cOperator = $value;
        return $this;
    }

    public function getCDatetime(): ?DateTime
    {
        return $this->cDatetime;
    }

    public function setCDatetime(?DateTime $value): static
    {
        $this->cDatetime = $value;
        return $this;
    }

    public function getAppOperator(): ?int
    {
        return $this->appOperator;
    }

    public function setAppOperator(?int $value): static
    {
        $this->appOperator = $value;
        return $this;
    }

    public function getAppDatetime(): ?DateTime
    {
        return $this->appDatetime;
    }

    public function setAppDatetime(?DateTime $value): static
    {
        $this->appDatetime = $value;
        return $this;
    }

    public function getReportsTo(): string
    {
        return HtmlDecode($this->reportsTo);
    }

    public function setReportsTo(string $value): static
    {
        $this->reportsTo = RemoveXss($value);
        return $this;
    }

    public function getGrpType(): ?int
    {
        return $this->grpType;
    }

    public function setGrpType(?int $value): static
    {
        $this->grpType = $value;
        return $this;
    }

    public function getOrderFile(): ?string
    {
        return HtmlDecode($this->orderFile);
    }

    public function setOrderFile(?string $value): static
    {
        $this->orderFile = RemoveXss($value);
        return $this;
    }
}
