<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "pl_setup" table
 */
#[Entity]
#[Table(name: "pl_setup")]
class PlSetup extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    private int $id;

    #[Column(name: "pl_no", type: "decimal", nullable: true)]
    private ?string $plNo;

    #[Column(name: "pl_refresh", type: "smallint")]
    private int $plRefresh;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "upl_so", type: "string", nullable: true)]
    private ?string $uplSo;

    public function __construct()
    {
        $this->plRefresh = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPlNo(): ?string
    {
        return $this->plNo;
    }

    public function setPlNo(?string $value): static
    {
        $this->plNo = $value;
        return $this;
    }

    public function getPlRefresh(): int
    {
        return $this->plRefresh;
    }

    public function setPlRefresh(int $value): static
    {
        $this->plRefresh = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUplSo(): ?string
    {
        return HtmlDecode($this->uplSo);
    }

    public function setUplSo(?string $value): static
    {
        $this->uplSo = RemoveXss($value);
        return $this;
    }
}
