<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "personal_info" table
 */
#[Entity]
#[Table(name: "personal_info")]
class PersonalInfo extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "formal_name", type: "string", nullable: true)]
    private ?string $formalName;

    #[Column(type: "integer", nullable: true)]
    private ?int $gender;

    #[Column(type: "bigint", nullable: true)]
    private ?string $mobile;

    #[Column(type: "string", nullable: true)]
    private ?string $email;

    #[Column(type: "string", nullable: true)]
    private ?string $address;

    #[Column(type: "smallint", nullable: true)]
    private ?int $country;

    #[Column(type: "smallint", nullable: true)]
    private ?int $state;

    #[Column(type: "smallint", nullable: true)]
    private ?int $city;

    #[Column(name: "city_name", type: "string", nullable: true)]
    private ?string $cityName;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dob;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dom;

    #[Column(name: "marital_status", type: "smallint", nullable: true)]
    private ?int $maritalStatus;

    #[Column(name: "spouse_details", type: "string", nullable: true)]
    private ?string $spouseDetails;

    #[Column(type: "string", nullable: true)]
    private ?string $image;

    #[Column(name: "father_name", type: "string", nullable: true)]
    private ?string $fatherName;

    #[Column(name: "mother_name", type: "string", nullable: true)]
    private ?string $motherName;

    #[Column(name: "permanent_address", type: "string", nullable: true)]
    private ?string $permanentAddress;

    #[Column(name: "mobile_other", type: "string", nullable: true)]
    private ?string $mobileOther;

    #[Column(name: "mobile_family", type: "string", nullable: true)]
    private ?string $mobileFamily;

    #[Column(name: "emergency_details", type: "string", nullable: true)]
    private ?string $emergencyDetails;

    #[Column(name: "annual_income", type: "integer", nullable: true)]
    private ?int $annualIncome;

    #[Column(name: "work_details", type: "string", nullable: true)]
    private ?string $workDetails;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "string", nullable: true)]
    private ?string $gst;

    #[Column(name: "aadhaar_no", type: "string", nullable: true)]
    private ?string $aadhaarNo;

    #[Column(name: "pan_no", type: "string", nullable: true)]
    private ?string $panNo;

    #[Column(name: "id_proof", type: "string", nullable: true)]
    private ?string $idProof;

    #[Column(name: "reference_details", type: "string", nullable: true)]
    private ?string $referenceDetails;

    #[Column(name: "other_details", type: "text", nullable: true)]
    private ?string $otherDetails;

    #[Column(name: "bank_name", type: "string", nullable: true)]
    private ?string $bankName;

    #[Column(name: "bank_ifsc_code", type: "string", nullable: true)]
    private ?string $bankIfscCode;

    #[Column(name: "bank_account_no", type: "string", nullable: true)]
    private ?string $bankAccountNo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->id = 0;
        $this->annualIncome = 0;
        $this->status = 1;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getFormalName(): ?string
    {
        return HtmlDecode($this->formalName);
    }

    public function setFormalName(?string $value): static
    {
        $this->formalName = RemoveXss($value);
        return $this;
    }

    public function getGender(): ?int
    {
        return $this->gender;
    }

    public function setGender(?int $value): static
    {
        $this->gender = $value;
        return $this;
    }

    public function getMobile(): ?string
    {
        return $this->mobile;
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = $value;
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getAddress(): ?string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(?string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getCountry(): ?int
    {
        return $this->country;
    }

    public function setCountry(?int $value): static
    {
        $this->country = $value;
        return $this;
    }

    public function getState(): ?int
    {
        return $this->state;
    }

    public function setState(?int $value): static
    {
        $this->state = $value;
        return $this;
    }

    public function getCity(): ?int
    {
        return $this->city;
    }

    public function setCity(?int $value): static
    {
        $this->city = $value;
        return $this;
    }

    public function getCityName(): ?string
    {
        return HtmlDecode($this->cityName);
    }

    public function setCityName(?string $value): static
    {
        $this->cityName = RemoveXss($value);
        return $this;
    }

    public function getDob(): ?DateTime
    {
        return $this->dob;
    }

    public function setDob(?DateTime $value): static
    {
        $this->dob = $value;
        return $this;
    }

    public function getDom(): ?DateTime
    {
        return $this->dom;
    }

    public function setDom(?DateTime $value): static
    {
        $this->dom = $value;
        return $this;
    }

    public function getMaritalStatus(): ?int
    {
        return $this->maritalStatus;
    }

    public function setMaritalStatus(?int $value): static
    {
        $this->maritalStatus = $value;
        return $this;
    }

    public function getSpouseDetails(): ?string
    {
        return HtmlDecode($this->spouseDetails);
    }

    public function setSpouseDetails(?string $value): static
    {
        $this->spouseDetails = RemoveXss($value);
        return $this;
    }

    public function getImage(): ?string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(?string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getFatherName(): ?string
    {
        return HtmlDecode($this->fatherName);
    }

    public function setFatherName(?string $value): static
    {
        $this->fatherName = RemoveXss($value);
        return $this;
    }

    public function getMotherName(): ?string
    {
        return HtmlDecode($this->motherName);
    }

    public function setMotherName(?string $value): static
    {
        $this->motherName = RemoveXss($value);
        return $this;
    }

    public function getPermanentAddress(): ?string
    {
        return HtmlDecode($this->permanentAddress);
    }

    public function setPermanentAddress(?string $value): static
    {
        $this->permanentAddress = RemoveXss($value);
        return $this;
    }

    public function getMobileOther(): ?string
    {
        return HtmlDecode($this->mobileOther);
    }

    public function setMobileOther(?string $value): static
    {
        $this->mobileOther = RemoveXss($value);
        return $this;
    }

    public function getMobileFamily(): ?string
    {
        return HtmlDecode($this->mobileFamily);
    }

    public function setMobileFamily(?string $value): static
    {
        $this->mobileFamily = RemoveXss($value);
        return $this;
    }

    public function getEmergencyDetails(): ?string
    {
        return HtmlDecode($this->emergencyDetails);
    }

    public function setEmergencyDetails(?string $value): static
    {
        $this->emergencyDetails = RemoveXss($value);
        return $this;
    }

    public function getAnnualIncome(): ?int
    {
        return $this->annualIncome;
    }

    public function setAnnualIncome(?int $value): static
    {
        $this->annualIncome = $value;
        return $this;
    }

    public function getWorkDetails(): ?string
    {
        return HtmlDecode($this->workDetails);
    }

    public function setWorkDetails(?string $value): static
    {
        $this->workDetails = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getGst(): ?string
    {
        return HtmlDecode($this->gst);
    }

    public function setGst(?string $value): static
    {
        $this->gst = RemoveXss($value);
        return $this;
    }

    public function getAadhaarNo(): ?string
    {
        return HtmlDecode($this->aadhaarNo);
    }

    public function setAadhaarNo(?string $value): static
    {
        $this->aadhaarNo = RemoveXss($value);
        return $this;
    }

    public function getPanNo(): ?string
    {
        return HtmlDecode($this->panNo);
    }

    public function setPanNo(?string $value): static
    {
        $this->panNo = RemoveXss($value);
        return $this;
    }

    public function getIdProof(): ?string
    {
        return HtmlDecode($this->idProof);
    }

    public function setIdProof(?string $value): static
    {
        $this->idProof = RemoveXss($value);
        return $this;
    }

    public function getReferenceDetails(): ?string
    {
        return HtmlDecode($this->referenceDetails);
    }

    public function setReferenceDetails(?string $value): static
    {
        $this->referenceDetails = RemoveXss($value);
        return $this;
    }

    public function getOtherDetails(): ?string
    {
        return HtmlDecode($this->otherDetails);
    }

    public function setOtherDetails(?string $value): static
    {
        $this->otherDetails = RemoveXss($value);
        return $this;
    }

    public function getBankName(): ?string
    {
        return HtmlDecode($this->bankName);
    }

    public function setBankName(?string $value): static
    {
        $this->bankName = RemoveXss($value);
        return $this;
    }

    public function getBankIfscCode(): ?string
    {
        return HtmlDecode($this->bankIfscCode);
    }

    public function setBankIfscCode(?string $value): static
    {
        $this->bankIfscCode = RemoveXss($value);
        return $this;
    }

    public function getBankAccountNo(): ?string
    {
        return HtmlDecode($this->bankAccountNo);
    }

    public function setBankAccountNo(?string $value): static
    {
        $this->bankAccountNo = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
