<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "payroll_time_log" table
 */
#[Entity]
#[Table(name: "payroll_time_log")]
class PayrollTimeLog extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "employee_id", type: "integer")]
    private int $employeeId;

    #[Column(type: "date")]
    private DateTime $dated;

    #[Column(name: "in_time", type: "datetime")]
    private DateTime $inTime;

    #[Column(name: "out_time", type: "datetime")]
    private DateTime $outTime;

    #[Column(type: "smallint", nullable: true)]
    private ?int $minutes;

    #[Column(name: "late_arrival", type: "smallint", nullable: true)]
    private ?int $lateArrival;

    #[Column(name: "early_departure", type: "smallint", nullable: true)]
    private ?int $earlyDeparture;

    #[Column(type: "smallint")]
    private int $overtime;

    #[Column(name: "`break duration`", options: ["name" => "break duration"], type: "smallint")]
    private int $breakduration;

    #[Column(name: "employee_am_id", type: "smallint")]
    private int $employeeAmId;

    #[Column(name: "offset_consumed", type: "smallint")]
    private int $offsetConsumed;

    #[Column(name: "c_offset", type: "smallint")]
    private int $cOffset;

    #[Column(type: "smallint")]
    private int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "string", unique: true)]
    private string $uid;

    public function __construct()
    {
        $this->breakduration = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getEmployeeId(): int
    {
        return $this->employeeId;
    }

    public function setEmployeeId(int $value): static
    {
        $this->employeeId = $value;
        return $this;
    }

    public function getDated(): DateTime
    {
        return $this->dated;
    }

    public function setDated(DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getInTime(): DateTime
    {
        return $this->inTime;
    }

    public function setInTime(DateTime $value): static
    {
        $this->inTime = $value;
        return $this;
    }

    public function getOutTime(): DateTime
    {
        return $this->outTime;
    }

    public function setOutTime(DateTime $value): static
    {
        $this->outTime = $value;
        return $this;
    }

    public function getMinutes(): ?int
    {
        return $this->minutes;
    }

    public function setMinutes(?int $value): static
    {
        $this->minutes = $value;
        return $this;
    }

    public function getLateArrival(): ?int
    {
        return $this->lateArrival;
    }

    public function setLateArrival(?int $value): static
    {
        $this->lateArrival = $value;
        return $this;
    }

    public function getEarlyDeparture(): ?int
    {
        return $this->earlyDeparture;
    }

    public function setEarlyDeparture(?int $value): static
    {
        $this->earlyDeparture = $value;
        return $this;
    }

    public function getOvertime(): int
    {
        return $this->overtime;
    }

    public function setOvertime(int $value): static
    {
        $this->overtime = $value;
        return $this;
    }

    public function getBreakduration(): int
    {
        return $this->breakduration;
    }

    public function setBreakduration(int $value): static
    {
        $this->breakduration = $value;
        return $this;
    }

    public function getEmployeeAmId(): int
    {
        return $this->employeeAmId;
    }

    public function setEmployeeAmId(int $value): static
    {
        $this->employeeAmId = $value;
        return $this;
    }

    public function getOffsetConsumed(): int
    {
        return $this->offsetConsumed;
    }

    public function setOffsetConsumed(int $value): static
    {
        $this->offsetConsumed = $value;
        return $this;
    }

    public function getCOffset(): int
    {
        return $this->cOffset;
    }

    public function setCOffset(int $value): static
    {
        $this->cOffset = $value;
        return $this;
    }

    public function getOperator(): int
    {
        return $this->operator;
    }

    public function setOperator(int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUid(): string
    {
        return HtmlDecode($this->uid);
    }

    public function setUid(string $value): static
    {
        $this->uid = RemoveXss($value);
        return $this;
    }
}
