<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "payroll_machine_log" table
 */
#[Entity]
#[Table(name: "payroll_machine_log")]
class PayrollMachineLog extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "data_type", type: "integer")]
    private int $dataType;

    #[Column(name: "employee_id", type: "integer", nullable: true)]
    private ?int $employeeId;

    #[Column(name: "employee_am_id", type: "smallint", nullable: true)]
    private ?int $employeeAmId;

    #[Column(name: "in_time", type: "datetime", nullable: true)]
    private ?DateTime $inTime;

    #[Column(name: "out_time", type: "datetime", nullable: true)]
    private ?DateTime $outTime;

    #[Column(name: "s_time", type: "datetime", nullable: true)]
    private ?DateTime $sTime;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "in_time_unix", type: "integer", nullable: true)]
    private ?int $inTimeUnix;

    #[Column(name: "out_time_unix", type: "integer", nullable: true)]
    private ?int $outTimeUnix;

    #[Column(name: "s_time_unix", type: "integer", nullable: true)]
    private ?int $sTimeUnix;

    public function __construct()
    {
        $this->dataType = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getDataType(): int
    {
        return $this->dataType;
    }

    public function setDataType(int $value): static
    {
        $this->dataType = $value;
        return $this;
    }

    public function getEmployeeId(): ?int
    {
        return $this->employeeId;
    }

    public function setEmployeeId(?int $value): static
    {
        $this->employeeId = $value;
        return $this;
    }

    public function getEmployeeAmId(): ?int
    {
        return $this->employeeAmId;
    }

    public function setEmployeeAmId(?int $value): static
    {
        $this->employeeAmId = $value;
        return $this;
    }

    public function getInTime(): ?DateTime
    {
        return $this->inTime;
    }

    public function setInTime(?DateTime $value): static
    {
        $this->inTime = $value;
        return $this;
    }

    public function getOutTime(): ?DateTime
    {
        return $this->outTime;
    }

    public function setOutTime(?DateTime $value): static
    {
        $this->outTime = $value;
        return $this;
    }

    public function getSTime(): ?DateTime
    {
        return $this->sTime;
    }

    public function setSTime(?DateTime $value): static
    {
        $this->sTime = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getInTimeUnix(): ?int
    {
        return $this->inTimeUnix;
    }

    public function setInTimeUnix(?int $value): static
    {
        $this->inTimeUnix = $value;
        return $this;
    }

    public function getOutTimeUnix(): ?int
    {
        return $this->outTimeUnix;
    }

    public function setOutTimeUnix(?int $value): static
    {
        $this->outTimeUnix = $value;
        return $this;
    }

    public function getSTimeUnix(): ?int
    {
        return $this->sTimeUnix;
    }

    public function setSTimeUnix(?int $value): static
    {
        $this->sTimeUnix = $value;
        return $this;
    }
}
