<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "payroll_fix_details" table
 */
#[Entity]
#[Table(name: "payroll_fix_details")]
class PayrollFixDetail extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "employee_id", type: "integer")]
    private int $employeeId;

    #[Column(name: "employee_am_id", type: "smallint", nullable: true)]
    private ?int $employeeAmId;

    #[Column(name: "job_title", type: "string")]
    private string $jobTitle;

    #[Column(name: "daily_in", type: "time")]
    private DateTime $dailyIn;

    #[Column(name: "daily_out", type: "time")]
    private DateTime $dailyOut;

    #[Column(name: "lunch_break_min", type: "smallint")]
    private int $lunchBreakMin;

    #[Column(name: "daily_min", type: "smallint")]
    private int $dailyMin;

    #[Column(name: "weekly_off", type: "string")]
    private string $weeklyOff;

    #[Column(name: "offsets_benifit_min", type: "smallint")]
    private int $offsetsBenifitMin;

    #[Column(name: "next_increment", type: "date")]
    private DateTime $nextIncrement;

    #[Column(name: "current_payroll_startdate", type: "date")]
    private DateTime $currentPayrollStartdate;

    #[Column(name: "base_salary", type: "decimal")]
    private string $baseSalary;

    #[Column(name: "additional_benefits", type: "string", nullable: true)]
    private ?string $additionalBenefits;

    #[Column(name: "extra_min_plan", type: "smallint")]
    private int $extraMinPlan;

    #[Column(name: "office_holidays", type: "integer")]
    private int $officeHolidays;

    #[Column(name: "paid_annual_leave", type: "integer")]
    private int $paidAnnualLeave;

    #[Column(name: "employee_pf", type: "smallint")]
    private int $employeePf;

    #[Column(name: "calculation_plan", type: "smallint")]
    private int $calculationPlan;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint")]
    private int $status;

    #[Column(type: "smallint")]
    private int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "month_min", type: "smallint", nullable: true)]
    private ?int $monthMin;

    public function __construct()
    {
        $this->calculationPlan = 0;
        $this->status = 1;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getEmployeeId(): int
    {
        return $this->employeeId;
    }

    public function setEmployeeId(int $value): static
    {
        $this->employeeId = $value;
        return $this;
    }

    public function getEmployeeAmId(): ?int
    {
        return $this->employeeAmId;
    }

    public function setEmployeeAmId(?int $value): static
    {
        $this->employeeAmId = $value;
        return $this;
    }

    public function getJobTitle(): string
    {
        return HtmlDecode($this->jobTitle);
    }

    public function setJobTitle(string $value): static
    {
        $this->jobTitle = RemoveXss($value);
        return $this;
    }

    public function getDailyIn(): DateTime
    {
        return $this->dailyIn;
    }

    public function setDailyIn(DateTime $value): static
    {
        $this->dailyIn = $value;
        return $this;
    }

    public function getDailyOut(): DateTime
    {
        return $this->dailyOut;
    }

    public function setDailyOut(DateTime $value): static
    {
        $this->dailyOut = $value;
        return $this;
    }

    public function getLunchBreakMin(): int
    {
        return $this->lunchBreakMin;
    }

    public function setLunchBreakMin(int $value): static
    {
        $this->lunchBreakMin = $value;
        return $this;
    }

    public function getDailyMin(): int
    {
        return $this->dailyMin;
    }

    public function setDailyMin(int $value): static
    {
        $this->dailyMin = $value;
        return $this;
    }

    public function getWeeklyOff(): string
    {
        return HtmlDecode($this->weeklyOff);
    }

    public function setWeeklyOff(string $value): static
    {
        $this->weeklyOff = RemoveXss($value);
        return $this;
    }

    public function getOffsetsBenifitMin(): int
    {
        return $this->offsetsBenifitMin;
    }

    public function setOffsetsBenifitMin(int $value): static
    {
        $this->offsetsBenifitMin = $value;
        return $this;
    }

    public function getNextIncrement(): DateTime
    {
        return $this->nextIncrement;
    }

    public function setNextIncrement(DateTime $value): static
    {
        $this->nextIncrement = $value;
        return $this;
    }

    public function getCurrentPayrollStartdate(): DateTime
    {
        return $this->currentPayrollStartdate;
    }

    public function setCurrentPayrollStartdate(DateTime $value): static
    {
        $this->currentPayrollStartdate = $value;
        return $this;
    }

    public function getBaseSalary(): string
    {
        return $this->baseSalary;
    }

    public function setBaseSalary(string $value): static
    {
        $this->baseSalary = $value;
        return $this;
    }

    public function getAdditionalBenefits(): ?string
    {
        return HtmlDecode($this->additionalBenefits);
    }

    public function setAdditionalBenefits(?string $value): static
    {
        $this->additionalBenefits = RemoveXss($value);
        return $this;
    }

    public function getExtraMinPlan(): int
    {
        return $this->extraMinPlan;
    }

    public function setExtraMinPlan(int $value): static
    {
        $this->extraMinPlan = $value;
        return $this;
    }

    public function getOfficeHolidays(): int
    {
        return $this->officeHolidays;
    }

    public function setOfficeHolidays(int $value): static
    {
        $this->officeHolidays = $value;
        return $this;
    }

    public function getPaidAnnualLeave(): int
    {
        return $this->paidAnnualLeave;
    }

    public function setPaidAnnualLeave(int $value): static
    {
        $this->paidAnnualLeave = $value;
        return $this;
    }

    public function getEmployeePf(): int
    {
        return $this->employeePf;
    }

    public function setEmployeePf(int $value): static
    {
        $this->employeePf = $value;
        return $this;
    }

    public function getCalculationPlan(): int
    {
        return $this->calculationPlan;
    }

    public function setCalculationPlan(int $value): static
    {
        $this->calculationPlan = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): int
    {
        return $this->operator;
    }

    public function setOperator(int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getMonthMin(): ?int
    {
        return $this->monthMin;
    }

    public function setMonthMin(?int $value): static
    {
        $this->monthMin = $value;
        return $this;
    }
}
