<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "payroll_details" table
 */
#[Entity]
#[Table(name: "payroll_details")]
class PayrollDetail extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "employee_id", type: "integer")]
    private int $employeeId;

    #[Column(type: "smallint")]
    private int $month;

    #[Column(name: "default_min", type: "smallint")]
    private int $defaultMin;

    #[Column(name: "month_min", type: "smallint")]
    private int $monthMin;

    #[Column(name: "offsets_benifit_min", type: "smallint")]
    private int $offsetsBenifitMin;

    #[Column(name: "office_holidays_min", type: "smallint")]
    private int $officeHolidaysMin;

    #[Column(name: "paid_leave_adj_min", type: "smallint")]
    private int $paidLeaveAdjMin;

    #[Column(name: "weekly_off_min", type: "string")]
    private string $weeklyOffMin;

    #[Column(type: "smallint")]
    private int $overtime;

    #[Column(name: "total_min", type: "smallint")]
    private int $totalMin;

    #[Column(type: "string")]
    private string $remarks;

    #[Column(name: "base_salary", type: "decimal")]
    private string $baseSalary;

    #[Column(name: "additional_benefits", type: "string")]
    private string $additionalBenefits;

    #[Column(name: "employee_pf", type: "smallint")]
    private int $employeePf;

    #[Column(type: "smallint")]
    private int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "employee_am_id", type: "smallint")]
    private int $employeeAmId;

    #[Column(name: "salary_earned", type: "decimal", nullable: true)]
    private ?string $salaryEarned;

    #[Column(type: "string", unique: true)]
    private string $uid;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getEmployeeId(): int
    {
        return $this->employeeId;
    }

    public function setEmployeeId(int $value): static
    {
        $this->employeeId = $value;
        return $this;
    }

    public function getMonth(): int
    {
        return $this->month;
    }

    public function setMonth(int $value): static
    {
        $this->month = $value;
        return $this;
    }

    public function getDefaultMin(): int
    {
        return $this->defaultMin;
    }

    public function setDefaultMin(int $value): static
    {
        $this->defaultMin = $value;
        return $this;
    }

    public function getMonthMin(): int
    {
        return $this->monthMin;
    }

    public function setMonthMin(int $value): static
    {
        $this->monthMin = $value;
        return $this;
    }

    public function getOffsetsBenifitMin(): int
    {
        return $this->offsetsBenifitMin;
    }

    public function setOffsetsBenifitMin(int $value): static
    {
        $this->offsetsBenifitMin = $value;
        return $this;
    }

    public function getOfficeHolidaysMin(): int
    {
        return $this->officeHolidaysMin;
    }

    public function setOfficeHolidaysMin(int $value): static
    {
        $this->officeHolidaysMin = $value;
        return $this;
    }

    public function getPaidLeaveAdjMin(): int
    {
        return $this->paidLeaveAdjMin;
    }

    public function setPaidLeaveAdjMin(int $value): static
    {
        $this->paidLeaveAdjMin = $value;
        return $this;
    }

    public function getWeeklyOffMin(): string
    {
        return HtmlDecode($this->weeklyOffMin);
    }

    public function setWeeklyOffMin(string $value): static
    {
        $this->weeklyOffMin = RemoveXss($value);
        return $this;
    }

    public function getOvertime(): int
    {
        return $this->overtime;
    }

    public function setOvertime(int $value): static
    {
        $this->overtime = $value;
        return $this;
    }

    public function getTotalMin(): int
    {
        return $this->totalMin;
    }

    public function setTotalMin(int $value): static
    {
        $this->totalMin = $value;
        return $this;
    }

    public function getRemarks(): string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getBaseSalary(): string
    {
        return $this->baseSalary;
    }

    public function setBaseSalary(string $value): static
    {
        $this->baseSalary = $value;
        return $this;
    }

    public function getAdditionalBenefits(): string
    {
        return HtmlDecode($this->additionalBenefits);
    }

    public function setAdditionalBenefits(string $value): static
    {
        $this->additionalBenefits = RemoveXss($value);
        return $this;
    }

    public function getEmployeePf(): int
    {
        return $this->employeePf;
    }

    public function setEmployeePf(int $value): static
    {
        $this->employeePf = $value;
        return $this;
    }

    public function getOperator(): int
    {
        return $this->operator;
    }

    public function setOperator(int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getEmployeeAmId(): int
    {
        return $this->employeeAmId;
    }

    public function setEmployeeAmId(int $value): static
    {
        $this->employeeAmId = $value;
        return $this;
    }

    public function getSalaryEarned(): ?string
    {
        return $this->salaryEarned;
    }

    public function setSalaryEarned(?string $value): static
    {
        $this->salaryEarned = $value;
        return $this;
    }

    public function getUid(): string
    {
        return HtmlDecode($this->uid);
    }

    public function setUid(string $value): static
    {
        $this->uid = RemoveXss($value);
        return $this;
    }
}
