<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "payment_response" table
 */
#[Entity]
#[Table(name: "payment_response")]
class PaymentResponse extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer")]
    private int $type;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "smallint")]
    private int $userid;

    #[Column(name: "pg_order_number", type: "string", unique: true)]
    private string $pgOrderNumber;

    #[Column(type: "string")]
    private string $remarks;

    #[Column(name: "cart_number", type: "integer")]
    private int $cartNumber;

    #[Column(name: "order_id", type: "smallint")]
    private int $orderId;

    #[Column(name: "tracking_id", type: "string")]
    private string $trackingId;

    #[Column(name: "bank_ref_no", type: "string")]
    private string $bankRefNo;

    #[Column(name: "order_status", type: "string")]
    private string $orderStatus;

    #[Column(name: "failure_message", type: "string")]
    private string $failureMessage;

    #[Column(name: "payment_mode", type: "string")]
    private string $paymentMode;

    #[Column(name: "card_name", type: "string")]
    private string $cardName;

    #[Column(name: "status_code", type: "string")]
    private string $statusCode;

    #[Column(name: "status_message", type: "string")]
    private string $statusMessage;

    #[Column(type: "float", nullable: true)]
    private ?float $amount;

    #[Column(name: "trans_date", type: "string")]
    private string $transDate;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "payment_gateway", type: "string")]
    private string $paymentGateway;

    #[Column(name: "payment_signature", type: "string")]
    private string $paymentSignature;

    #[Column(name: "currency_id", type: "integer")]
    private int $currencyId;

    public function __construct()
    {
        $this->status = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getUserid(): int
    {
        return $this->userid;
    }

    public function setUserid(int $value): static
    {
        $this->userid = $value;
        return $this;
    }

    public function getPgOrderNumber(): string
    {
        return HtmlDecode($this->pgOrderNumber);
    }

    public function setPgOrderNumber(string $value): static
    {
        $this->pgOrderNumber = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getCartNumber(): int
    {
        return $this->cartNumber;
    }

    public function setCartNumber(int $value): static
    {
        $this->cartNumber = $value;
        return $this;
    }

    public function getOrderId(): int
    {
        return $this->orderId;
    }

    public function setOrderId(int $value): static
    {
        $this->orderId = $value;
        return $this;
    }

    public function getTrackingId(): string
    {
        return HtmlDecode($this->trackingId);
    }

    public function setTrackingId(string $value): static
    {
        $this->trackingId = RemoveXss($value);
        return $this;
    }

    public function getBankRefNo(): string
    {
        return HtmlDecode($this->bankRefNo);
    }

    public function setBankRefNo(string $value): static
    {
        $this->bankRefNo = RemoveXss($value);
        return $this;
    }

    public function getOrderStatus(): string
    {
        return HtmlDecode($this->orderStatus);
    }

    public function setOrderStatus(string $value): static
    {
        $this->orderStatus = RemoveXss($value);
        return $this;
    }

    public function getFailureMessage(): string
    {
        return HtmlDecode($this->failureMessage);
    }

    public function setFailureMessage(string $value): static
    {
        $this->failureMessage = RemoveXss($value);
        return $this;
    }

    public function getPaymentMode(): string
    {
        return HtmlDecode($this->paymentMode);
    }

    public function setPaymentMode(string $value): static
    {
        $this->paymentMode = RemoveXss($value);
        return $this;
    }

    public function getCardName(): string
    {
        return HtmlDecode($this->cardName);
    }

    public function setCardName(string $value): static
    {
        $this->cardName = RemoveXss($value);
        return $this;
    }

    public function getStatusCode(): string
    {
        return HtmlDecode($this->statusCode);
    }

    public function setStatusCode(string $value): static
    {
        $this->statusCode = RemoveXss($value);
        return $this;
    }

    public function getStatusMessage(): string
    {
        return HtmlDecode($this->statusMessage);
    }

    public function setStatusMessage(string $value): static
    {
        $this->statusMessage = RemoveXss($value);
        return $this;
    }

    public function getAmount(): ?float
    {
        return $this->amount;
    }

    public function setAmount(?float $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getTransDate(): string
    {
        return HtmlDecode($this->transDate);
    }

    public function setTransDate(string $value): static
    {
        $this->transDate = RemoveXss($value);
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getPaymentGateway(): string
    {
        return HtmlDecode($this->paymentGateway);
    }

    public function setPaymentGateway(string $value): static
    {
        $this->paymentGateway = RemoveXss($value);
        return $this;
    }

    public function getPaymentSignature(): string
    {
        return HtmlDecode($this->paymentSignature);
    }

    public function setPaymentSignature(string $value): static
    {
        $this->paymentSignature = RemoveXss($value);
        return $this;
    }

    public function getCurrencyId(): int
    {
        return $this->currencyId;
    }

    public function setCurrencyId(int $value): static
    {
        $this->currencyId = $value;
        return $this;
    }
}
