<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "payment_plan_pending" table
 */
#[Entity]
#[Table(name: "payment_plan_pending")]
class PaymentPlanPending extends AbstractEntity
{
    #[Column(type: "smallint")]
    private int $location;

    #[Column(type: "smallint")]
    private int $process;

    #[Column(name: "design_id", type: "string", nullable: true)]
    private ?string $designId;

    #[Column(name: "product_type", type: "smallint", nullable: true)]
    private ?int $productType;

    #[Column(type: "integer", nullable: true)]
    private ?int $shape;

    #[Column(type: "integer", nullable: true)]
    private ?int $cs;

    public function __construct()
    {
        $this->location = 0;
        $this->cs = 0;
    }

    public function getLocation(): int
    {
        return $this->location;
    }

    public function setLocation(int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getProcess(): int
    {
        return $this->process;
    }

    public function setProcess(int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getDesignId(): ?string
    {
        return HtmlDecode($this->designId);
    }

    public function setDesignId(?string $value): static
    {
        $this->designId = RemoveXss($value);
        return $this;
    }

    public function getProductType(): ?int
    {
        return $this->productType;
    }

    public function setProductType(?int $value): static
    {
        $this->productType = $value;
        return $this;
    }

    public function getShape(): ?int
    {
        return $this->shape;
    }

    public function setShape(?int $value): static
    {
        $this->shape = $value;
        return $this;
    }

    public function getCs(): ?int
    {
        return $this->cs;
    }

    public function setCs(?int $value): static
    {
        $this->cs = $value;
        return $this;
    }
}
