<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "payment_plan_material" table
 */
#[Entity]
#[Table(name: "payment_plan_material")]
class PaymentPlanMaterial extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $location;

    #[Column(type: "integer", nullable: true)]
    private ?int $type;

    #[Column(type: "string", nullable: true)]
    private ?string $description;

    #[Column(name: "from_date", type: "datetime")]
    private DateTime $fromDate;

    #[Column(name: "to_date", type: "datetime")]
    private DateTime $toDate;

    #[Column(type: "string", nullable: true)]
    private ?string $grp;

    #[Column(name: "s_grp", type: "string", nullable: true)]
    private ?string $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $varient;

    #[Column(name: "varient_ref", type: "text", nullable: true)]
    private ?string $varientRef;

    #[Column(type: "text", nullable: true)]
    private ?string $product;

    #[Column(type: "text", nullable: true)]
    private ?string $rid;

    #[Column(type: "smallint", nullable: true)]
    private ?int $process;

    #[Column(name: "yes_no", type: "integer", nullable: true)]
    private ?int $yesNo;

    #[Column(type: "string", nullable: true)]
    private ?string $method;

    #[Column(name: "process_method", type: "smallint", nullable: true)]
    private ?int $processMethod;

    #[Column(name: "input_type", type: "smallint", nullable: true)]
    private ?int $inputType;

    #[Column(name: "output_type", type: "smallint", nullable: true)]
    private ?int $outputType;

    #[Column(type: "smallint")]
    private int $ply;

    #[Column(name: "`@`", options: ["name" => "@"], type: "float", nullable: true)]
    private ?float $40;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->type = 1;
        $this->grp = "3";
        $this->ply = 1;
        $this->40 = 0;
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLocation(): ?string
    {
        return HtmlDecode($this->location);
    }

    public function setLocation(?string $value): static
    {
        $this->location = RemoveXss($value);
        return $this;
    }

    public function getType(): ?int
    {
        return $this->type;
    }

    public function setType(?int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getFromDate(): DateTime
    {
        return $this->fromDate;
    }

    public function setFromDate(DateTime $value): static
    {
        $this->fromDate = $value;
        return $this;
    }

    public function getToDate(): DateTime
    {
        return $this->toDate;
    }

    public function setToDate(DateTime $value): static
    {
        $this->toDate = $value;
        return $this;
    }

    public function getGrp(): ?string
    {
        return HtmlDecode($this->grp);
    }

    public function setGrp(?string $value): static
    {
        $this->grp = RemoveXss($value);
        return $this;
    }

    public function getSGrp(): ?string
    {
        return HtmlDecode($this->sGrp);
    }

    public function setSGrp(?string $value): static
    {
        $this->sGrp = RemoveXss($value);
        return $this;
    }

    public function getVarient(): ?int
    {
        return $this->varient;
    }

    public function setVarient(?int $value): static
    {
        $this->varient = $value;
        return $this;
    }

    public function getVarientRef(): ?string
    {
        return HtmlDecode($this->varientRef);
    }

    public function setVarientRef(?string $value): static
    {
        $this->varientRef = RemoveXss($value);
        return $this;
    }

    public function getProduct(): ?string
    {
        return HtmlDecode($this->product);
    }

    public function setProduct(?string $value): static
    {
        $this->product = RemoveXss($value);
        return $this;
    }

    public function getRid(): ?string
    {
        return HtmlDecode($this->rid);
    }

    public function setRid(?string $value): static
    {
        $this->rid = RemoveXss($value);
        return $this;
    }

    public function getProcess(): ?int
    {
        return $this->process;
    }

    public function setProcess(?int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getYesNo(): ?int
    {
        return $this->yesNo;
    }

    public function setYesNo(?int $value): static
    {
        $this->yesNo = $value;
        return $this;
    }

    public function getMethod(): ?string
    {
        return HtmlDecode($this->method);
    }

    public function setMethod(?string $value): static
    {
        $this->method = RemoveXss($value);
        return $this;
    }

    public function getProcessMethod(): ?int
    {
        return $this->processMethod;
    }

    public function setProcessMethod(?int $value): static
    {
        $this->processMethod = $value;
        return $this;
    }

    public function getInputType(): ?int
    {
        return $this->inputType;
    }

    public function setInputType(?int $value): static
    {
        $this->inputType = $value;
        return $this;
    }

    public function getOutputType(): ?int
    {
        return $this->outputType;
    }

    public function setOutputType(?int $value): static
    {
        $this->outputType = $value;
        return $this;
    }

    public function getPly(): int
    {
        return $this->ply;
    }

    public function setPly(int $value): static
    {
        $this->ply = $value;
        return $this;
    }

    public function get40(): ?float
    {
        return $this->40;
    }

    public function set40(?float $value): static
    {
        $this->40 = $value;
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
